/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.function.Supplier;
import org.apache.ratis.io.CorruptedFileException;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MD5FileUtil;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotManager {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotManager.class);
    private static final String CORRUPT = ".corrupt";
    private static final String TMP = ".tmp";
    private final RaftStorage storage;
    private final RaftPeerId selfId;
    private final Supplier<MessageDigest> digester = JavaUtils.memoize(MD5Hash::getDigester);

    public SnapshotManager(RaftStorage storage, RaftPeerId selfId) {
        this.storage = storage;
        this.selfId = selfId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installSnapshot(StateMachine stateMachine, RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto snapshotChunkRequest = request.getSnapshotChunk();
        long lastIncludedIndex = snapshotChunkRequest.getTermIndex().getIndex();
        RaftStorageDirectory dir = this.storage.getStorageDir();
        File tmpDir = new File(dir.getTmpDir(), "snapshot-" + snapshotChunkRequest.getRequestId());
        FileUtils.createDirectories((File)tmpDir);
        tmpDir.deleteOnExit();
        LOG.info("Installing snapshot:{}, to tmp dir:{}", (Object)ServerStringUtils.toInstallSnapshotRequestString(request), (Object)tmpDir);
        Path stateMachineDir = dir.getStateMachineDir().toPath();
        for (RaftProtos.FileChunkProto chunk : snapshotChunkRequest.getFileChunksList()) {
            SnapshotInfo pi = stateMachine.getLatestSnapshot();
            if (pi != null && pi.getTermIndex().getIndex() >= lastIncludedIndex) {
                throw new IOException("There exists snapshot file " + pi.getFiles() + " in " + this.selfId + " with endIndex >= lastIncludedIndex " + lastIncludedIndex);
            }
            String fileName = chunk.getFilename();
            Path relative = stateMachineDir.relativize(new File(dir.getRoot(), fileName).toPath());
            File tmpSnapshotFile = new File(tmpDir, relative.toString());
            FileUtils.createDirectories((File)tmpSnapshotFile);
            FileOutputStream out = null;
            try {
                if (chunk.getOffset() == 0L) {
                    if (tmpSnapshotFile.exists()) {
                        FileUtils.deleteFully((File)tmpSnapshotFile);
                    }
                    out = new FileOutputStream(tmpSnapshotFile);
                } else {
                    Preconditions.assertTrue((boolean)tmpSnapshotFile.exists());
                    out = new FileOutputStream(tmpSnapshotFile, true);
                    FileChannel fc = out.getChannel();
                    fc.position(chunk.getOffset());
                }
                try (DigestOutputStream digestOut = new DigestOutputStream(out, this.digester.get());){
                    digestOut.write(chunk.getData().toByteArray());
                }
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{out});
            if (!chunk.getDone()) continue;
            MD5Hash expectedDigest = new MD5Hash(chunk.getFileDigest().toByteArray());
            MD5Hash digest = new MD5Hash(this.digester.get().digest());
            if (!digest.equals((Object)expectedDigest)) {
                String renameMessage;
                LOG.warn("The snapshot md5 digest {} does not match expected {}", (Object)digest, (Object)expectedDigest);
                try {
                    File corruptedFile = FileUtils.move((File)tmpSnapshotFile, (String)(CORRUPT + StringUtils.currentDateTime()));
                    renameMessage = "Renamed temporary snapshot file " + tmpSnapshotFile + " to " + corruptedFile;
                }
                catch (IOException e) {
                    renameMessage = "Tried but failed to rename temporary snapshot file " + tmpSnapshotFile + " to a " + CORRUPT + " file";
                    LOG.warn(renameMessage, (Throwable)e);
                    renameMessage = renameMessage + ": " + e;
                }
                throw new CorruptedFileException(tmpSnapshotFile, "MD5 mismatch for snapshot-" + lastIncludedIndex + " installation.  " + renameMessage);
            }
            MD5FileUtil.saveMD5File((File)tmpSnapshotFile, (MD5Hash)digest);
        }
        if (snapshotChunkRequest.getDone()) {
            SnapshotManager.rename(tmpDir, dir.getStateMachineDir());
        }
    }

    private static void rename(File tmpDir, File stateMachineDir) throws IOException {
        File existingDir;
        LOG.info("Installed snapshot, renaming temporary dir {} to {}", (Object)tmpDir, (Object)stateMachineDir);
        if (stateMachineDir.exists()) {
            File moved = null;
            try {
                moved = FileUtils.move((File)stateMachineDir, (String)(TMP + StringUtils.currentDateTime()));
            }
            catch (IOException e) {
                LOG.warn("Failed to rename state machine directory " + stateMachineDir.getAbsolutePath() + " to a " + TMP + " directory.  Try deleting it directly.", (Throwable)e);
                FileUtils.deleteFully((File)stateMachineDir);
            }
            existingDir = moved;
        } else {
            existingDir = null;
        }
        try {
            FileUtils.move((File)tmpDir, (File)stateMachineDir);
        }
        catch (IOException e) {
            throw new IOException("Failed to rename temporary director " + tmpDir.getAbsolutePath() + " to " + stateMachineDir.getAbsolutePath(), e);
        }
        if (existingDir != null) {
            try {
                FileUtils.deleteFully(existingDir);
            }
            catch (IOException e) {
                LOG.warn("Failed to delete existing directory " + existingDir.getAbsolutePath(), (Throwable)e);
            }
        }
    }
}

