/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.SnapshotManagementRequestHandler;
import org.apache.ratis.server.impl.TransferLeadership;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SnapshotManagementRequestHandler {
    public static final Logger LOG = LoggerFactory.getLogger(TransferLeadership.class);
    private final RaftServerImpl server;
    private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();
    private final PendingRequestReference pending = new PendingRequestReference();

    SnapshotManagementRequestHandler(RaftServerImpl server) {
        this.server = server;
    }

    CompletableFuture<RaftClientReply> takingSnapshotAsync(SnapshotManagementRequest request) {
        MemoizedSupplier supplier = JavaUtils.memoize(() -> new PendingRequest(this, request));
        PendingRequest previous = this.pending.getAndUpdate((Supplier)supplier);
        if (previous != null) {
            return previous.getReplyFuture();
        }
        this.server.getState().notifyStateMachineUpdater();
        this.scheduler.onTimeout(TimeDuration.valueOf((long)request.getTimeoutMs(), (TimeUnit)TimeUnit.MILLISECONDS), () -> this.timeout(), LOG, () -> "Timeout check failed for snapshot request: " + request);
        return ((PendingRequest)supplier.get()).getReplyFuture();
    }

    boolean shouldTriggerTakingSnapshot() {
        return this.pending.get().map(PendingRequest::shouldTriggerTakingSnapshot).orElse(false);
    }

    void completeTakingSnapshot(long index) {
        this.pending.getAndSetNull().ifPresent(p -> p.complete(index));
    }

    void timeout() {
        this.pending.getAndSetNull().ifPresent(PendingRequest::timeout);
    }

    static /* synthetic */ RaftServerImpl access$000(SnapshotManagementRequestHandler x0) {
        return x0.server;
    }
}

