/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.TransferLeadership;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferLeadership {
    public static final Logger LOG = LoggerFactory.getLogger(TransferLeadership.class);
    private final RaftServerImpl server;
    private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();
    private final AtomicReference<PendingRequest> pending = new AtomicReference();

    TransferLeadership(RaftServerImpl server) {
        this.server = server;
    }

    boolean isSteppingDown() {
        return this.pending.get() != null;
    }

    CompletableFuture<RaftClientReply> start(TransferLeadershipRequest request) {
        MemoizedSupplier supplier = JavaUtils.memoize(() -> new PendingRequest(this, request));
        PendingRequest previous = (PendingRequest)this.pending.getAndUpdate(f -> f != null ? f : (PendingRequest)supplier.get());
        if (previous != null) {
            if (request.getNewLeader().equals((Object)previous.getRequest().getNewLeader())) {
                CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture<RaftClientReply>();
                previous.getReplyFuture().whenComplete((r, e) -> {
                    if (e != null) {
                        replyFuture.completeExceptionally((Throwable)e);
                    } else {
                        replyFuture.complete(r.isSuccess() ? this.server.newSuccessReply((RaftClientRequest)request) : this.server.newExceptionReply((RaftClientRequest)request, r.getException()));
                    }
                });
                return replyFuture;
            }
            TransferLeadershipException tle = new TransferLeadershipException(this.server.getMemberId() + "Failed to transfer leadership to " + request.getNewLeader() + ": a previous " + previous + " exists");
            return CompletableFuture.completedFuture(this.server.newExceptionReply((RaftClientRequest)request, (RaftException)tle));
        }
        this.scheduler.onTimeout(TimeDuration.valueOf((long)request.getTimeoutMs(), (TimeUnit)TimeUnit.MILLISECONDS), () -> this.finish(this.server.getState().getLeaderId(), true), LOG, () -> "Timeout check failed for append entry request: " + request);
        return ((PendingRequest)supplier.get()).getReplyFuture();
    }

    void finish(RaftPeerId currentLeader, boolean timeout) {
        Optional.ofNullable(this.pending.getAndSet(null)).ifPresent(r -> r.complete(currentLeader, timeout));
    }

    static /* synthetic */ RaftServerImpl access$000(TransferLeadership x0) {
        return x0.server;
    }
}

