/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class LogProtoUtils {
    private LogProtoUtils() {
    }

    public static String toLogEntryString(RaftProtos.LogEntryProto entry, Function<RaftProtos.StateMachineLogEntryProto, String> function) {
        String s;
        if (entry == null) {
            return null;
        }
        if (entry.hasStateMachineLogEntry()) {
            s = ", " + (String)Optional.ofNullable(function).orElseGet(() -> proto -> "" + ClientInvocationId.valueOf((RaftProtos.StateMachineLogEntryProto)proto)).apply(entry.getStateMachineLogEntry());
        } else if (entry.hasMetadataEntry()) {
            RaftProtos.MetadataProto metadata = entry.getMetadataEntry();
            s = "(c:" + metadata.getCommitIndex() + ")";
        } else if (entry.hasConfigurationEntry()) {
            RaftProtos.RaftConfigurationProto config = entry.getConfigurationEntry();
            s = "(current:" + config.getPeersList().stream().map(p -> p.toString()).collect(Collectors.joining(",")) + ", old:" + config.getOldPeersList().stream().map(p -> p.toString()).collect(Collectors.joining(",")) + ")";
        } else {
            s = "";
        }
        return TermIndex.valueOf((RaftProtos.LogEntryProto)entry) + ", " + entry.getLogEntryBodyCase() + s;
    }

    public static String toLogEntryString(RaftProtos.LogEntryProto entry) {
        return LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entry, null);
    }

    public static String toLogEntriesString(List<RaftProtos.LogEntryProto> entries) {
        return entries == null ? null : entries.stream().map(LogProtoUtils::toLogEntryString).collect(Collectors.toList()).toString();
    }

    public static String toLogEntriesShortString(List<RaftProtos.LogEntryProto> entries) {
        return entries == null ? null : (entries.size() == 0 ? "<empty>" : "size=" + entries.size() + ", first=" + LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entries.get(0)));
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(RaftConfiguration conf, Long term, long index) {
        RaftProtos.LogEntryProto.Builder b = RaftProtos.LogEntryProto.newBuilder();
        Optional.ofNullable(term).ifPresent(arg_0 -> ((RaftProtos.LogEntryProto.Builder)b).setTerm(arg_0));
        return b.setIndex(index).setConfigurationEntry(LogProtoUtils.toRaftConfigurationProtoBuilder((RaftConfiguration)conf)).build();
    }

    private static RaftProtos.RaftConfigurationProto.Builder toRaftConfigurationProtoBuilder(RaftConfiguration conf) {
        return RaftProtos.RaftConfigurationProto.newBuilder().addAllPeers(ProtoUtils.toRaftPeerProtos((Collection)conf.getCurrentPeers())).addAllListeners(ProtoUtils.toRaftPeerProtos((Collection)conf.getCurrentPeers(RaftProtos.RaftPeerRole.LISTENER))).addAllOldPeers(ProtoUtils.toRaftPeerProtos((Collection)conf.getPreviousPeers())).addAllOldListeners(ProtoUtils.toRaftPeerProtos((Collection)conf.getPreviousPeers(RaftProtos.RaftPeerRole.LISTENER)));
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(RaftProtos.StateMachineLogEntryProto proto, long term, long index) {
        return RaftProtos.LogEntryProto.newBuilder().setTerm(term).setIndex(index).setStateMachineLogEntry(proto).build();
    }

    public static RaftProtos.LogEntryProto toLogEntryProto(long commitIndex, long term, long index) {
        return RaftProtos.LogEntryProto.newBuilder().setTerm(term).setIndex(index).setMetadataEntry(RaftProtos.MetadataProto.newBuilder().setCommitIndex(commitIndex)).build();
    }

    public static RaftProtos.LogEntryProto removeStateMachineData(RaftProtos.LogEntryProto entry) {
        return LogProtoUtils.getStateMachineEntry((RaftProtos.LogEntryProto)entry).map(RaftProtos.StateMachineEntryProto::getStateMachineData).filter(stateMachineData -> !stateMachineData.isEmpty()).map(_dummy -> LogProtoUtils.replaceStateMachineDataWithSerializedSize((RaftProtos.LogEntryProto)entry)).orElse(entry);
    }

    private static RaftProtos.LogEntryProto replaceStateMachineDataWithSerializedSize(RaftProtos.LogEntryProto entry) {
        return LogProtoUtils.replaceStateMachineEntry((RaftProtos.LogEntryProto)entry, (RaftProtos.StateMachineEntryProto.Builder)RaftProtos.StateMachineEntryProto.newBuilder().setLogEntryProtoSerializedSize(entry.getSerializedSize()));
    }

    private static RaftProtos.LogEntryProto replaceStateMachineEntry(RaftProtos.LogEntryProto proto, RaftProtos.StateMachineEntryProto.Builder newEntry) {
        Preconditions.assertTrue((boolean)proto.hasStateMachineLogEntry(), () -> "Unexpected proto " + proto);
        return RaftProtos.LogEntryProto.newBuilder((RaftProtos.LogEntryProto)proto).setStateMachineLogEntry(RaftProtos.StateMachineLogEntryProto.newBuilder((RaftProtos.StateMachineLogEntryProto)proto.getStateMachineLogEntry()).setStateMachineEntry(newEntry)).build();
    }

    static RaftProtos.LogEntryProto addStateMachineData(ByteString stateMachineData, RaftProtos.LogEntryProto entry) {
        Preconditions.assertTrue((boolean)LogProtoUtils.isStateMachineDataEmpty((RaftProtos.LogEntryProto)entry), () -> "Failed to addStateMachineData to " + entry + " since shouldReadStateMachineData is false.");
        return LogProtoUtils.replaceStateMachineEntry((RaftProtos.LogEntryProto)entry, (RaftProtos.StateMachineEntryProto.Builder)RaftProtos.StateMachineEntryProto.newBuilder().setStateMachineData(stateMachineData));
    }

    public static boolean isStateMachineDataEmpty(RaftProtos.LogEntryProto entry) {
        return LogProtoUtils.getStateMachineEntry((RaftProtos.LogEntryProto)entry).map(RaftProtos.StateMachineEntryProto::getStateMachineData).map(ByteString::isEmpty).orElse(false);
    }

    private static Optional<RaftProtos.StateMachineEntryProto> getStateMachineEntry(RaftProtos.LogEntryProto entry) {
        return Optional.of(entry).filter(RaftProtos.LogEntryProto::hasStateMachineLogEntry).map(RaftProtos.LogEntryProto::getStateMachineLogEntry).filter(RaftProtos.StateMachineLogEntryProto::hasStateMachineEntry).map(RaftProtos.StateMachineLogEntryProto::getStateMachineEntry);
    }

    public static int getSerializedSize(RaftProtos.LogEntryProto entry) {
        return LogProtoUtils.getStateMachineEntry((RaftProtos.LogEntryProto)entry).filter(stateMachineEntry -> stateMachineEntry.getStateMachineData().isEmpty()).map(RaftProtos.StateMachineEntryProto::getLogEntryProtoSerializedSize).orElseGet(() -> ((RaftProtos.LogEntryProto)entry).getSerializedSize());
    }

    private static RaftProtos.StateMachineLogEntryProto.Type toStateMachineLogEntryProtoType(RaftProtos.RaftClientRequestProto.TypeCase type) {
        switch (1.$SwitchMap$org$apache$ratis$proto$RaftProtos$RaftClientRequestProto$TypeCase[type.ordinal()]) {
            case 1: {
                return RaftProtos.StateMachineLogEntryProto.Type.WRITE;
            }
            case 2: {
                return RaftProtos.StateMachineLogEntryProto.Type.DATASTREAM;
            }
        }
        throw new IllegalStateException("Unexpected request type " + type);
    }

    public static RaftProtos.StateMachineLogEntryProto toStateMachineLogEntryProto(RaftClientRequest request, ByteString logData, ByteString stateMachineData) {
        if (logData == null) {
            logData = request.getMessage().getContent();
        }
        RaftProtos.StateMachineLogEntryProto.Type type = LogProtoUtils.toStateMachineLogEntryProtoType((RaftProtos.RaftClientRequestProto.TypeCase)request.getType().getTypeCase());
        return LogProtoUtils.toStateMachineLogEntryProto((ClientId)request.getClientId(), (long)request.getCallId(), (RaftProtos.StateMachineLogEntryProto.Type)type, (ByteString)logData, (ByteString)stateMachineData);
    }

    public static RaftProtos.StateMachineLogEntryProto toStateMachineLogEntryProto(ClientId clientId, long callId, RaftProtos.StateMachineLogEntryProto.Type type, ByteString logData, ByteString stateMachineData) {
        RaftProtos.StateMachineLogEntryProto.Builder b = RaftProtos.StateMachineLogEntryProto.newBuilder().setClientId(clientId.toByteString()).setCallId(callId).setType(type).setLogData(logData);
        Optional.ofNullable(stateMachineData).map(arg_0 -> ((RaftProtos.StateMachineEntryProto.Builder)RaftProtos.StateMachineEntryProto.newBuilder()).setStateMachineData(arg_0)).ifPresent(arg_0 -> ((RaftProtos.StateMachineLogEntryProto.Builder)b).setStateMachineEntry(arg_0));
        return b.build();
    }

    public static RaftConfiguration toRaftConfiguration(RaftProtos.LogEntryProto entry) {
        Preconditions.assertTrue((boolean)entry.hasConfigurationEntry());
        RaftProtos.RaftConfigurationProto proto = entry.getConfigurationEntry();
        List conf = ProtoUtils.toRaftPeers((List)proto.getPeersList());
        List listener = ProtoUtils.toRaftPeers((List)proto.getListenersList());
        List oldConf = ProtoUtils.toRaftPeers((List)proto.getOldPeersList());
        List oldListener = ProtoUtils.toRaftPeers((List)proto.getOldListenersList());
        return ServerImplUtils.newRaftConfiguration((List)conf, (List)listener, (long)entry.getIndex(), (List)oldConf, (List)oldListener);
    }
}

