/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.SimpleStateMachine4Testing;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.FileListSnapshotInfo;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.LifeCycle;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstallSnapshotFromLeaderTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final Logger LOG = LoggerFactory.getLogger(InstallSnapshotFromLeaderTests.class);
    private static final int SNAPSHOT_TRIGGER_THRESHOLD = 64;
    private static final int PURGE_GAP = 8;

    public InstallSnapshotFromLeaderTests() {
        RaftProperties prop = this.getProperties();
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)prop, (int)8);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)prop, (long)64L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)prop, (boolean)true);
    }

    @Test
    public void testMultiFileInstallSnapshot() throws Exception {
        this.getProperties().setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachineWithMultiNestedSnapshotFile.class, StateMachine.class);
        this.runWithNewCluster(1, this::testMultiFileInstallSnapshot);
    }

    @Test
    public void testSeparateSnapshotInstallPath() throws Exception {
        this.getProperties().setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachineWithSeparatedSnapshotPath.class, StateMachine.class);
        this.runWithNewCluster(1, this::testMultiFileInstallSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMultiFileInstallSnapshot(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeader().getId();
            try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
                for (int i = 0; i < 127; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
                client.getSnapshotManagementApi(leaderId).create(3000L);
            }
            SnapshotInfo snapshot = ((MiniRaftCluster)cluster).getLeader().getStateMachine().getLatestSnapshot();
            Assert.assertEquals((long)3L, (long)snapshot.getFiles().size());
            MiniRaftCluster.PeerChanges change = ((MiniRaftCluster)cluster).addNewPeers(2, true, true);
            ((MiniRaftCluster)cluster).setConfiguration(change.allPeersInNewConf);
            RaftServerTestUtil.waitAndCheckNewConf(cluster, change.allPeersInNewConf, 0, null);
            for (RaftServer.Division follower : ((MiniRaftCluster)cluster).getFollowers()) {
                Assert.assertEquals((long)3L, (long)follower.getStateMachine().getLatestSnapshot().getFiles().size());
            }
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    private static class StateMachineWithSeparatedSnapshotPath
    extends SimpleStateMachine4Testing {
        private File root;
        private File snapshotDir;
        private File tmpDir;

        private StateMachineWithSeparatedSnapshotPath() {
        }

        @Override
        public synchronized void initialize(RaftServer server, RaftGroupId groupId, RaftStorage raftStorage) throws IOException {
            super.initialize(server, groupId, raftStorage);
            this.root = new File("/tmp/ratis-tests/statemachine/" + this.getId().toString());
            this.snapshotDir = new File(this.root, "snapshot");
            this.tmpDir = new File(this.root, "tmp");
            FileUtils.deleteFully((File)this.root);
            Assert.assertTrue((boolean)this.snapshotDir.mkdirs());
            Assert.assertTrue((boolean)this.tmpDir.mkdirs());
            this.root.deleteOnExit();
        }

        @Override
        public synchronized void pause() {
            if (this.getLifeCycle().getCurrentState() == LifeCycle.State.RUNNING) {
                this.getLifeCycle().transition(LifeCycle.State.PAUSING);
                this.getLifeCycle().transition(LifeCycle.State.PAUSED);
            }
        }

        @Override
        public long takeSnapshot() {
            TermIndex lastApplied = this.getLastAppliedTermIndex();
            File snapshotTmpDir = new File(this.tmpDir, UUID.randomUUID().toString());
            File snapshotRealDir = new File(this.snapshotDir, String.format("%d_%d", lastApplied.getTerm(), lastApplied.getIndex()));
            try {
                FileUtils.deleteFully((File)snapshotRealDir);
                FileUtils.deleteFully((File)snapshotTmpDir);
                Assert.assertTrue((boolean)snapshotTmpDir.mkdirs());
                File snapshotFile1 = new File(snapshotTmpDir, "deer");
                File snapshotFile2 = new File(snapshotTmpDir, "loves");
                File snapshotFile3 = new File(snapshotTmpDir, "vegetable");
                Assert.assertTrue((boolean)snapshotFile1.createNewFile());
                Assert.assertTrue((boolean)snapshotFile2.createNewFile());
                Assert.assertTrue((boolean)snapshotFile3.createNewFile());
                FileUtils.move((File)snapshotTmpDir, (File)snapshotRealDir);
            }
            catch (IOException ioe) {
                LOG.error("create snapshot data file failed", (Throwable)ioe);
                return -1L;
            }
            return lastApplied.getIndex();
        }

        public SnapshotInfo getLatestSnapshot() {
            Path[] sortedSnapshots = this.getSortedSnapshotDirPaths();
            if (sortedSnapshots == null || sortedSnapshots.length == 0) {
                return null;
            }
            File latest = sortedSnapshots[sortedSnapshots.length - 1].toFile();
            TermIndex snapshotLastIncluded = TermIndex.valueOf((long)Long.parseLong(latest.getName().split("_")[0]), (long)Long.parseLong(latest.getName().split("_")[1]));
            ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
            for (File f : Objects.requireNonNull(latest.listFiles())) {
                if (f.getName().endsWith(".md5")) continue;
                fileInfos.add(new FileInfo(f.toPath(), null));
            }
            return new FileListSnapshotInfo(fileInfos, snapshotLastIncluded.getTerm(), snapshotLastIncluded.getIndex());
        }

        private Path[] getSortedSnapshotDirPaths() {
            ArrayList<Path> snapshotPaths = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.snapshotDir.toPath());){
                for (Path path : stream) {
                    if (!path.toFile().isDirectory()) continue;
                    snapshotPaths.add(path);
                }
            }
            catch (IOException exception) {
                LOG.warn("cannot construct snapshot directory stream ", (Throwable)exception);
                return null;
            }
            Path[] pathArray = snapshotPaths.toArray(new Path[0]);
            Arrays.sort(pathArray, (o1, o2) -> {
                String index1 = o1.toFile().getName().split("_")[1];
                String index2 = o2.toFile().getName().split("_")[1];
                return Long.compare(Long.parseLong(index1), Long.parseLong(index2));
            });
            return pathArray;
        }

        @Override
        public SimpleStateMachineStorage getStateMachineStorage() {
            return new SeparateSnapshotStateMachineStorage();
        }

        private class SeparateSnapshotStateMachineStorage
        extends SimpleStateMachineStorage {
            private SeparateSnapshotStateMachineStorage() {
            }

            public File getSnapshotDir() {
                return StateMachineWithSeparatedSnapshotPath.this.snapshotDir;
            }

            public File getTmpDir() {
                return StateMachineWithSeparatedSnapshotPath.this.tmpDir;
            }
        }
    }

    private static class StateMachineWithMultiNestedSnapshotFile
    extends SimpleStateMachine4Testing {
        File snapshotRoot;
        File file1;
        File file2;

        private StateMachineWithMultiNestedSnapshotFile() {
        }

        @Override
        public synchronized void initialize(RaftServer server, RaftGroupId groupId, RaftStorage raftStorage) throws IOException {
            super.initialize(server, groupId, raftStorage);
            this.snapshotRoot = new File(this.getSMdir(), "snapshot");
            FileUtils.deleteFully((File)this.snapshotRoot);
            this.file1 = new File(this.snapshotRoot, "1.bin");
            this.file2 = new File(new File(this.snapshotRoot, "sub"), "2.bin");
        }

        @Override
        public synchronized void pause() {
            if (this.getLifeCycle().getCurrentState() == LifeCycle.State.RUNNING) {
                this.getLifeCycle().transition(LifeCycle.State.PAUSING);
                this.getLifeCycle().transition(LifeCycle.State.PAUSED);
            }
        }

        @Override
        public long takeSnapshot() {
            TermIndex termIndex = this.getLastAppliedTermIndex();
            if (termIndex.getTerm() <= 0L || termIndex.getIndex() <= 0L) {
                return -1L;
            }
            long endIndex = termIndex.getIndex();
            try {
                if (!this.snapshotRoot.exists()) {
                    FileUtils.createDirectories((File)this.snapshotRoot);
                    FileUtils.createDirectories((File)this.file1.getParentFile());
                    FileUtils.createDirectories((File)this.file2.getParentFile());
                    FileUtils.createNewFile((Path)this.file1.toPath());
                    FileUtils.createNewFile((Path)this.file2.toPath());
                }
            }
            catch (IOException ioException) {
                return -1L;
            }
            Assert.assertTrue((boolean)this.file1.exists());
            Assert.assertTrue((boolean)this.file2.exists());
            return super.takeSnapshot();
        }

        public SnapshotInfo getLatestSnapshot() {
            if (!(this.snapshotRoot.exists() && this.file1.exists() && this.file2.exists())) {
                return null;
            }
            ArrayList<Object> files = new ArrayList<Object>();
            files.add(new FileInfo(this.file1.toPath(), null));
            files.add(new FileInfo(this.file2.toPath(), null));
            Assert.assertEquals((long)2L, (long)files.size());
            SnapshotInfo info = super.getLatestSnapshot();
            if (info == null) {
                return null;
            }
            files.add(info.getFiles().get(0));
            return new FileListSnapshotInfo(files, info.getTerm(), info.getIndex());
        }
    }
}

