/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RetryCacheTestUtil;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public abstract class RetryCacheTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public static final int NUM_SERVERS = 3;

    @Test
    public void testBasicRetry() throws Exception {
        this.runWithNewCluster(3, this::runTestBasicRetry);
    }

    void runTestBasicRetry(CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeaderAndSendFirstMessage(false).getId();
        long oldLastApplied = ((MiniRaftCluster)cluster).getLeader().getInfo().getLastAppliedIndex();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftClientRequest r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), leaderId, 999L, new RaftTestUtil.SimpleMessage("message"));
            RetryCacheTests.assertReply(rpc.sendRequest(r), client, 999L);
            for (int i = 0; i < 5; ++i) {
                RetryCacheTests.assertReply(rpc.sendRequest(r), client, 999L);
            }
            this.assertServer((MiniRaftCluster)cluster, client.getId(), 999L, oldLastApplied);
        }
    }

    public static RaftClient assertReply(RaftClientReply reply, RaftClient client, long callId) {
        Assert.assertEquals((Object)client.getId(), (Object)reply.getClientId());
        Assert.assertEquals((long)callId, (long)reply.getCallId());
        Assert.assertTrue((boolean)reply.isSuccess());
        return client;
    }

    public void assertServer(MiniRaftCluster cluster, ClientId clientId, long callId, long oldLastApplied) throws Exception {
        long leaderApplied = cluster.getLeader().getInfo().getLastAppliedIndex();
        for (RaftServer.Division server : cluster.iterateDivisions()) {
            this.LOG.info("check server " + server.getId());
            if (server.getInfo().getLastAppliedIndex() < leaderApplied) {
                Thread.sleep(1000L);
            }
            Assert.assertEquals((long)2L, (long)server.getRetryCache().getStatistics().size());
            Assert.assertNotNull((Object)RetryCacheTestUtil.get(server, clientId, callId));
            Assert.assertEquals((long)1L, (long)RetryCacheTests.count(server.getRaftLog(), oldLastApplied + 1L));
        }
    }

    static int count(RaftLog log, long startIndex) throws RaftLogIOException {
        long nextIndex = log.getNextIndex();
        int count = 0;
        for (long i = startIndex; i < nextIndex; ++i) {
            if (!log.get(i).hasStateMachineLogEntry()) continue;
            ++count;
        }
        return count;
    }

    @Test
    public void testRetryOnNewLeader() throws Exception {
        this.runWithNewCluster(3, this::runTestRetryOnNewLeader);
    }

    void runTestRetryOnNewLeader(CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeaderAndSendFirstMessage(false).getId();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftClientRequest r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), leaderId, 999L, new RaftTestUtil.SimpleMessage("message"));
            RetryCacheTests.assertReply(rpc.sendRequest(r), client, 999L);
            long oldLastApplied = ((MiniRaftCluster)cluster).getLeader().getInfo().getLastAppliedIndex();
            MiniRaftCluster.PeerChanges change = ((MiniRaftCluster)cluster).addNewPeers(2, true);
            RaftPeer[] allPeers = ((MiniRaftCluster)cluster).removePeers((int)2, (boolean)true, Arrays.asList(change.newPeers)).allPeersInNewConf;
            ((MiniRaftCluster)cluster).setConfiguration(allPeers);
            RaftPeerId newLeaderId = (RaftPeerId)JavaUtils.attemptRepeatedly(() -> {
                RaftPeerId id = RaftTestUtil.waitForLeader(cluster).getId();
                Assert.assertNotEquals((Object)leaderId, (Object)id);
                return id;
            }, (int)10, (TimeDuration)TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS), (String)("wait for a leader different than " + leaderId), (Logger)this.LOG);
            Assert.assertNotEquals((Object)leaderId, (Object)newLeaderId);
            r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), newLeaderId, 999L, new RaftTestUtil.SimpleMessage("message"));
            rpc.addRaftPeers(Arrays.asList(change.newPeers));
            for (int i = 0; i < 10; ++i) {
                try {
                    RetryCacheTests.assertReply(rpc.sendRequest(r), client, 999L);
                    this.LOG.info("successfully sent out the retry request_" + i);
                }
                catch (Exception e) {
                    this.LOG.info("hit exception while retrying the same request: " + r, (Throwable)e);
                }
                Thread.sleep(100L);
            }
            Assert.assertEquals((long)0L, (long)RetryCacheTests.count(((MiniRaftCluster)cluster).getLeader().getRaftLog(), oldLastApplied + 1L));
        }
    }

    static {
        Log4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
    }
}

