/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.server.DataStreamMap;
import org.apache.ratis.server.DataStreamServer;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.ConfigurationManager;
import org.apache.ratis.server.impl.DataStreamMapImpl;
import org.apache.ratis.server.impl.DataStreamServerImpl;
import org.apache.ratis.server.impl.DelayLocalExecutionInjection;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.impl.StateMachineUpdater;
import org.apache.ratis.server.impl.WatchRequests;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftServerTestUtil {
    static final Logger LOG = LoggerFactory.getLogger(RaftServerTestUtil.class);
    public static final RaftGroupMemberId TEST_MEMBER_ID = RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((String)"test"), (RaftGroupId)RaftGroupId.emptyGroupId());

    public static DelayLocalExecutionInjection getLogSyncDelay() {
        return new DelayLocalExecutionInjection(RaftServerImpl.LOG_SYNC);
    }

    public static void setStateMachineUpdaterLogLevel(Level level) {
        Log4jUtils.setLogLevel((Logger)StateMachineUpdater.LOG, (Level)level);
    }

    public static void setWatchRequestsLogLevel(Level level) {
        Log4jUtils.setLogLevel((Logger)WatchRequests.LOG, (Level)level);
    }

    public static void setPendingRequestsLogLevel(Level level) {
        Log4jUtils.setLogLevel((Logger)PendingRequests.LOG, (Level)level);
    }

    public static void waitAndCheckNewConf(MiniRaftCluster cluster, RaftPeer[] peers, int numOfNewPeers, int numOfRemovedPeers, Collection<RaftPeerId> deadPeers) throws Exception {
        TimeDuration sleepTime = cluster.getTimeoutMax().apply(n -> n * (long)(numOfRemovedPeers + numOfNewPeers + 2));
        JavaUtils.attempt(() -> RaftServerTestUtil.waitAndCheckNewConf(cluster, Arrays.asList(peers), deadPeers), (int)10, (TimeDuration)sleepTime, (String)"waitAndCheckNewConf", (Logger)LOG);
    }

    public static void waitAndCheckNewConf(MiniRaftCluster cluster, RaftPeer[] peers, int numOfRemovedPeers, Collection<RaftPeerId> deadPeers) throws Exception {
        TimeDuration sleepTime = cluster.getTimeoutMax().apply(n -> n * (long)(numOfRemovedPeers + 2));
        JavaUtils.attempt(() -> RaftServerTestUtil.waitAndCheckNewConf(cluster, Arrays.asList(peers), deadPeers), (int)10, (TimeDuration)sleepTime, (String)"waitAndCheckNewConf", (Logger)LOG);
    }

    private static void waitAndCheckNewConf(MiniRaftCluster cluster, Collection<RaftPeer> peers, Collection<RaftPeerId> deadPeers) {
        LOG.info("waitAndCheckNewConf: peers={}, deadPeers={}, {}", new Object[]{peers, deadPeers, cluster.printServers()});
        Assert.assertNotNull((Object)cluster.getLeader());
        int numIncluded = 0;
        int deadIncluded = 0;
        RaftConfigurationImpl current = RaftConfigurationImpl.newBuilder().setConf(peers).setLogEntryIndex(0L).build();
        for (RaftServer.Division d : cluster.iterateDivisions()) {
            RaftServerImpl server = (RaftServerImpl)d;
            LOG.info("checking {}", (Object)server);
            if (deadPeers != null && deadPeers.contains(server.getId())) {
                if (!current.containsInConf(server.getId(), new RaftProtos.RaftPeerRole[0])) continue;
                ++deadIncluded;
                continue;
            }
            RaftConfigurationImpl conf = server.getState().getRaftConf();
            if (current.containsInConf(server.getId(), new RaftProtos.RaftPeerRole[0])) {
                ++numIncluded;
                Assert.assertTrue((boolean)conf.isStable());
                Assert.assertTrue((boolean)conf.hasNoChange(peers, Collections.emptyList()));
                continue;
            }
            if (!server.getInfo().isAlive()) continue;
            Assert.assertTrue((boolean)conf.isStable());
            Assert.assertFalse((boolean)conf.containsInConf(server.getId(), new RaftProtos.RaftPeerRole[0]));
        }
        Assert.assertEquals((long)peers.size(), (long)(numIncluded + deadIncluded));
    }

    public static long getNextIndex(RaftServer.Division server) {
        return ((RaftServerImpl)server).getState().getNextIndex();
    }

    public static long getLatestInstalledSnapshotIndex(RaftServer.Division server) {
        return ((RaftServerImpl)server).getState().getLatestInstalledSnapshotIndex();
    }

    static ServerState getState(RaftServer.Division server) {
        return ((RaftServerImpl)server).getState();
    }

    public static ConfigurationManager getConfigurationManager(RaftServer.Division server) {
        return (ConfigurationManager)RaftTestUtil.getDeclaredField(RaftServerTestUtil.getState(server), "configurationManager");
    }

    public static RaftConfiguration newRaftConfiguration(Collection<RaftPeer> peers) {
        return RaftConfigurationImpl.newBuilder().setConf(peers).build();
    }

    public static RaftServerRpc getServerRpc(RaftServer.Division server) {
        return ((RaftServerImpl)server).getRaftServer().getServerRpc();
    }

    private static Optional<LeaderStateImpl> getLeaderState(RaftServer.Division server) {
        return ((RaftServerImpl)server).getRole().getLeaderState();
    }

    public static Stream<LogAppender> getLogAppenders(RaftServer.Division server) {
        return RaftServerTestUtil.getLeaderState(server).map(LeaderStateImpl::getLogAppenders).orElse(null);
    }

    public static void restartLogAppenders(RaftServer.Division server) {
        LeaderStateImpl leaderState = RaftServerTestUtil.getLeaderState(server).orElseThrow(() -> new IllegalStateException(server + " is not the leader"));
        leaderState.getLogAppenders().forEach(arg_0 -> ((LeaderStateImpl)leaderState).restart(arg_0));
    }

    public static RaftServer.Division getDivision(RaftServer server, RaftGroupId groupId) {
        return (RaftServer.Division)JavaUtils.callAsUnchecked(() -> server.getDivision(groupId));
    }

    public static DataStreamServer newDataStreamServer(RaftServer server) {
        return new DataStreamServerImpl(server, null);
    }

    public static DataStreamMap newDataStreamMap(Object name) {
        return new DataStreamMapImpl(name);
    }

    public static void assertLostMajorityHeartbeatsRecently(RaftServer.Division leader) {
        FollowerState f = ((RaftServerImpl)leader).getRole().getFollowerState().orElse(null);
        Assert.assertNotNull((Object)f);
        Assert.assertTrue((boolean)f.lostMajorityHeartbeatsRecently());
    }

    public static SegmentedRaftLog newSegmentedRaftLog(RaftGroupMemberId memberId, DivisionInfo info, RaftStorage storage, RaftProperties properties) {
        RaftServerImpl server = (RaftServerImpl)Mockito.mock(RaftServerImpl.class);
        Mockito.when((Object)server.getInfo()).thenReturn((Object)info);
        return new SegmentedRaftLog(memberId, (RaftServer.Division)server, null, arg_0 -> ((RaftServerImpl)server).notifyTruncatedLogEntry(arg_0), () -> ((RaftServerImpl)server).submitUpdateCommitEvent(), storage, () -> -1L, properties);
    }

    public static boolean isHighestPriority(RaftConfiguration config, RaftPeerId peerId) {
        return ((RaftConfigurationImpl)config).isHighestPriority(peerId);
    }

    public static CompletableFuture<RaftClientReply> takeSnapshotAsync(RaftServer.Division leader, SnapshotManagementRequest r) throws IOException {
        return ((RaftServerImpl)leader).takeSnapshotAsync(r);
    }

    @Deprecated
    public static org.apache.log4j.Logger toLog4j(Logger logger) {
        return LogManager.getLogger((String)logger.getName());
    }

    public static final class LogCapturer {
        private StringWriter sw = new StringWriter();
        private WriterAppender appender;
        private org.apache.log4j.Logger logger;

        public static LogCapturer captureLogs(Logger logger) {
            return new LogCapturer(RaftServerTestUtil.toLog4j(logger), LogCapturer.getDefaultLayout());
        }

        public static LogCapturer captureLogs(Logger logger, Layout layout) {
            return new LogCapturer(RaftServerTestUtil.toLog4j(logger), layout);
        }

        private static Layout getDefaultLayout() {
            Appender defaultAppender = org.apache.log4j.Logger.getRootLogger().getAppender("stdout");
            if (defaultAppender == null) {
                defaultAppender = org.apache.log4j.Logger.getRootLogger().getAppender("console");
            }
            return defaultAppender == null ? new PatternLayout() : defaultAppender.getLayout();
        }

        private LogCapturer(org.apache.log4j.Logger logger, Layout layout) {
            this.logger = logger;
            this.appender = new WriterAppender(layout, (Writer)this.sw);
            logger.addAppender((Appender)this.appender);
        }

        public String getOutput() {
            return this.sw.toString();
        }

        public void stopCapturing() {
            this.logger.removeAppender((Appender)this.appender);
        }

        public void clearOutput() {
            this.sw.getBuffer().setLength(0);
        }
    }
}

