/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Gauge;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.metrics.LogAppenderMetrics;
import org.apache.ratis.util.Timestamp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLogAppenderMetrics {
    private RatisMetricRegistry ratisMetricRegistry;
    private RaftPeerId raftPeerId;
    private MyFollowerInfo followerInfo;

    @Before
    public void setup() {
        RaftGroupId raftGroupId = RaftGroupId.randomId();
        this.raftPeerId = RaftPeerId.valueOf((String)"TestId");
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)this.raftPeerId, (RaftGroupId)raftGroupId);
        this.followerInfo = new MyFollowerInfo(100L);
        LogAppenderMetrics logAppenderMetrics = new LogAppenderMetrics(raftGroupMemberId);
        this.ratisMetricRegistry = logAppenderMetrics.getRegistry();
        logAppenderMetrics.addFollowerGauges(this.raftPeerId, this.followerInfo::getNextIndex, this.followerInfo::getMatchIndex, this.followerInfo::getLastRpcTime);
    }

    @Test
    public void testLogAppenderGauges() {
        Gauge nextIndex = (Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains(String.format("follower_%s_next_index", this.raftPeerId.toString()))).values().iterator().next();
        Assert.assertEquals((Object)100L, (Object)nextIndex.getValue());
        Gauge matchIndex = (Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains(String.format("follower_%s_match_index", this.raftPeerId.toString()))).values().iterator().next();
        Assert.assertEquals((Object)0L, (Object)matchIndex.getValue());
        Gauge rpcTime = (Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains(String.format("follower_%s_rpc_response_time", this.raftPeerId.toString()))).values().iterator().next();
        Assert.assertTrue(((Long)rpcTime.getValue() > 0L ? 1 : 0) != 0);
        this.followerInfo.updateNextIndex(200L);
        this.followerInfo.updateMatchIndex(100L);
        this.followerInfo.updateLastRpcResponseTime();
        Assert.assertEquals((Object)200L, (Object)nextIndex.getValue());
        Assert.assertEquals((Object)100L, (Object)matchIndex.getValue());
        Assert.assertNotNull((Object)rpcTime.getValue());
    }

    private static class MyFollowerInfo {
        private volatile long nextIndex;
        private volatile long matchIndex;
        private volatile Timestamp lastRpcTime = Timestamp.currentTime();

        MyFollowerInfo(long nextIndex) {
            this.nextIndex = nextIndex;
        }

        long getNextIndex() {
            return this.nextIndex;
        }

        void updateNextIndex(long nextIndex) {
            this.nextIndex = nextIndex;
        }

        long getMatchIndex() {
            return this.matchIndex;
        }

        void updateMatchIndex(long matchIndex) {
            this.matchIndex = matchIndex;
        }

        Timestamp getLastRpcTime() {
            return this.lastRpcTime;
        }

        void updateLastRpcResponseTime() {
            this.lastRpcTime = Timestamp.currentTime();
        }
    }
}

