/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Gauge;
import java.util.Map;
import java.util.SortedMap;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.RetryCacheImpl;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRetryCacheMetrics {
    private static RatisMetricRegistry ratisMetricRegistry;
    private static RetryCacheImpl retryCache;

    @BeforeClass
    public static void setUp() {
        RaftGroupId raftGroupId = RaftGroupId.randomId();
        RaftPeerId raftPeerId = RaftPeerId.valueOf((String)"TestId");
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)raftPeerId, (RaftGroupId)raftGroupId);
        retryCache = new RetryCacheImpl(RaftServerConfigKeys.RetryCache.EXPIRY_TIME_DEFAULT, null);
        RaftServerMetricsImpl raftServerMetrics = RaftServerMetricsImpl.computeIfAbsentRaftServerMetrics((RaftGroupMemberId)raftGroupMemberId, () -> null, () -> ((RetryCacheImpl)retryCache).getStatistics());
        ratisMetricRegistry = raftServerMetrics.getRegistry();
    }

    @After
    public void tearDown() {
        retryCache.close();
        TestRetryCacheMetrics.checkEntryCount(0L);
    }

    @Test
    public void testRetryCacheEntryCount() {
        TestRetryCacheMetrics.checkEntryCount(0L);
        ClientId clientId = ClientId.randomId();
        ClientInvocationId key = ClientInvocationId.valueOf((ClientId)clientId, (long)1L);
        RetryCacheImpl.CacheEntry entry = new RetryCacheImpl.CacheEntry(key);
        retryCache.refreshEntry(entry);
        TestRetryCacheMetrics.checkEntryCount(1L);
    }

    @Test
    public void testRetryCacheHitMissCount() {
        TestRetryCacheMetrics.checkHit(0L, 1.0);
        TestRetryCacheMetrics.checkMiss(0L, 0.0);
        ClientInvocationId invocationId = ClientInvocationId.valueOf((ClientId)ClientId.randomId(), (long)2L);
        retryCache.getOrCreateEntry(invocationId);
        TestRetryCacheMetrics.checkHit(0L, 0.0);
        TestRetryCacheMetrics.checkMiss(1L, 1.0);
        retryCache.getOrCreateEntry(invocationId);
        TestRetryCacheMetrics.checkHit(1L, 0.5);
        TestRetryCacheMetrics.checkMiss(1L, 0.5);
    }

    private static void checkHit(long count, double rate) {
        Long hitCount = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheHitCount")).values().iterator().next()).getValue();
        Assert.assertEquals((long)hitCount, (long)count);
        Double hitRate = (Double)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheHitRate")).values().iterator().next()).getValue();
        Assert.assertEquals((double)hitRate, (double)rate, (double)0.0);
    }

    private static void checkMiss(long count, double rate) {
        Long missCount = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheMissCount")).values().iterator().next()).getValue();
        Assert.assertEquals((long)missCount, (long)count);
        Double missRate = (Double)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheMissRate")).values().iterator().next()).getValue();
        Assert.assertEquals((double)missRate, (double)rate, (double)0.0);
    }

    private static void checkEntryCount(long expected) {
        SortedMap map = ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheEntryCount"));
        Assert.assertEquals((long)1L, (long)map.size());
        Map.Entry entry = map.entrySet().iterator().next();
        Assert.assertEquals((Object)expected, (Object)((Gauge)entry.getValue()).getValue());
    }
}

