/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import com.codahale.metrics.Gauge;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLeaderElectionMetrics {
    private static LeaderElectionMetrics leaderElectionMetrics;
    private static RatisMetricRegistry ratisMetricRegistry;

    @BeforeClass
    public static void setUp() {
        RaftGroupId raftGroupId = RaftGroupId.randomId();
        RaftPeerId raftPeerId = RaftPeerId.valueOf((String)"TestId");
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)raftPeerId, (RaftGroupId)raftGroupId);
        leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics((RaftGroupMemberId)raftGroupMemberId, () -> 1000L);
        ratisMetricRegistry = leaderElectionMetrics.getRegistry();
    }

    @Test
    public void testOnLeaderElectionCompletion() throws Exception {
        leaderElectionMetrics.onNewLeaderElectionCompletion();
        Long leaderElectionLatency = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("lastLeaderElectionElapsedTime")).values().iterator().next()).getValue();
        Assert.assertTrue((leaderElectionLatency > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testOnLeaderElectionTimeout() throws Exception {
        long numLeaderElectionTimeouts = ratisMetricRegistry.counter("timeoutCount").getCount();
        Assert.assertTrue((numLeaderElectionTimeouts == 0L ? 1 : 0) != 0);
        leaderElectionMetrics.onLeaderElectionTimeout();
        numLeaderElectionTimeouts = ratisMetricRegistry.counter("timeoutCount").getCount();
        Assert.assertEquals((long)1L, (long)numLeaderElectionTimeouts);
    }
}

