/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.simulation;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ratis.protocol.RaftRpcMessage;
import org.apache.ratis.server.simulation.SimulatedRequestReply;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler<REQUEST extends RaftRpcMessage, REPLY extends RaftRpcMessage> {
    public static final Logger LOG = LoggerFactory.getLogger(RequestHandler.class);
    private final Supplier<String> serverIdSupplier;
    private final String name;
    private final SimulatedRequestReply<REQUEST, REPLY> rpc;
    private final HandlerInterface<REQUEST, REPLY> handlerImpl;
    private final List<HandlerDaemon> daemons;

    RequestHandler(Supplier<String> serverIdSupplier, String name, SimulatedRequestReply<REQUEST, REPLY> rpc, HandlerInterface<REQUEST, REPLY> handlerImpl, int numHandlers) {
        this.serverIdSupplier = serverIdSupplier;
        this.name = name;
        this.rpc = rpc;
        this.handlerImpl = handlerImpl;
        this.daemons = new ArrayList<HandlerDaemon>(numHandlers);
        for (int i = 0; i < numHandlers; ++i) {
            this.daemons.add(new HandlerDaemon(i));
        }
    }

    private String getServerId() {
        return this.serverIdSupplier.get();
    }

    void startDaemon() {
        this.daemons.forEach(Thread::start);
    }

    void shutdown() {
        this.rpc.shutdown(this.getServerId());
    }

    void interruptAndJoinDaemon() throws InterruptedException {
        this.daemons.forEach(Thread::interrupt);
        for (Daemon daemon : this.daemons) {
            daemon.join(1000L);
        }
    }

    SimulatedRequestReply<REQUEST, REPLY> getRpc() {
        return this.rpc;
    }

    void handleRequest(REQUEST request) throws IOException {
        REPLY reply;
        try {
            reply = this.handlerImpl.handleRequest(request);
        }
        catch (IOException ioe) {
            LOG.debug("IOException for " + request, (Throwable)ioe);
            this.rpc.sendReply(request, null, ioe);
            return;
        }
        if (reply != null) {
            this.rpc.sendReply(request, reply, null);
        }
    }

    class HandlerDaemon
    extends Daemon {
        private final int id;

        HandlerDaemon(int id) {
            super(HandlerDaemon.newBuilder().setName("HandlerDaemon-" + id));
            this.id = id;
        }

        public String toString() {
            return RequestHandler.this.getServerId() + "." + RequestHandler.this.name + this.id;
        }

        public void run() {
            while (RequestHandler.this.handlerImpl.isAlive()) {
                try {
                    if (Thread.interrupted()) {
                        throw new InterruptedException((Object)((Object)this) + " was interrupted previously.");
                    }
                    RequestHandler.this.handleRequest(RequestHandler.this.rpc.takeRequest(RequestHandler.this.getServerId()));
                }
                catch (InterruptedIOException e) {
                    LOG.info((Object)((Object)this) + " is interrupted by " + e);
                    LOG.trace("TRACE", (Throwable)e);
                    break;
                }
                catch (IOException e) {
                    LOG.error((Object)((Object)this) + " has " + e);
                    LOG.trace("TRACE", (Throwable)e);
                }
                catch (Exception e) {
                    if (!RequestHandler.this.handlerImpl.isAlive()) {
                        LOG.info((Object)((Object)this) + " is stopped.");
                        break;
                    }
                    ExitUtils.terminate((int)1, (String)((Object)((Object)this) + " is terminating."), (Throwable)e, (Logger)LOG);
                }
            }
        }
    }

    static interface HandlerInterface<REQUEST extends RaftRpcMessage, REPLY extends RaftRpcMessage> {
        public boolean isAlive();

        public REPLY handleRequest(REQUEST var1) throws IOException;
    }
}

