/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.statemachine;

import java.io.File;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.statemachine.SimpleStateMachine4Testing;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.Log4jUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnapshotManagementTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final Logger LOG = LoggerFactory.getLogger(SnapshotManagementTest.class);

    public SnapshotManagementTest() {
        Log4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.INFO);
        Log4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.INFO);
    }

    @Before
    public void setup() {
        RaftProperties p = this.getProperties();
        p.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
        RaftServerConfigKeys.Snapshot.setCreationGap((RaftProperties)p, (long)20L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)p, (boolean)false);
    }

    @Test
    public void testTakeSnapshot() throws Exception {
        this.runWithNewCluster(1, this::runTestTakeSnapshot);
        this.runWithNewCluster(1, this::runTestTakeSnapshotWithConfigurableGap);
        this.runWithNewCluster(3, this::runTestTakeSnapshotOnSpecificServer);
    }

    void runTestTakeSnapshot(CLUSTER cluster) throws Exception {
        RaftClientReply snapshotReply;
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = leader.getId();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
            int i = 0;
            while ((long)i < RaftServerConfigKeys.Snapshot.creationGap((RaftProperties)this.getProperties())) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
                ++i;
            }
            snapshotReply = client.getSnapshotManagementApi().create(3000L);
        }
        Assert.assertTrue((boolean)snapshotReply.isSuccess());
        long snapshotIndex = snapshotReply.getLogIndex();
        LOG.info("snapshotIndex = {}", (Object)snapshotIndex);
        File snapshotFile = SimpleStateMachine4Testing.get(leader).getStateMachineStorage().getSnapshotFile(leader.getInfo().getCurrentTerm(), snapshotIndex);
        Assert.assertTrue((boolean)snapshotFile.exists());
    }

    void runTestTakeSnapshotWithConfigurableGap(CLUSTER cluster) throws Exception {
        RaftClientReply snapshotReply;
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = leader.getId();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
            RaftClientReply reply;
            int i = 0;
            while ((long)i < RaftServerConfigKeys.Snapshot.creationGap((RaftProperties)this.getProperties()) / 2L - 1L) {
                reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
                ++i;
            }
            Assert.assertTrue((leader.getStateMachine().getLastAppliedTermIndex().getIndex() < RaftServerConfigKeys.Snapshot.creationGap((RaftProperties)this.getProperties()) ? 1 : 0) != 0);
            snapshotReply = client.getSnapshotManagementApi(leaderId).create(3000L);
            Assert.assertTrue((boolean)snapshotReply.isSuccess());
            Assert.assertEquals((long)0L, (long)snapshotReply.getLogIndex());
            i = 0;
            while ((long)i < RaftServerConfigKeys.Snapshot.creationGap((RaftProperties)this.getProperties()) / 2L - 1L) {
                reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
                ++i;
            }
            SnapshotManagementRequest r1 = SnapshotManagementRequest.newCreate((ClientId)client.getId(), (RaftPeerId)leaderId, (RaftGroupId)((MiniRaftCluster)cluster).getGroupId(), (long)CallId.getAndIncrement(), (long)3000L);
            snapshotReply = client.getSnapshotManagementApi(leaderId).create(3000L);
        }
        Assert.assertTrue((boolean)snapshotReply.isSuccess());
        long snapshotIndex = snapshotReply.getLogIndex();
        LOG.info("snapshotIndex = {}", (Object)snapshotIndex);
        File snapshotFile = SimpleStateMachine4Testing.get(leader).getStateMachineStorage().getSnapshotFile(leader.getInfo().getCurrentTerm(), snapshotIndex);
        Assert.assertTrue((boolean)snapshotFile.exists());
    }

    void runTestTakeSnapshotOnSpecificServer(CLUSTER cluster) throws Exception {
        RaftClientReply snapshotReply;
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftServer.Division follower = ((MiniRaftCluster)cluster).getFollowers().get(0);
        RaftPeerId followerId = follower.getId();
        Assert.assertTrue((boolean)follower.getInfo().isFollower());
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(followerId);){
            int i = 0;
            while ((long)i < RaftServerConfigKeys.Snapshot.creationGap((RaftProperties)this.getProperties())) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
                ++i;
            }
            snapshotReply = client.getSnapshotManagementApi(followerId).create(3000L);
        }
        Assert.assertTrue((boolean)snapshotReply.isSuccess());
        long snapshotIndex = snapshotReply.getLogIndex();
        LOG.info("snapshotIndex = {} on {} server {}", new Object[]{snapshotIndex, follower.getInfo().getCurrentRole(), follower.getId()});
        File snapshotFile = SimpleStateMachine4Testing.get(follower).getStateMachineStorage().getSnapshotFile(follower.getInfo().getCurrentTerm(), snapshotIndex);
        Assert.assertTrue((boolean)snapshotFile.exists());
    }

    @Test
    public void testReceiveLogAndTakeSnapshotOnListener() throws Exception {
        this.runWithNewCluster(2, 1, this::runTestReceiveLogAndTakeSnapshotOnListener);
    }

    void runTestReceiveLogAndTakeSnapshotOnListener(CLUSTER cluster) throws Exception {
        RaftClientReply snapshotReply;
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftServer.Division listener = ((MiniRaftCluster)cluster).getListeners().get(0);
        RaftPeerId listenerId = listener.getId();
        Assert.assertTrue((boolean)listener.getInfo().isListener());
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(listenerId);){
            int i = 0;
            while ((long)i < RaftServerConfigKeys.Snapshot.creationGap((RaftProperties)this.getProperties())) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
                ++i;
            }
            snapshotReply = client.getSnapshotManagementApi(listenerId).create(3000L);
        }
        Assert.assertTrue((boolean)snapshotReply.isSuccess());
        long snapshotIndex = snapshotReply.getLogIndex();
        LOG.info("snapshotIndex = {} on {} server {}", new Object[]{snapshotIndex, listener.getInfo().getCurrentRole(), listener.getId()});
        File snapshotFile = SimpleStateMachine4Testing.get(listener).getStateMachineStorage().getSnapshotFile(listener.getInfo().getCurrentTerm(), snapshotIndex);
        Assert.assertTrue((boolean)snapshotFile.exists());
    }
}

