/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.BaseTest;
import org.apache.ratis.InstallSnapshotNotificationTests;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.RaftSnapshotBaseTest;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class InstallSnapshotNotificationTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final Logger LOG = LoggerFactory.getLogger(InstallSnapshotNotificationTests.class);
    private static final int SNAPSHOT_TRIGGER_THRESHOLD = 64;
    private static final int PURGE_GAP = 8;
    private static final AtomicReference<SnapshotInfo> leaderSnapshotInfoRef = new AtomicReference();
    private static final AtomicInteger numSnapshotRequests = new AtomicInteger();
    private static final AtomicInteger numNotifyInstallSnapshotFinished = new AtomicInteger();

    public InstallSnapshotNotificationTests() {
        Slf4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.DEBUG);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachine4InstallSnapshotNotificationTests.class, StateMachine.class);
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled((RaftProperties)prop, (boolean)false);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)prop, (long)64L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)prop, (boolean)true);
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)prop, (int)8);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)prop, (SizeInBytes)SizeInBytes.valueOf((long)1024L));
    }

    @Test
    public void testAddNewFollowers() throws Exception {
        this.runWithNewCluster(1, arg_0 -> this.testAddNewFollowers(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAddNewFollowers(CLUSTER cluster) throws Exception {
        List logs;
        int i;
        leaderSnapshotInfoRef.set(null);
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            try (RaftClient client = cluster.createClient(leaderId);){
                for (i = 0; i < 127; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
            }
            RaftServer.Division leader = cluster.getLeader();
            long nextIndex = leader.getRaftLog().getNextIndex();
            LOG.info("nextIndex = {}", (Object)nextIndex);
            List snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, (long)(nextIndex - 64L), (long)nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            logs = LogSegmentPath.getLogSegmentPaths((RaftStorage)leader.getRaftStorage());
        }
        finally {
            cluster.shutdown();
        }
        LOG.info("Delete logs {}", (Object)logs);
        for (Object path : logs) {
            FileUtils.deleteFully((Path)path.getPath());
        }
        LOG.info("Restarting the cluster");
        cluster.restart(false);
        try {
            Object path;
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
            RaftClient client = cluster.createClient(cluster.getLeader().getId());
            path = null;
            try {
                Assert.assertTrue((boolean)client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
            }
            catch (Throwable nextIndex) {
                path = nextIndex;
                throw nextIndex;
            }
            finally {
                if (client != null) {
                    if (path != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable nextIndex) {
                            ((Throwable)path).addSuppressed(nextIndex);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            SnapshotInfo leaderSnapshotInfo = cluster.getLeader().getStateMachine().getLatestSnapshot();
            LOG.info("LeaderSnapshotInfo: {}", (Object)leaderSnapshotInfo.getTermIndex());
            boolean set = leaderSnapshotInfoRef.compareAndSet(null, leaderSnapshotInfo);
            Assert.assertTrue((boolean)set);
            MiniRaftCluster.PeerChanges change = cluster.addNewPeers(2, true, true);
            cluster.setConfiguration(change.allPeersInNewConf);
            RaftServerTestUtil.waitAndCheckNewConf(cluster, (RaftPeer[])change.allPeersInNewConf, (int)0, null);
            for (RaftServer.Division follower : cluster.getFollowers()) {
                Assert.assertEquals((long)leaderSnapshotInfo.getIndex(), (long)RaftServerTestUtil.getLatestInstalledSnapshotIndex((RaftServer.Division)follower));
            }
            cluster.restartServer(cluster.getLeader().getId(), false);
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testRestartFollower() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.testRestartFollower(arg_0));
    }

    private void testRestartFollower(CLUSTER cluster) throws Exception {
        int i;
        leaderSnapshotInfoRef.set(null);
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = leader.getId();
        try (RaftClient client = cluster.createClient(leaderId);){
            for (i = 0; i < 127; ++i) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
            }
        }
        long oldLeaderNextIndex = leader.getRaftLog().getNextIndex();
        LOG.info("{}: oldLeaderNextIndex = {}", (Object)leaderId, (Object)oldLeaderNextIndex);
        List snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, (long)(oldLeaderNextIndex - 64L), (long)oldLeaderNextIndex);
        JavaUtils.attemptRepeatedly(() -> {
            Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
            return null;
        }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
        RaftPeerId followerId = ((RaftServer.Division)cluster.getFollowers().get(0)).getId();
        cluster.killServer(followerId);
        try (RaftClient client = cluster.createClient(leader.getId());){
            Assert.assertTrue((boolean)client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
        }
        FIVE_SECONDS.sleep();
        cluster.restartServer(followerId, false);
        RaftServer.Division follower = cluster.getDivision(followerId);
        JavaUtils.attempt(() -> {
            long newLeaderNextIndex = leader.getRaftLog().getNextIndex();
            LOG.info("{}: newLeaderNextIndex = {}", (Object)leaderId, (Object)newLeaderNextIndex);
            Assert.assertTrue((newLeaderNextIndex > oldLeaderNextIndex ? 1 : 0) != 0);
            Assert.assertEquals((long)newLeaderNextIndex, (long)follower.getRaftLog().getNextIndex());
        }, (int)10, (TimeDuration)ONE_SECOND, (String)"followerNextIndex", (Logger)LOG);
    }

    @Test
    public void testInstallSnapshotNotificationCount() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.testInstallSnapshotNotificationCount(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInstallSnapshotNotificationCount(CLUSTER cluster) throws Exception {
        leaderSnapshotInfoRef.set(null);
        numSnapshotRequests.set(0);
        try {
            int i;
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            ONE_SECOND.sleep();
            Assert.assertEquals((long)0L, (long)numSnapshotRequests.get());
            try (RaftClient client = cluster.createClient(leaderId);){
                for (i = 0; i < 10; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
            }
            RaftTestUtil.waitFor(() -> cluster.getLeader().getStateMachine().getLastAppliedTermIndex().getIndex() == 20L, (int)300, (int)15000);
            long snapshotIndex = cluster.getLeader().getStateMachine().takeSnapshot();
            Assert.assertEquals((long)20L, (long)snapshotIndex);
            SnapshotInfo leaderSnapshotInfo = cluster.getLeader().getStateMachine().getLatestSnapshot();
            Assert.assertEquals((long)20L, (long)leaderSnapshotInfo.getIndex());
            boolean set = leaderSnapshotInfoRef.compareAndSet(null, leaderSnapshotInfo);
            Assert.assertTrue((boolean)set);
            RaftServer.Division leader = cluster.getLeader();
            long nextIndex = leader.getRaftLog().getNextIndex();
            Assert.assertEquals((long)21L, (long)nextIndex);
            List snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, (long)0L, (long)nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            long snapshotInstallIndex = (Long)leader.getRaftLog().onSnapshotInstalled(leader.getRaftLog().getLastCommittedIndex()).get();
            Assert.assertEquals((long)20L, (long)snapshotInstallIndex);
            Assert.assertEquals((long)0L, (long)LogSegmentPath.getLogSegmentPaths((RaftStorage)leader.getRaftStorage()).size());
            Assert.assertEquals((long)-1L, (long)leader.getRaftLog().getStartIndex());
            ONE_SECOND.sleep();
            Assert.assertEquals((long)0L, (long)numSnapshotRequests.get());
            for (RaftServer.Division follower : cluster.getFollowers()) {
                Assert.assertEquals((long)leader.getRaftLog().getNextIndex(), (long)follower.getRaftLog().getNextIndex());
            }
            MiniRaftCluster.PeerChanges change = cluster.addNewPeers(2, true, true);
            cluster.setConfiguration(change.allPeersInNewConf);
            RaftServerTestUtil.waitAndCheckNewConf(cluster, (RaftPeer[])change.allPeersInNewConf, (int)0, null);
            try (RaftClient client = cluster.createClient(leader.getId());){
                Assert.assertTrue((boolean)client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
            }
            for (RaftServer.Division follower : cluster.getFollowers()) {
                RaftTestUtil.waitFor(() -> leader.getRaftLog().getNextIndex() == follower.getRaftLog().getNextIndex(), (int)300, (int)15000);
            }
            Assert.assertEquals((long)2L, (long)numSnapshotRequests.get());
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testInstallSnapshotInstalledEvent() throws Exception {
        this.runWithNewCluster(1, arg_0 -> this.testInstallSnapshotInstalledEvent(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInstallSnapshotInstalledEvent(CLUSTER cluster) throws Exception {
        List logs;
        int i;
        leaderSnapshotInfoRef.set(null);
        numNotifyInstallSnapshotFinished.set(0);
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            try (RaftClient client = cluster.createClient(leaderId);){
                for (i = 0; i < 127; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
            }
            RaftServer.Division leader = cluster.getLeader();
            long nextIndex = leader.getRaftLog().getNextIndex();
            LOG.info("nextIndex = {}", (Object)nextIndex);
            List snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, (long)(nextIndex - 64L), (long)nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            logs = LogSegmentPath.getLogSegmentPaths((RaftStorage)leader.getRaftStorage());
        }
        finally {
            cluster.shutdown();
        }
        LOG.info("Delete logs {}", (Object)logs);
        for (Object path : logs) {
            FileUtils.deleteFully((Path)path.getPath());
        }
        LOG.info("Restarting the cluster");
        cluster.restart(false);
        try {
            Object path;
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
            RaftClient client = cluster.createClient(cluster.getLeader().getId());
            path = null;
            try {
                Assert.assertTrue((boolean)client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
            }
            catch (Throwable nextIndex) {
                path = nextIndex;
                throw nextIndex;
            }
            finally {
                if (client != null) {
                    if (path != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable nextIndex) {
                            ((Throwable)path).addSuppressed(nextIndex);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            SnapshotInfo leaderSnapshotInfo = cluster.getLeader().getStateMachine().getLatestSnapshot();
            LOG.info("LeaderSnapshotInfo: {}", (Object)leaderSnapshotInfo.getTermIndex());
            boolean set = leaderSnapshotInfoRef.compareAndSet(null, leaderSnapshotInfo);
            Assert.assertTrue((boolean)set);
            MiniRaftCluster.PeerChanges change = cluster.addNewPeers(1, true, true);
            cluster.setConfiguration(change.allPeersInNewConf);
            RaftServerTestUtil.waitAndCheckNewConf(cluster, (RaftPeer[])change.allPeersInNewConf, (int)0, null);
            for (RaftServer.Division follower : cluster.getFollowers()) {
                Assert.assertEquals((long)leaderSnapshotInfo.getIndex(), (long)RaftServerTestUtil.getLatestInstalledSnapshotIndex((RaftServer.Division)follower));
            }
            File leaderSnapshotFile = ((FileInfo)leaderSnapshotInfo.getFiles().get(0)).getPath().toFile();
            SimpleStateMachine4Testing followerStateMachine = (SimpleStateMachine4Testing)((RaftServer.Division)cluster.getFollowers().get(0)).getStateMachine();
            File followerSnapshotFile = new File(followerStateMachine.getStateMachineDir(), leaderSnapshotFile.getName());
            Assert.assertEquals((long)numNotifyInstallSnapshotFinished.get(), (long)2L);
            Assert.assertTrue((boolean)leaderSnapshotFile.exists());
            Assert.assertFalse((boolean)followerSnapshotFile.exists());
            cluster.restartServer(cluster.getLeader().getId(), false);
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testInstallSnapshotDuringBootstrap() throws Exception {
        this.runWithNewCluster(1, arg_0 -> this.testInstallSnapshotDuringBootstrap(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInstallSnapshotDuringBootstrap(CLUSTER cluster) throws Exception {
        leaderSnapshotInfoRef.set(null);
        numSnapshotRequests.set(0);
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            try (RaftClient client = cluster.createClient(leaderId);){
                for (int i = 0; i < 127; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
            }
            RaftServer.Division leader = cluster.getLeader();
            long nextIndex = leader.getRaftLog().getNextIndex();
            LOG.info("nextIndex = {}", (Object)nextIndex);
            List snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, (long)(nextIndex - 64L), (long)nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
            SnapshotInfo leaderSnapshotInfo = cluster.getLeader().getStateMachine().getLatestSnapshot();
            boolean set = leaderSnapshotInfoRef.compareAndSet(null, leaderSnapshotInfo);
            Assert.assertTrue((boolean)set);
            MiniRaftCluster.PeerChanges change = cluster.addNewPeers(2, true, true);
            cluster.setConfiguration(change.allPeersInNewConf);
            RaftServerTestUtil.waitAndCheckNewConf(cluster, (RaftPeer[])change.allPeersInNewConf, (int)0, null);
            for (RaftServer.Division follower : cluster.getFollowers()) {
                Assert.assertEquals((long)leaderSnapshotInfo.getIndex(), (long)RaftServerTestUtil.getLatestInstalledSnapshotIndex((RaftServer.Division)follower));
            }
            Assert.assertEquals((long)2L, (long)numSnapshotRequests.get());
        }
        finally {
            cluster.shutdown();
        }
    }

    static /* synthetic */ AtomicInteger access$000() {
        return numSnapshotRequests;
    }

    static /* synthetic */ AtomicReference access$100() {
        return leaderSnapshotInfoRef;
    }

    static /* synthetic */ AtomicInteger access$200() {
        return numNotifyInstallSnapshotFinished;
    }
}

