/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.ReadOnlyRequestTests;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.ReadIndexException;
import org.apache.ratis.retry.ExceptionDependentRetry;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ReadOnlyRequestTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final int NUM_SERVERS = 3;
    static final String INCREMENT = "INCREMENT";
    static final String WAIT_AND_INCREMENT = "WAIT_AND_INCREMENT";
    static final String QUERY = "QUERY";
    final Message incrementMessage;
    final Message waitAndIncrementMessage;
    final Message queryMessage;

    public ReadOnlyRequestTests() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        this.incrementMessage = new RaftTestUtil.SimpleMessage("INCREMENT");
        this.waitAndIncrementMessage = new RaftTestUtil.SimpleMessage("WAIT_AND_INCREMENT");
        this.queryMessage = new RaftTestUtil.SimpleMessage("QUERY");
    }

    @Before
    public void setup() {
        RaftProperties p = this.getProperties();
        p.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, CounterStateMachine.class, StateMachine.class);
        p.setEnum(RaftServerConfigKeys.Read.OPTION_KEY, (Enum)RaftServerConfigKeys.Read.Option.LINEARIZABLE);
    }

    @Test
    public void testLinearizableRead() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.testLinearizableReadImpl(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLinearizableReadImpl(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            try (RaftClient client = cluster.createClient(leaderId);){
                for (int i = 1; i <= 10; ++i) {
                    RaftClientReply reply = client.io().send(this.incrementMessage);
                    Assert.assertTrue((boolean)reply.isSuccess());
                    reply = client.io().sendReadOnly(this.queryMessage);
                    Assert.assertEquals((long)i, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)reply));
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testLinearizableReadTimeout() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.testLinearizableReadTimeoutImpl(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testLinearizableReadTimeoutImpl(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            try (RaftClient client = cluster.createClient(leaderId);
                 RaftClient noRetry = cluster.createClient(leaderId, RetryPolicies.noRetry());){
                CompletableFuture result = client.async().send(this.incrementMessage);
                client.admin().transferLeadership(null, 200L);
                Assert.assertThrows(ReadIndexException.class, () -> {
                    RaftClientReply timeoutReply = noRetry.io().sendReadOnly(this.queryMessage);
                    Assert.assertNotNull((Object)timeoutReply.getException());
                    Assert.assertTrue((boolean)(timeoutReply.getException() instanceof ReadException));
                });
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFollowerLinearizableRead() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.testFollowerLinearizableReadImpl(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFollowerLinearizableReadImpl(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            List followers = cluster.getFollowers();
            Assert.assertEquals((long)2L, (long)followers.size());
            RaftPeerId f0 = ((RaftServer.Division)followers.get(0)).getId();
            RaftPeerId f1 = ((RaftServer.Division)followers.get(1)).getId();
            try (RaftClient client = cluster.createClient(cluster.getLeader().getId());){
                for (int i = 1; i <= 10; ++i) {
                    RaftClientReply reply = client.io().send(this.incrementMessage);
                    Assert.assertTrue((boolean)reply.isSuccess());
                    RaftClientReply read1 = client.io().sendReadOnly(this.queryMessage, f0);
                    Assert.assertEquals((long)i, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)read1));
                    CompletableFuture read2 = client.async().sendReadOnly(this.queryMessage, f1);
                    Assert.assertEquals((long)i, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)((RaftClientReply)read2.get(1L, TimeUnit.SECONDS))));
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFollowerLinearizableReadParallel() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.testFollowerLinearizableReadParallelImpl(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFollowerLinearizableReadParallelImpl(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            List followers = cluster.getFollowers();
            Assert.assertEquals((long)2L, (long)followers.size());
            try (RaftClient leaderClient = cluster.createClient(cluster.getLeader().getId());
                 RaftClient followerClient1 = cluster.createClient(((RaftServer.Division)followers.get(0)).getId());){
                leaderClient.io().send(this.incrementMessage);
                leaderClient.async().send(this.waitAndIncrementMessage);
                Thread.sleep(100L);
                RaftClientReply clientReply = followerClient1.io().sendReadOnly(this.queryMessage, ((RaftServer.Division)followers.get(0)).getId());
                Assert.assertEquals((long)2L, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)clientReply));
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFollowerLinearizableReadFailWhenLeaderDown() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.testFollowerLinearizableReadFailWhenLeaderDownImpl(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFollowerLinearizableReadFailWhenLeaderDownImpl(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            List followers = cluster.getFollowers();
            Assert.assertEquals((long)2L, (long)followers.size());
            try (RaftClient leaderClient = cluster.createClient(cluster.getLeader().getId());
                 RaftClient followerClient1 = cluster.createClient(((RaftServer.Division)followers.get(0)).getId(), RetryPolicies.noRetry());){
                leaderClient.io().send(this.incrementMessage);
                RaftClientReply clientReply = followerClient1.io().sendReadOnly(this.queryMessage);
                Assert.assertEquals((long)1L, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)clientReply));
                leaderClient.admin().transferLeadership(null, 200L);
                Assert.assertThrows(ReadIndexException.class, () -> followerClient1.io().sendReadOnly(this.queryMessage, ((RaftServer.Division)followers.get(0)).getId()));
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFollowerLinearizableReadRetryWhenLeaderDown() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.testFollowerLinearizableReadRetryWhenLeaderDown(arg_0));
    }

    private void testFollowerLinearizableReadRetryWhenLeaderDown(CLUSTER cluster) throws Exception {
        ExceptionDependentRetry retryPolicy = ExceptionDependentRetry.newBuilder().setDefaultPolicy(RetryPolicies.noRetry()).setExceptionToPolicy(ReadIndexException.class, (RetryPolicy)RetryPolicies.retryForeverWithSleep((TimeDuration)TimeDuration.valueOf((long)500L, (TimeUnit)TimeUnit.MILLISECONDS))).build();
        RaftTestUtil.waitForLeader(cluster);
        try (RaftClient client = cluster.createClient(cluster.getLeader().getId(), (RetryPolicy)retryPolicy);){
            client.io().send(this.incrementMessage);
            RaftClientReply clientReply = client.io().sendReadOnly(this.queryMessage);
            Assert.assertEquals((long)1L, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)clientReply));
            client.admin().transferLeadership(null, 200L);
            RaftClientReply replySuccess = client.io().sendReadOnly(this.queryMessage);
            Assert.assertEquals((long)1L, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)clientReply));
        }
    }

    static int retrieve(RaftClientReply reply) {
        return Integer.parseInt(reply.getMessage().getContent().toString(StandardCharsets.UTF_8));
    }
}

