/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.Preconditions;

/*
 * Exception performing whole class analysis ignored.
 */
class PeerConfiguration {
    private final Map<RaftPeerId, RaftPeer> peers;
    private final Map<RaftPeerId, RaftPeer> listeners;

    static Map<RaftPeerId, RaftPeer> newMap(Iterable<RaftPeer> peers, String name, Map<RaftPeerId, RaftPeer> existing) {
        Objects.requireNonNull(peers, () -> name + " == null");
        HashMap<RaftPeerId, RaftPeer> map = new HashMap<RaftPeerId, RaftPeer>();
        for (RaftPeer p : peers) {
            if (existing.containsKey(p.getId())) {
                throw new IllegalArgumentException("Failed to initialize " + name + ": Found " + p.getId() + " in existing peers " + existing);
            }
            RaftPeer previous = map.putIfAbsent(p.getId(), p);
            if (previous == null) continue;
            throw new IllegalArgumentException("Failed to initialize " + name + ": Found duplicated ids " + p.getId() + " in " + peers);
        }
        return Collections.unmodifiableMap(map);
    }

    PeerConfiguration(Iterable<RaftPeer> peers) {
        this(peers, Collections.emptyList());
    }

    PeerConfiguration(Iterable<RaftPeer> peers, Iterable<RaftPeer> listeners) {
        this.peers = PeerConfiguration.newMap(peers, (String)"peers", Collections.emptyMap());
        this.listeners = Optional.ofNullable(listeners).map(l -> PeerConfiguration.newMap((Iterable)listeners, (String)"listeners", (Map)this.peers)).orElseGet(Collections::emptyMap);
    }

    private Map<RaftPeerId, RaftPeer> getPeerMap(RaftProtos.RaftPeerRole r) {
        if (r == RaftProtos.RaftPeerRole.FOLLOWER) {
            return this.peers;
        }
        if (r == RaftProtos.RaftPeerRole.LISTENER) {
            return this.listeners;
        }
        throw new IllegalArgumentException("Unexpected RaftPeerRole " + r);
    }

    Collection<RaftPeer> getPeers(RaftProtos.RaftPeerRole role) {
        return Collections.unmodifiableCollection(this.getPeerMap(role).values());
    }

    int size() {
        return this.peers.size();
    }

    Stream<RaftPeerId> streamPeerIds() {
        return this.peers.keySet().stream();
    }

    public String toString() {
        return "peers:" + this.peers.values() + "|listeners:" + this.listeners.values();
    }

    RaftPeer getPeer(RaftPeerId id, RaftProtos.RaftPeerRole ... roles) {
        if (roles == null || roles.length == 0) {
            return (RaftPeer)this.peers.get(id);
        }
        for (RaftProtos.RaftPeerRole r : roles) {
            RaftPeer peer = (RaftPeer)this.getPeerMap(r).get(id);
            if (peer == null) continue;
            return peer;
        }
        return null;
    }

    boolean contains(RaftPeerId id) {
        return this.contains(id, RaftProtos.RaftPeerRole.FOLLOWER);
    }

    boolean contains(RaftPeerId id, RaftProtos.RaftPeerRole r) {
        return this.getPeerMap(r).containsKey(id);
    }

    RaftProtos.RaftPeerRole contains(RaftPeerId id, EnumSet<RaftProtos.RaftPeerRole> roles) {
        if (roles == null || roles.isEmpty()) {
            return this.peers.containsKey(id) ? RaftProtos.RaftPeerRole.FOLLOWER : null;
        }
        for (RaftProtos.RaftPeerRole r : roles) {
            if (!this.getPeerMap(r).containsKey(id)) continue;
            return r;
        }
        return null;
    }

    List<RaftPeer> getOtherPeers(RaftPeerId selfId) {
        ArrayList<RaftPeer> others = new ArrayList<RaftPeer>();
        for (Map.Entry entry : this.peers.entrySet()) {
            if (selfId.equals((Object)((RaftPeer)entry.getValue()).getId())) continue;
            others.add((RaftPeer)entry.getValue());
        }
        return others;
    }

    boolean hasMajority(Collection<RaftPeerId> others, RaftPeerId selfId) {
        Preconditions.assertTrue((!others.contains(selfId) ? 1 : 0) != 0);
        int num = 0;
        if (this.contains(selfId)) {
            ++num;
        }
        for (RaftPeerId other : others) {
            if (!this.contains(other)) continue;
            ++num;
        }
        return num > this.size() / 2;
    }

    int getMajorityCount() {
        return this.size() / 2 + 1;
    }

    boolean majorityRejectVotes(Collection<RaftPeerId> rejected) {
        int num = this.size();
        for (RaftPeerId other : rejected) {
            if (!this.contains(other)) continue;
            --num;
        }
        return num <= this.size() / 2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PeerConfiguration that = (PeerConfiguration)obj;
        return this.peers.equals(that.peers);
    }

    public int hashCode() {
        return this.peers.keySet().hashCode();
    }
}

