/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.ReadRequests;
import org.apache.ratis.statemachine.StateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadRequests {
    private static final Logger LOG = LoggerFactory.getLogger(ReadRequests.class);
    private final ReadIndexQueue readIndexQueue;
    private final StateMachine stateMachine;

    ReadRequests(RaftProperties properties, StateMachine stateMachine) {
        this.readIndexQueue = new ReadIndexQueue(RaftServerConfigKeys.Read.timeout((RaftProperties)properties));
        this.stateMachine = stateMachine;
    }

    Consumer<Long> getAppliedIndexConsumer() {
        return arg_0 -> ((ReadIndexQueue)this.readIndexQueue).complete(arg_0);
    }

    CompletableFuture<Long> waitToAdvance(long readIndex) {
        if (this.stateMachine.getLastAppliedTermIndex().getIndex() >= readIndex) {
            return CompletableFuture.completedFuture(readIndex);
        }
        return this.readIndexQueue.add(readIndex);
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

