/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.WatchRequests;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatchRequests {
    public static final Logger LOG = LoggerFactory.getLogger(WatchRequests.class);
    private final String name;
    private final Map<RaftProtos.ReplicationLevel, WatchQueue> queues = new EnumMap(RaftProtos.ReplicationLevel.class);
    private final TimeDuration watchTimeoutNanos;
    private final TimeDuration watchTimeoutDenominationNanos;
    private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();

    WatchRequests(Object name, RaftProperties properties) {
        this.name = name + "-" + JavaUtils.getClassSimpleName(this.getClass());
        TimeDuration watchTimeout = RaftServerConfigKeys.Watch.timeout((RaftProperties)properties);
        this.watchTimeoutNanos = watchTimeout.to(TimeUnit.NANOSECONDS);
        TimeDuration watchTimeoutDenomination = RaftServerConfigKeys.Watch.timeoutDenomination((RaftProperties)properties);
        this.watchTimeoutDenominationNanos = watchTimeoutDenomination.to(TimeUnit.NANOSECONDS);
        Preconditions.assertTrue((this.watchTimeoutNanos.getDuration() % this.watchTimeoutDenominationNanos.getDuration() == 0L ? 1 : 0) != 0, () -> "watchTimeout (=" + watchTimeout + ") is not a multiple of watchTimeoutDenomination (=" + watchTimeoutDenomination + ").");
        int elementLimit = RaftServerConfigKeys.Watch.elementLimit((RaftProperties)properties);
        Arrays.stream(RaftProtos.ReplicationLevel.values()).forEach(r -> this.queues.put(r, new WatchQueue(this, r, elementLimit)));
    }

    CompletableFuture<Long> add(RaftClientRequest request) {
        RaftProtos.WatchRequestTypeProto watch = request.getType().getWatch();
        WatchQueue queue = (WatchQueue)this.queues.get(watch.getReplication());
        long queueIndex = queue.getIndex();
        if (watch.getIndex() <= queueIndex) {
            return CompletableFuture.completedFuture(queueIndex);
        }
        return queue.add(request);
    }

    void update(RaftProtos.ReplicationLevel replication, long newIndex) {
        WatchQueue queue = (WatchQueue)this.queues.get(replication);
        if (newIndex > queue.getIndex()) {
            queue.updateIndex(newIndex);
        }
    }

    void failWatches(Exception e) {
        this.queues.values().forEach(q -> q.failAll(e));
    }

    static /* synthetic */ TimeDuration access$000(WatchRequests x0) {
        return x0.watchTimeoutDenominationNanos;
    }

    static /* synthetic */ String access$100(WatchRequests x0) {
        return x0.name;
    }

    static /* synthetic */ TimeDuration access$200(WatchRequests x0) {
        return x0.watchTimeoutNanos;
    }

    static /* synthetic */ TimeoutExecutor access$300(WatchRequests x0) {
        return x0.scheduler;
    }
}

