/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RoleInfo;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SnapshotInstallationHandler {
    static final Logger LOG = LoggerFactory.getLogger(SnapshotInstallationHandler.class);
    static final TermIndex INVALID_TERM_INDEX = TermIndex.valueOf((long)0L, (long)-1L);
    private final RaftServerImpl server;
    private final ServerState state;
    private final boolean installSnapshotEnabled;
    private final AtomicLong inProgressInstallSnapshotIndex = new AtomicLong(-1L);
    private final AtomicReference<TermIndex> installedSnapshotTermIndex = new AtomicReference<TermIndex>(INVALID_TERM_INDEX);
    private final AtomicBoolean isSnapshotNull = new AtomicBoolean();
    private final AtomicLong installedIndex = new AtomicLong(-1L);

    SnapshotInstallationHandler(RaftServerImpl server, RaftProperties properties) {
        this.server = server;
        this.state = server.getState();
        this.installSnapshotEnabled = RaftServerConfigKeys.Log.Appender.installSnapshotEnabled((RaftProperties)properties);
    }

    RaftGroupMemberId getMemberId() {
        return this.state.getMemberId();
    }

    long getInstalledIndex() {
        return this.installedIndex.getAndSet(-1L);
    }

    long getInProgressInstallSnapshotIndex() {
        return this.inProgressInstallSnapshotIndex.get();
    }

    RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.InstallSnapshotReplyProto reply;
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: receive installSnapshot: {}", (Object)this.getMemberId(), (Object)ServerStringUtils.toInstallSnapshotRequestString((RaftProtos.InstallSnapshotRequestProto)request));
        }
        try {
            reply = this.installSnapshotImpl(request);
        }
        catch (Exception e) {
            LOG.error("{}: installSnapshot failed", (Object)this.getMemberId(), (Object)e);
            throw e;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: reply installSnapshot: {}", (Object)this.getMemberId(), (Object)ServerStringUtils.toInstallSnapshotReplyString((RaftProtos.InstallSnapshotReplyProto)reply));
        }
        return reply;
    }

    private RaftProtos.InstallSnapshotReplyProto installSnapshotImpl(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.RaftRpcRequestProto r = request.getServerRequest();
        RaftPeerId leaderId = RaftPeerId.valueOf((ByteString)r.getRequestorId());
        RaftGroupId leaderGroupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)r.getRaftGroupId());
        CodeInjectionForTesting.execute((String)RaftServerImpl.INSTALL_SNAPSHOT, (Object)this.server.getId(), (Object)leaderId, (Object[])new Object[]{request});
        this.server.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
        this.server.assertGroup((Object)leaderId, leaderGroupId);
        RaftProtos.InstallSnapshotReplyProto reply = null;
        if (this.installSnapshotEnabled) {
            if (request.hasSnapshotChunk()) {
                reply = this.checkAndInstallSnapshot(request, leaderId);
            }
        } else if (request.hasNotification()) {
            reply = this.notifyStateMachineToInstallSnapshot(request, leaderId);
        }
        if (reply != null) {
            if (request.hasLastRaftConfigurationLogEntryProto()) {
                RaftProtos.LogEntryProto proto = request.getLastRaftConfigurationLogEntryProto();
                if (!this.state.getRaftConf().equals((Object)LogProtoUtils.toRaftConfiguration((RaftProtos.LogEntryProto)proto))) {
                    LOG.info("{}: set new configuration {} from snapshot", (Object)this.getMemberId(), (Object)proto);
                    this.state.setRaftConf(proto);
                    this.state.writeRaftConfiguration(proto);
                    this.server.getStateMachine().event().notifyConfigurationChanged(proto.getTerm(), proto.getIndex(), proto.getConfigurationEntry());
                }
            }
            return reply;
        }
        RaftProtos.InstallSnapshotReplyProto failedReply = ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)this.state.getCurrentTerm(), (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.CONF_MISMATCH);
        LOG.error("{}: Configuration Mismatch ({}): Leader {} has it set to {} but follower {} has it set to {}", new Object[]{this.getMemberId(), "raft.server.log.appender.install.snapshot.enabled", leaderId, request.hasSnapshotChunk(), this.server.getId(), this.installSnapshotEnabled});
        return failedReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.InstallSnapshotReplyProto checkAndInstallSnapshot(RaftProtos.InstallSnapshotRequestProto request, RaftPeerId leaderId) throws IOException {
        long currentTerm;
        long leaderTerm = request.getLeaderTerm();
        RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto snapshotChunkRequest = request.getSnapshotChunk();
        TermIndex lastIncluded = TermIndex.valueOf((RaftProtos.TermIndexProto)snapshotChunkRequest.getTermIndex());
        long lastIncludedIndex = lastIncluded.getIndex();
        RaftServerImpl raftServerImpl = this.server;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.InstallSnapshotReplyProto reply = ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (int)snapshotChunkRequest.getRequestIndex(), (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.NOT_LEADER);
                LOG.warn("{}: Failed to recognize leader for installSnapshot chunk.", (Object)this.getMemberId());
                return reply;
            }
            this.server.changeToFollowerAndPersistMetadata(leaderTerm, true, (Object)"installSnapshot");
            this.state.setLeader(leaderId, (Object)"installSnapshot");
            this.server.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_START);
            try {
                Preconditions.assertTrue((this.state.getLog().getLastCommittedIndex() < lastIncludedIndex ? 1 : 0) != 0, (String)"%s log's commit index is %s, last included index in snapshot is %s", (Object[])new Object[]{this.getMemberId(), this.state.getLog().getLastCommittedIndex(), lastIncludedIndex});
                this.state.installSnapshot(request);
                if (snapshotChunkRequest.getDone()) {
                    this.state.reloadStateMachine(lastIncluded);
                }
            }
            finally {
                this.server.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_COMPLETE);
            }
        }
        if (snapshotChunkRequest.getDone()) {
            LOG.info("{}: successfully install the entire snapshot-{}", (Object)this.getMemberId(), (Object)lastIncludedIndex);
        }
        return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (int)snapshotChunkRequest.getRequestIndex(), (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.InstallSnapshotReplyProto notifyStateMachineToInstallSnapshot(RaftProtos.InstallSnapshotRequestProto request, RaftPeerId leaderId) throws IOException {
        long leaderTerm = request.getLeaderTerm();
        TermIndex firstAvailableLogTermIndex = TermIndex.valueOf((RaftProtos.TermIndexProto)request.getNotification().getFirstAvailableTermIndex());
        long firstAvailableLogIndex = firstAvailableLogTermIndex.getIndex();
        RaftServerImpl raftServerImpl = this.server;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            long currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.InstallSnapshotReplyProto reply2 = ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.NOT_LEADER);
                LOG.warn("{}: Failed to recognize leader for installSnapshot notification.", (Object)this.getMemberId());
                return reply2;
            }
            this.server.changeToFollowerAndPersistMetadata(leaderTerm, true, (Object)"installSnapshot");
            this.state.setLeader(leaderId, (Object)"installSnapshot");
            this.server.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_NOTIFICATION);
            if (this.inProgressInstallSnapshotIndex.compareAndSet(-1L, firstAvailableLogIndex)) {
                LOG.info("{}: Received notification to install snapshot at index {}", (Object)this.getMemberId(), (Object)firstAvailableLogIndex);
                long snapshotIndex = this.state.getLog().getSnapshotIndex();
                if (snapshotIndex + 1L >= firstAvailableLogIndex && firstAvailableLogIndex > -1L) {
                    this.inProgressInstallSnapshotIndex.compareAndSet(firstAvailableLogIndex, -1L);
                    LOG.info("{}: InstallSnapshot notification result: {}, current snapshot index: {}", new Object[]{this.getMemberId(), RaftProtos.InstallSnapshotResult.ALREADY_INSTALLED, snapshotIndex});
                    return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.ALREADY_INSTALLED, (long)snapshotIndex);
                }
                RaftProtos.RaftPeerProto leaderProto = !request.hasLastRaftConfigurationLogEntryProto() ? null : request.getLastRaftConfigurationLogEntryProto().getConfigurationEntry().getPeersList().stream().filter(p -> RaftPeerId.valueOf((ByteString)p.getId()).equals((Object)leaderId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Leader " + leaderId + " not found from the last configuration LogEntryProto, request = " + request));
                RaftProtos.RoleInfoProto proto = leaderProto == null || this.server.getRaftConf().getPeer(this.state.getLeaderId(), new RaftProtos.RaftPeerRole[0]) != null ? this.server.getRoleInfoProto() : this.getRoleInfoProto(ProtoUtils.toRaftPeer((RaftProtos.RaftPeerProto)leaderProto));
                LOG.info("{}: notifyInstallSnapshot: nextIndex is {} but the leader's first available index is {}.", new Object[]{this.getMemberId(), this.state.getLog().getNextIndex(), firstAvailableLogIndex});
                this.server.getStateMachine().followerEvent().notifyInstallSnapshotFromLeader(proto, firstAvailableLogTermIndex).whenComplete((reply, exception) -> {
                    if (exception != null) {
                        LOG.error("{}: Failed to notify StateMachine to InstallSnapshot. Exception: {}", (Object)this.getMemberId(), (Object)exception.getMessage());
                        this.inProgressInstallSnapshotIndex.compareAndSet(firstAvailableLogIndex, -1L);
                        return;
                    }
                    if (reply != null) {
                        LOG.info("{}: StateMachine successfully installed snapshot index {}. Reloading the StateMachine.", (Object)this.getMemberId(), (Object)reply.getIndex());
                        this.installedSnapshotTermIndex.set(reply);
                    } else {
                        this.isSnapshotNull.set(true);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{}: StateMachine could not install snapshot as it is not available", (Object)this);
                        }
                    }
                });
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: StateMachine is processing Snapshot Installation Request.", (Object)this.getMemberId());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{}: StateMachine is already installing a snapshot.", (Object)this.getMemberId());
            }
            long inProgressInstallSnapshotIndexValue = this.getInProgressInstallSnapshotIndex();
            Preconditions.assertTrue((inProgressInstallSnapshotIndexValue <= firstAvailableLogIndex && inProgressInstallSnapshotIndexValue > -1L ? 1 : 0) != 0, (String)"inProgressInstallSnapshotRequest: %s is not eligible, firstAvailableLogIndex: %s", (Object[])new Object[]{this.getInProgressInstallSnapshotIndex(), firstAvailableLogIndex});
            if (this.isSnapshotNull.compareAndSet(true, false)) {
                LOG.info("{}: InstallSnapshot notification result: {}", (Object)this.getMemberId(), (Object)RaftProtos.InstallSnapshotResult.SNAPSHOT_UNAVAILABLE);
                this.inProgressInstallSnapshotIndex.set(-1L);
                this.server.getStateMachine().event().notifySnapshotInstalled(RaftProtos.InstallSnapshotResult.SNAPSHOT_UNAVAILABLE, -1L, this.server.getPeer());
                return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.SNAPSHOT_UNAVAILABLE);
            }
            TermIndex latestInstalledSnapshotTermIndex = this.installedSnapshotTermIndex.getAndSet(INVALID_TERM_INDEX);
            if (latestInstalledSnapshotTermIndex.getIndex() > -1L) {
                this.server.getStateMachine().pause();
                this.state.reloadStateMachine(latestInstalledSnapshotTermIndex);
                LOG.info("{}: InstallSnapshot notification result: {}, at index: {}", new Object[]{this.getMemberId(), RaftProtos.InstallSnapshotResult.SNAPSHOT_INSTALLED, latestInstalledSnapshotTermIndex});
                this.inProgressInstallSnapshotIndex.set(-1L);
                long latestInstalledIndex = latestInstalledSnapshotTermIndex.getIndex();
                this.server.getStateMachine().event().notifySnapshotInstalled(RaftProtos.InstallSnapshotResult.SNAPSHOT_INSTALLED, latestInstalledIndex, this.server.getPeer());
                this.installedIndex.set(latestInstalledIndex);
                return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.SNAPSHOT_INSTALLED, (long)latestInstalledSnapshotTermIndex.getIndex());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: InstallSnapshot notification result: {}", (Object)this.getMemberId(), (Object)RaftProtos.InstallSnapshotResult.IN_PROGRESS);
            }
            return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.IN_PROGRESS);
        }
    }

    private RaftProtos.RoleInfoProto getRoleInfoProto(RaftPeer leader) {
        RoleInfo role = this.server.getRole();
        Optional fs = role.getFollowerState();
        RaftProtos.ServerRpcProto leaderInfo = ServerProtoUtils.toServerRpcProto((RaftPeer)leader, (long)fs.map(FollowerState::getLastRpcTime).map(Timestamp::elapsedTimeMs).orElse(0L));
        RaftProtos.FollowerInfoProto.Builder followerInfo = RaftProtos.FollowerInfoProto.newBuilder().setLeaderInfo(leaderInfo).setOutstandingOp(fs.map(FollowerState::getOutstandingOp).orElse(0).intValue());
        return RaftProtos.RoleInfoProto.newBuilder().setSelf(this.server.getPeer().getRaftPeerProto()).setRole(role.getCurrentRole()).setRoleElapsedTimeMs(role.getRoleElapsedTimeMs()).setFollowerInfo(followerInfo).build();
    }
}

