/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.Timekeeper;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.metrics.SegmentedRaftLogMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogBase;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLog;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogCache;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogWorker;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.AwaitToRun;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.UncheckedAutoCloseable;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SegmentedRaftLog
extends RaftLogBase {
    private final ServerLogMethods server;
    private final RaftStorage storage;
    private final StateMachine stateMachine;
    private final SegmentedRaftLogCache cache;
    private final AwaitToRun cacheEviction;
    private final SegmentedRaftLogWorker fileLogWorker;
    private final long segmentMaxSize;
    private final boolean stateMachineCachingEnabled;
    private final SegmentedRaftLogMetrics metrics;

    private ServerLogMethods newServerLogMethods(RaftServer.Division impl, Consumer<RaftProtos.LogEntryProto> notifyTruncatedLogEntry, BiFunction<RaftProtos.LogEntryProto, Boolean, TransactionContext> getTransactionContext) {
        if (impl == null) {
            return ServerLogMethods.DUMMY;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private SegmentedRaftLog(Builder b) {
        super(Builder.access$000((Builder)b), Builder.access$100((Builder)b), Builder.access$200((Builder)b));
        this.metrics = new SegmentedRaftLogMetrics(Builder.access$000((Builder)b));
        this.server = this.newServerLogMethods(Builder.access$300((Builder)b), Builder.access$400((Builder)b), Builder.access$500((Builder)b));
        this.storage = Builder.access$600((Builder)b);
        this.stateMachine = Builder.access$700((Builder)b);
        this.segmentMaxSize = RaftServerConfigKeys.Log.segmentSizeMax((RaftProperties)Builder.access$200((Builder)b)).getSize();
        this.cache = new SegmentedRaftLogCache((Object)Builder.access$000((Builder)b), this.storage, Builder.access$200((Builder)b), this.getRaftLogMetrics());
        this.cacheEviction = new AwaitToRun((Object)(Builder.access$000((Builder)b) + "-cacheEviction"), () -> this.checkAndEvictCache()).start();
        this.fileLogWorker = new SegmentedRaftLogWorker(Builder.access$000((Builder)b), this.stateMachine, Builder.access$800((Builder)b), Builder.access$300((Builder)b), this.storage, Builder.access$200((Builder)b), this.getRaftLogMetrics());
        this.stateMachineCachingEnabled = RaftServerConfigKeys.Log.StateMachineData.cachingEnabled((RaftProperties)Builder.access$200((Builder)b));
    }

    public SegmentedRaftLogMetrics getRaftLogMetrics() {
        return this.metrics;
    }

    protected void openImpl(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> consumer) throws IOException {
        this.loadLogSegments(lastIndexInSnapshot, consumer);
        File openSegmentFile = Optional.ofNullable(this.cache.getOpenSegment()).map(LogSegment::getFile).orElse(null);
        this.fileLogWorker.start(Math.max(this.cache.getEndIndex(), lastIndexInSnapshot), Math.min(this.cache.getLastIndexInClosedSegments(), lastIndexInSnapshot), openSegmentFile);
    }

    public long getStartIndex() {
        return this.cache.getStartIndex();
    }

    private void loadLogSegments(long lastIndexInSnapshot, Consumer<RaftProtos.LogEntryProto> logConsumer) throws IOException {
        try (AutoCloseableLock writeLock = this.writeLock();){
            List paths = LogSegmentPath.getLogSegmentPaths((RaftStorage)this.storage);
            int i = 0;
            for (LogSegmentPath pi : paths) {
                boolean keepEntryInCache = paths.size() - i++ <= this.cache.getMaxCachedSegments();
                UncheckedAutoCloseable ignored = this.getRaftLogMetrics().startLoadSegmentTimer();
                Throwable throwable = null;
                try {
                    this.cache.loadSegment(pi, keepEntryInCache, logConsumer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            if (!this.cache.isEmpty() && this.cache.getEndIndex() < lastIndexInSnapshot) {
                LOG.warn("End log index {} is smaller than last index in snapshot {}", (Object)this.cache.getEndIndex(), (Object)lastIndexInSnapshot);
                this.purgeImpl(lastIndexInSnapshot);
            }
        }
    }

    public RaftProtos.LogEntryProto get(long index) throws RaftLogIOException {
        LogSegment.LogRecord record;
        LogSegment segment;
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            segment = this.cache.getSegment(index);
            if (segment == null) {
                RaftProtos.LogEntryProto logEntryProto = null;
                return logEntryProto;
            }
            record = segment.getLogRecord(index);
            if (record == null) {
                RaftProtos.LogEntryProto logEntryProto = null;
                return logEntryProto;
            }
            RaftProtos.LogEntryProto entry = segment.getEntryFromCache(record.getTermIndex());
            if (entry != null) {
                this.getRaftLogMetrics().onRaftLogCacheHit();
                RaftProtos.LogEntryProto logEntryProto = entry;
                return logEntryProto;
            }
        }
        this.getRaftLogMetrics().onRaftLogCacheMiss();
        this.cacheEviction.signal();
        return segment.loadCache(record);
    }

    public RaftLog.EntryWithData getEntryWithData(long index) throws RaftLogIOException {
        RaftProtos.LogEntryProto entry = this.get(index);
        if (entry == null) {
            throw new RaftLogIOException("Log entry not found: index = " + index);
        }
        if (!LogProtoUtils.isStateMachineDataEmpty((RaftProtos.LogEntryProto)entry)) {
            return this.newEntryWithData(entry, null);
        }
        try {
            CompletionStage future = null;
            if (this.stateMachine != null) {
                future = this.stateMachine.data().read(entry, this.server.getTransactionContext(entry, false)).exceptionally(ex -> {
                    this.stateMachine.event().notifyLogFailed(ex, entry);
                    throw new CompletionException("Failed to read state machine data for log entry " + entry, (Throwable)ex);
                });
            }
            return this.newEntryWithData(entry, future);
        }
        catch (Exception e) {
            String err = this.getName() + ": Failed readStateMachineData for " + LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entry);
            LOG.error(err, (Throwable)e);
            throw new RaftLogIOException(err, JavaUtils.unwrapCompletionException((Throwable)e));
        }
    }

    private void checkAndEvictCache() {
        if (this.cache.shouldEvict()) {
            this.cache.evictCache(this.server.getFollowerNextIndices(), this.fileLogWorker.getSafeCacheEvictIndex(), this.server.getLastAppliedIndex());
        }
    }

    public TermIndex getTermIndex(long index) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            LogSegment.LogRecord record = this.cache.getLogRecord(index);
            TermIndex termIndex = record != null ? record.getTermIndex() : null;
            return termIndex;
        }
    }

    public LogEntryHeader[] getEntries(long startIndex, long endIndex) {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            LogEntryHeader[] logEntryHeaderArray = this.cache.getTermIndices(startIndex, endIndex);
            return logEntryHeaderArray;
        }
    }

    public TermIndex getLastEntryTermIndex() {
        this.checkLogState();
        try (AutoCloseableLock readLock = this.readLock();){
            TermIndex termIndex = this.cache.getLastTermIndex();
            return termIndex;
        }
    }

    protected CompletableFuture<Long> truncateImpl(long index) {
        this.checkLogState();
        try (AutoCloseableLock writeLock = this.writeLock();){
            SegmentedRaftLogCache.TruncationSegments ts = this.cache.truncate(index);
            if (ts != null) {
                Task task = this.fileLogWorker.truncate(ts, index);
                CompletableFuture completableFuture = task.getFuture();
                return completableFuture;
            }
        }
        return CompletableFuture.completedFuture(index);
    }

    protected CompletableFuture<Long> purgeImpl(long index) {
        try (AutoCloseableLock writeLock = this.writeLock();){
            SegmentedRaftLogCache.TruncationSegments ts = this.cache.purge(index);
            this.updateSnapshotIndexFromStateMachine();
            LOG.debug("purging segments:{}", (Object)ts);
            if (ts != null) {
                Task task = this.fileLogWorker.purge(ts);
                CompletableFuture completableFuture = task.getFuture();
                return completableFuture;
            }
        }
        return CompletableFuture.completedFuture(index);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CompletableFuture<Long> appendEntryImpl(RaftProtos.LogEntryProto entry, TransactionContext context) {
        this.checkLogState();
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: appendEntry {}", (Object)this.getName(), (Object)LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entry));
        }
        try (AutoCloseableLock writeLock = this.writeLock();){
            Timekeeper.Context appendEntryTimerContext = this.getRaftLogMetrics().startAppendEntryTimer();
            this.validateLogEntry(entry);
            LogSegment currentOpenSegment = this.cache.getOpenSegment();
            boolean rollOpenSegment = false;
            if (currentOpenSegment == null) {
                this.cache.addOpenSegment(entry.getIndex());
                this.fileLogWorker.startLogSegment(entry.getIndex());
            } else if (this.isSegmentFull(currentOpenSegment, entry)) {
                rollOpenSegment = true;
            } else {
                TermIndex last = currentOpenSegment.getLastTermIndex();
                if (last != null && last.getTerm() != entry.getTerm()) {
                    Preconditions.assertTrue((last.getTerm() < entry.getTerm() ? 1 : 0) != 0, (String)"open segment's term %s is larger than the new entry's term %s", (Object[])new Object[]{last.getTerm(), entry.getTerm()});
                    rollOpenSegment = true;
                }
            }
            if (rollOpenSegment) {
                this.cache.rollOpenSegment(true);
                this.fileLogWorker.rollLogSegment(currentOpenSegment);
                this.cacheEviction.signal();
            }
            CompletableFuture writeFuture = this.fileLogWorker.writeLogEntry(entry, context).getFuture();
            if (this.stateMachineCachingEnabled) {
                this.cache.appendEntry(LogProtoUtils.removeStateMachineData((RaftProtos.LogEntryProto)entry), LogSegment.Op.WRITE_CACHE_WITH_STATE_MACHINE_CACHE);
            } else {
                this.cache.appendEntry(entry, LogSegment.Op.WRITE_CACHE_WITHOUT_STATE_MACHINE_CACHE);
            }
            writeFuture.whenComplete((clientReply, exception) -> appendEntryTimerContext.stop());
            CompletableFuture completableFuture = writeFuture;
            return completableFuture;
        }
        catch (Exception e) {
            LOG.error("{}: Failed to append {}", new Object[]{this.getName(), LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)entry), e});
            throw e;
        }
    }

    private boolean isSegmentFull(LogSegment segment, RaftProtos.LogEntryProto entry) {
        if (segment.getTotalFileSize() >= this.segmentMaxSize) {
            return true;
        }
        long entrySize = LogSegment.getEntrySize((RaftProtos.LogEntryProto)entry, (LogSegment.Op)LogSegment.Op.CHECK_SEGMENT_FILE_FULL);
        return entrySize <= this.segmentMaxSize && segment.getTotalFileSize() + entrySize > this.segmentMaxSize;
    }

    public List<CompletableFuture<Long>> appendImpl(List<RaftProtos.LogEntryProto> entries) {
        this.checkLogState();
        if (entries == null || entries.isEmpty()) {
            return Collections.emptyList();
        }
        try (AutoCloseableLock writeLock = this.writeLock();){
            ArrayList<CompletableFuture<Long>> futures;
            SegmentedRaftLogCache.TruncateIndices ti = this.cache.computeTruncateIndices(arg_0 -> ((ServerLogMethods)this.server).notifyTruncatedLogEntry(arg_0), entries);
            long truncateIndex = ti.getTruncateIndex();
            int index = ti.getArrayIndex();
            LOG.debug("truncateIndex={}, arrayIndex={}", (Object)truncateIndex, (Object)index);
            if (truncateIndex != -1L) {
                futures = new ArrayList(entries.size() - index + 1);
                futures.add(this.truncate(truncateIndex));
            } else {
                futures = new ArrayList<CompletableFuture<Long>>(entries.size() - index);
            }
            for (int i = index; i < entries.size(); ++i) {
                RaftProtos.LogEntryProto entry = entries.get(i);
                futures.add(this.appendEntry(entry, this.server.getTransactionContext(entry, true)));
            }
            ArrayList<CompletableFuture<Long>> arrayList = futures;
            return arrayList;
        }
    }

    public long getFlushIndex() {
        return this.fileLogWorker.getFlushIndex();
    }

    public void persistMetadata(RaftStorageMetadata metadata) throws IOException {
        this.storage.getMetadataFile().persist(metadata);
    }

    public RaftStorageMetadata loadMetadata() throws IOException {
        return this.storage.getMetadataFile().getMetadata();
    }

    public CompletableFuture<Long> onSnapshotInstalled(long lastSnapshotIndex) {
        this.updateSnapshotIndex(lastSnapshotIndex);
        this.fileLogWorker.syncWithSnapshot(lastSnapshotIndex);
        LogSegment openSegment = this.cache.getOpenSegment();
        if (openSegment != null && openSegment.hasEntries()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("syncWithSnapshot : Found open segment {}, with end index {}, snapshotIndex {}", new Object[]{openSegment, openSegment.getEndIndex(), lastSnapshotIndex});
            }
            if (openSegment.getEndIndex() <= lastSnapshotIndex) {
                this.fileLogWorker.closeLogSegment(openSegment);
                this.cache.rollOpenSegment(false);
                this.cacheEviction.signal();
            }
        }
        return this.purgeImpl(lastSnapshotIndex);
    }

    public void close() throws IOException {
        try (AutoCloseableLock writeLock = this.writeLock();){
            super.close();
            this.cacheEviction.close();
            this.cache.close();
        }
        this.fileLogWorker.close();
        this.storage.close();
        this.getRaftLogMetrics().unregister();
    }

    SegmentedRaftLogCache getRaftLogCache() {
        return this.cache;
    }

    public String toLogEntryString(RaftProtos.LogEntryProto logEntry) {
        return LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)logEntry, arg_0 -> ((StateMachine)this.stateMachine).toStateMachineLogEntryString(arg_0));
    }

    public static Builder newBuilder() {
        return new Builder(null);
    }
}

