/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.metrics.SegmentedRaftLogMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.segmented.CacheInvalidationPolicy;
import org.apache.ratis.server.raftlog.segmented.LogSegment;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.raftlog.segmented.LogSegmentStartEnd;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogCache;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SizeInBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SegmentedRaftLogCache {
    public static final Logger LOG = LoggerFactory.getLogger(SegmentedRaftLogCache.class);
    private final String name;
    private volatile LogSegment openSegment;
    private final LogSegmentList closedSegments;
    private final RaftStorage storage;
    private final SizeInBytes maxOpSize;
    private final SegmentedRaftLogMetrics raftLogMetrics;
    private final int maxCachedSegments;
    private final CacheInvalidationPolicy evictionPolicy = new CacheInvalidationPolicy.CacheInvalidationPolicyDefault();
    private final long maxSegmentCacheSize;

    SegmentedRaftLogCache(Object name, RaftStorage storage, RaftProperties properties, SegmentedRaftLogMetrics raftLogMetrics) {
        this.name = name + "-" + JavaUtils.getClassSimpleName(this.getClass());
        this.closedSegments = new LogSegmentList(name);
        this.storage = storage;
        this.raftLogMetrics = raftLogMetrics;
        this.raftLogMetrics.addClosedSegmentsNum(() -> this.getCachedSegmentNum());
        this.raftLogMetrics.addClosedSegmentsSizeInBytes(() -> this.getClosedSegmentsSizeInBytes());
        this.raftLogMetrics.addOpenSegmentSizeInBytes(() -> this.getOpenSegmentSizeInBytes());
        this.maxCachedSegments = RaftServerConfigKeys.Log.segmentCacheNumMax((RaftProperties)properties);
        this.maxSegmentCacheSize = RaftServerConfigKeys.Log.segmentCacheSizeMax((RaftProperties)properties).getSize();
        this.maxOpSize = RaftServerConfigKeys.Log.Appender.bufferByteLimit((RaftProperties)properties);
    }

    int getMaxCachedSegments() {
        return this.maxCachedSegments;
    }

    void loadSegment(LogSegmentPath pi, boolean keepEntryInCache, Consumer<RaftProtos.LogEntryProto> logConsumer) throws IOException {
        LogSegment logSegment = LogSegment.loadSegment((RaftStorage)this.storage, (File)pi.getPath().toFile(), (LogSegmentStartEnd)pi.getStartEnd(), (SizeInBytes)this.maxOpSize, (boolean)keepEntryInCache, logConsumer, (SegmentedRaftLogMetrics)this.raftLogMetrics);
        if (logSegment != null) {
            this.addSegment(logSegment);
        }
    }

    long getCachedSegmentNum() {
        return this.closedSegments.countCached();
    }

    long getClosedSegmentsSizeInBytes() {
        return this.closedSegments.getTotalFileSize();
    }

    long getOpenSegmentSizeInBytes() {
        return this.openSegment == null ? 0L : this.openSegment.getTotalFileSize();
    }

    boolean shouldEvict() {
        CacheInfo closedSegmentsCacheInfo = this.closedSegments.getCacheInfo();
        if (closedSegmentsCacheInfo.getCount() > (long)this.maxCachedSegments) {
            return true;
        }
        long size = closedSegmentsCacheInfo.getSize() + Optional.ofNullable(this.openSegment).map(LogSegment::getTotalCacheSize).orElse(0L);
        return size > this.maxSegmentCacheSize;
    }

    void evictCache(long[] followerIndices, long safeEvictIndex, long lastAppliedIndex) {
        List toEvict = this.evictionPolicy.evict(followerIndices, safeEvictIndex, lastAppliedIndex, this.closedSegments, this.maxCachedSegments);
        for (LogSegment s : toEvict) {
            s.evictCache();
        }
    }

    private void validateAdding(LogSegment segment) {
        LogSegment lastClosed = this.closedSegments.getLast();
        if (lastClosed != null) {
            Preconditions.assertTrue((!lastClosed.isOpen() ? 1 : 0) != 0, () -> "Unexpected log segment state: the log segment " + lastClosed + " is open but it is not the last segment. The next log segment is " + segment);
            Preconditions.assertTrue((lastClosed.getEndIndex() + 1L == segment.getStartIndex() ? 1 : 0) != 0, () -> "Found a gap between logs: the last log segment " + lastClosed + " ended at " + lastClosed.getEndIndex() + " but the next log segment " + segment + " started at " + segment.getStartIndex());
        }
    }

    void addSegment(LogSegment segment) {
        this.validateAdding(segment);
        if (segment.isOpen()) {
            this.setOpenSegment(segment);
        } else {
            this.closedSegments.add(segment);
        }
    }

    void addOpenSegment(long startIndex) {
        this.setOpenSegment(LogSegment.newOpenSegment((RaftStorage)this.storage, (long)startIndex, (SizeInBytes)this.maxOpSize, (SegmentedRaftLogMetrics)this.raftLogMetrics));
    }

    private void setOpenSegment(LogSegment openSegment) {
        LOG.trace("{}: setOpenSegment to {}", (Object)this.name, (Object)openSegment);
        Preconditions.assertNull((Object)this.openSegment, (String)"this.openSegment");
        this.openSegment = Objects.requireNonNull(openSegment);
    }

    private void clearOpenSegment() {
        LOG.trace("{}: clearOpenSegment {}", (Object)this.name, (Object)this.openSegment);
        Objects.requireNonNull(this.openSegment);
        this.openSegment = null;
    }

    LogSegment getOpenSegment() {
        return this.openSegment;
    }

    void rollOpenSegment(boolean createNewOpen) {
        Preconditions.assertTrue((this.openSegment != null && this.openSegment.numOfEntries() > 0 ? 1 : 0) != 0, () -> "The number of entries of " + this.openSegment + " is " + this.openSegment.numOfEntries());
        long nextIndex = this.openSegment.getEndIndex() + 1L;
        this.openSegment.close();
        this.closedSegments.add(this.openSegment);
        this.clearOpenSegment();
        if (createNewOpen) {
            this.addOpenSegment(nextIndex);
        }
    }

    LogSegment getSegment(long index) {
        if (this.openSegment != null && index >= this.openSegment.getStartIndex()) {
            return this.openSegment;
        }
        return this.closedSegments.search(index);
    }

    LogSegment.LogRecord getLogRecord(long index) {
        LogSegment segment = this.getSegment(index);
        return segment == null ? null : segment.getLogRecord(index);
    }

    LogEntryHeader[] getTermIndices(long startIndex, long endIndex) {
        if (startIndex < 0L || startIndex < this.getStartIndex()) {
            throw new IndexOutOfBoundsException("startIndex = " + startIndex + ", log cache starts from index " + this.getStartIndex());
        }
        if (startIndex > endIndex) {
            throw new IndexOutOfBoundsException("startIndex(" + startIndex + ") > endIndex(" + endIndex + ")");
        }
        long realEnd = Math.min(this.getEndIndex() + 1L, endIndex);
        if (startIndex >= realEnd) {
            return LogEntryHeader.EMPTY_ARRAY;
        }
        return this.closedSegments.getTermIndex(startIndex, realEnd, this.openSegment);
    }

    private static void getFromSegment(LogSegment segment, long startIndex, LogEntryHeader[] entries, int offset, int size) {
        long endIndex = segment.getEndIndex();
        endIndex = Math.min(endIndex, startIndex + (long)size - 1L);
        int index = offset;
        for (long i = startIndex; i <= endIndex; ++i) {
            entries[index++] = Optional.ofNullable(segment.getLogRecord(i)).map(LogSegment.LogRecord::getLogEntryHeader).orElse(null);
        }
    }

    long getStartIndex() {
        try (AutoCloseableLock readLock = this.closedSegments.readLock();){
            if (this.closedSegments.isEmpty()) {
                long l = Optional.ofNullable(this.openSegment).map(LogSegment::getStartIndex).orElse(-1L);
                return l;
            }
            long l = this.closedSegments.get(0).getStartIndex();
            return l;
        }
    }

    long getEndIndex() {
        try (AutoCloseableLock readLock = this.closedSegments.readLock();){
            long l = this.openSegment != null ? this.openSegment.getEndIndex() : (this.closedSegments.isEmpty() ? -1L : this.closedSegments.get(this.closedSegments.size() - 1).getEndIndex());
            return l;
        }
    }

    long getLastIndexInClosedSegments() {
        try (AutoCloseableLock readLock = this.closedSegments.readLock();){
            long l = this.closedSegments.isEmpty() ? -1L : this.closedSegments.get(this.closedSegments.size() - 1).getEndIndex();
            return l;
        }
    }

    TermIndex getLastTermIndex() {
        try (AutoCloseableLock readLock = this.closedSegments.readLock();){
            TermIndex termIndex = this.openSegment != null && this.openSegment.numOfEntries() > 0 ? this.openSegment.getLastTermIndex() : (this.closedSegments.isEmpty() ? null : this.closedSegments.get(this.closedSegments.size() - 1).getLastTermIndex());
            return termIndex;
        }
    }

    void appendEntry(RaftProtos.LogEntryProto entry, LogSegment.Op op) {
        Preconditions.assertNotNull((Object)this.openSegment, (String)"openSegment");
        this.openSegment.appendToOpenSegment(entry, op);
    }

    TruncationSegments truncate(long index) {
        return this.closedSegments.truncate(index, this.openSegment, () -> this.clearOpenSegment());
    }

    TruncationSegments purge(long index) {
        return this.closedSegments.purge(index);
    }

    Iterator<TermIndex> iterator(long startIndex) {
        return new EntryIterator(this, startIndex);
    }

    TruncateIndices computeTruncateIndices(Consumer<TermIndex> failClientRequest, List<RaftProtos.LogEntryProto> entries) {
        int arrayIndex;
        long truncateIndex = -1L;
        try (AutoCloseableLock readLock = this.closedSegments.readLock();){
            Iterator i = this.iterator(entries.get(0).getIndex());
            for (arrayIndex = 0; i.hasNext() && arrayIndex < entries.size(); ++arrayIndex) {
                TermIndex storedEntry = (TermIndex)i.next();
                RaftProtos.LogEntryProto logEntryProto = entries.get(arrayIndex);
                Preconditions.assertTrue((storedEntry.getIndex() == logEntryProto.getIndex() ? 1 : 0) != 0, (String)"The stored entry's index %s is not consistent with the received entries[%s]'s index %s", (Object[])new Object[]{storedEntry.getIndex(), arrayIndex, logEntryProto.getIndex()});
                if (storedEntry.getTerm() == logEntryProto.getTerm()) continue;
                truncateIndex = storedEntry.getIndex();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{}: truncate to {}, arrayIndex={}, ti={}, storedEntry={}, entries={}", new Object[]{this.name, truncateIndex, arrayIndex, TermIndex.valueOf((RaftProtos.LogEntryProto)logEntryProto), storedEntry, LogProtoUtils.toLogEntriesString(entries)});
                }
                failClientRequest.accept(storedEntry);
                while (i.hasNext()) {
                    failClientRequest.accept((TermIndex)i.next());
                }
                break;
            }
        }
        return new TruncateIndices(arrayIndex, truncateIndex);
    }

    int getNumOfSegments() {
        return this.closedSegments.size() + (this.openSegment == null ? 0 : 1);
    }

    boolean isEmpty() {
        return this.closedSegments.isEmpty() && this.openSegment == null;
    }

    void close() {
        if (this.openSegment != null) {
            this.openSegment.clear();
            this.clearOpenSegment();
        }
        this.closedSegments.clear();
    }

    static /* synthetic */ void access$100(LogSegment x0, long x1, LogEntryHeader[] x2, int x3, int x4) {
        SegmentedRaftLogCache.getFromSegment((LogSegment)x0, (long)x1, (LogEntryHeader[])x2, (int)x3, (int)x4);
    }

    static /* synthetic */ LogSegmentList access$300(SegmentedRaftLogCache x0) {
        return x0.closedSegments;
    }

    static /* synthetic */ LogSegment access$400(SegmentedRaftLogCache x0) {
        return x0.openSegment;
    }
}

