/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.metrics.SegmentedRaftLogMetrics;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogInputStream;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogReader;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.OpenCloseState;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SizeInBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SegmentedRaftLogInputStream
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(SegmentedRaftLogInputStream.class);
    private final File logFile;
    private final long startIndex;
    private final long endIndex;
    private final boolean isOpen;
    private final OpenCloseState state;
    private SegmentedRaftLogReader reader;
    private final SizeInBytes maxOpSize;
    private final SegmentedRaftLogMetrics raftLogMetrics;

    SegmentedRaftLogInputStream(File log, long startIndex, long endIndex, boolean isOpen, SizeInBytes maxOpSize, SegmentedRaftLogMetrics raftLogMetrics) {
        this.maxOpSize = maxOpSize;
        if (isOpen) {
            Preconditions.assertTrue((endIndex == -1L ? 1 : 0) != 0);
        } else {
            Preconditions.assertTrue((endIndex >= startIndex ? 1 : 0) != 0);
        }
        this.logFile = log;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.isOpen = isOpen;
        this.state = new OpenCloseState(this.getName());
        this.raftLogMetrics = raftLogMetrics;
    }

    private void init() throws IOException {
        this.state.open();
        boolean initSuccess = false;
        try {
            this.reader = new SegmentedRaftLogReader(this.logFile, this.maxOpSize, this.raftLogMetrics);
            initSuccess = this.reader.verifyHeader();
        }
        finally {
            if (!initSuccess) {
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                }
                this.state.close();
            }
        }
    }

    long getStartIndex() {
        return this.startIndex;
    }

    long getEndIndex() {
        return this.endIndex;
    }

    String getName() {
        return this.logFile.getName();
    }

    public RaftProtos.LogEntryProto nextEntry() throws IOException {
        if (this.state.isUnopened()) {
            try {
                this.init();
            }
            catch (Exception e) {
                LOG.error("caught exception initializing " + this, (Throwable)e);
                throw IOUtils.asIOException((Throwable)e);
            }
        }
        Preconditions.assertTrue((!this.state.isUnopened() ? 1 : 0) != 0);
        if (this.state.isOpened()) {
            RaftProtos.LogEntryProto entry = this.reader.readEntry();
            if (entry != null) {
                long skipAmt;
                long index = entry.getIndex();
                if (!this.isOpen() && index >= this.endIndex && (skipAmt = this.logFile.length() - this.reader.getPos()) > 0L) {
                    LOG.debug("skipping {} bytes at the end of log '{}': reached entry {} out of {}", new Object[]{skipAmt, this.getName(), index, this.endIndex});
                    this.reader.skipFully(skipAmt);
                }
            }
            return entry;
        }
        if (this.state.isClosed()) {
            return null;
        }
        throw new IOException("Failed to get next entry from " + this, this.state.getThrowable());
    }

    long scanNextEntry() throws IOException {
        this.state.assertOpen();
        return this.reader.scanEntry();
    }

    long getPosition() {
        if (this.state.isOpened()) {
            return this.reader.getPos();
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.state.close()) {
            Optional.ofNullable(this.reader).ifPresent(SegmentedRaftLogReader::close);
        }
    }

    boolean isOpen() {
        return this.isOpen;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LogValidation scanEditLog(File file, long maxTxIdToScan, SizeInBytes maxOpSize) throws IOException {
        LogValidation logValidation;
        SegmentedRaftLogInputStream in;
        try {
            in = new SegmentedRaftLogInputStream(file, -1L, -1L, false, maxOpSize, null);
            in.init();
        }
        catch (EOFException e) {
            LOG.warn("Log file " + file + " has no valid header", (Throwable)e);
            return new LogValidation(0L, -1L, true);
        }
        try {
            logValidation = SegmentedRaftLogInputStream.scanEditLog((SegmentedRaftLogInputStream)in, (long)maxTxIdToScan);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Logger)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Logger)LOG, (Closeable[])new Closeable[]{in});
        return logValidation;
    }

    static LogValidation scanEditLog(SegmentedRaftLogInputStream in, long maxIndexToScan) {
        long lastPos = 0L;
        long end = -1L;
        long numValid = 0L;
        boolean hitError = false;
        while (end < maxIndexToScan) {
            long index;
            lastPos = in.getPosition();
            try {
                if (hitError) {
                    RaftProtos.LogEntryProto entry = in.nextEntry();
                    index = entry != null ? entry.getIndex() : -1L;
                    LOG.warn("After resync, position is " + in.getPosition());
                } else {
                    index = in.scanNextEntry();
                }
                if (index == -1L) break;
                hitError = false;
            }
            catch (Exception e) {
                LOG.warn("Caught exception after scanning through {} ops from {} while determining its valid length. Position was " + lastPos, new Object[]{numValid, in, e});
                hitError = true;
                continue;
            }
            if (end == -1L || index > end) {
                end = index;
            }
            ++numValid;
        }
        return new LogValidation(lastPos, end, false);
    }
}

