/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.BlockRequestHandlingInjection;
import org.apache.ratis.server.impl.DelayLocalExecutionInjection;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.raftlog.LogEntryHeader;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogBase;
import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public interface RaftTestUtil {
    public static final Logger LOG = LoggerFactory.getLogger(RaftTestUtil.class);

    public static Object getDeclaredField(Object obj, String fieldName) {
        Class<?> clazz = obj.getClass();
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(obj);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to get '" + fieldName + "' from " + clazz, e);
        }
    }

    public static RaftServer.Division waitForLeader(MiniRaftCluster cluster) throws InterruptedException {
        return RaftTestUtil.waitForLeader((MiniRaftCluster)cluster, null);
    }

    public static RaftServer.Division waitForLeader(MiniRaftCluster cluster, RaftGroupId groupId) throws InterruptedException {
        return RaftTestUtil.waitForLeader((MiniRaftCluster)cluster, (RaftGroupId)groupId, (boolean)true);
    }

    public static RaftServer.Division waitForLeader(MiniRaftCluster cluster, RaftGroupId groupId, boolean expectLeader) throws InterruptedException {
        String name = "waitForLeader-" + groupId + "-(expectLeader? " + expectLeader + ")";
        int numAttempts = expectLeader ? 100 : 10;
        TimeDuration sleepTime = cluster.getTimeoutMax().apply(d -> d * 3L >> 1);
        LOG.info(cluster.printServers(groupId));
        AtomicReference exception = new AtomicReference();
        Runnable handleNoLeaders = () -> {
            throw cluster.newIllegalStateExceptionForNoLeaders(groupId);
        };
        Consumer<List> handleMultipleLeaders = leaders -> {
            IllegalStateException ise = cluster.newIllegalStateExceptionForMultipleLeaders(groupId, leaders);
            exception.set(ise);
        };
        RaftServer.Division leader = (RaftServer.Division)JavaUtils.attempt(i -> {
            try {
                RaftServer.Division l = cluster.getLeader(groupId, handleNoLeaders, handleMultipleLeaders);
                if (l != null && !l.getInfo().isLeaderReady()) {
                    throw new IllegalStateException("Leader: " + l.getMemberId() + " not ready");
                }
                return l;
            }
            catch (Exception e) {
                LOG.warn("Attempt #{} failed: " + e, i);
                throw e;
            }
        }, (int)numAttempts, (TimeDuration)sleepTime, () -> name, null);
        LOG.info(cluster.printServers(groupId));
        if (expectLeader) {
            return Optional.ofNullable(leader).orElseThrow(exception::get);
        }
        if (leader == null) {
            return null;
        }
        throw new IllegalStateException("expectLeader = " + expectLeader + " but leader = " + leader);
    }

    public static RaftPeerId waitAndKillLeader(MiniRaftCluster cluster) throws InterruptedException {
        RaftServer.Division leader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
        Assert.assertNotNull((Object)leader);
        LOG.info("killing leader = " + leader);
        cluster.killServer(leader.getId());
        return leader.getId();
    }

    public static void waitFor(Supplier<Boolean> check, int checkEveryMillis, int waitForMillis) throws TimeoutException, InterruptedException {
        Preconditions.checkNotNull(check);
        Preconditions.checkArgument((waitForMillis >= checkEveryMillis ? 1 : 0) != 0);
        long st = System.currentTimeMillis();
        boolean result = check.get();
        while (!result && System.currentTimeMillis() - st < (long)waitForMillis) {
            Thread.sleep(checkEveryMillis);
            result = check.get();
        }
        if (!result) {
            throw new TimeoutException("Timed out waiting for condition.");
        }
    }

    public static boolean logEntriesContains(RaftLog log, SimpleMessage ... expectedMessages) {
        return RaftTestUtil.logEntriesContains((RaftLog)log, (long)0L, (long)Long.MAX_VALUE, (SimpleMessage[])expectedMessages);
    }

    public static boolean logEntriesNotContains(RaftLog log, SimpleMessage ... expectedMessages) {
        return RaftTestUtil.logEntriesNotContains((RaftLog)log, (long)0L, (long)Long.MAX_VALUE, (SimpleMessage[])expectedMessages);
    }

    public static boolean logEntriesContains(RaftLog log, long startIndex, long endIndex, SimpleMessage ... expectedMessages) {
        int idxExpected = 0;
        LogEntryHeader[] termIndices = log.getEntries(startIndex, endIndex);
        for (int idxEntries = 0; idxEntries < termIndices.length && idxExpected < expectedMessages.length; ++idxEntries) {
            try {
                if (!Arrays.equals(expectedMessages[idxExpected].getContent().toByteArray(), log.get(termIndices[idxEntries].getIndex()).getStateMachineLogEntry().getLogData().toByteArray())) continue;
                ++idxExpected;
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return idxExpected == expectedMessages.length;
    }

    public static boolean logEntriesNotContains(RaftLog log, long startIndex, long endIndex, SimpleMessage ... expectedMessages) {
        int idxEntries = 0;
        LogEntryHeader[] termIndices = log.getEntries(startIndex, endIndex);
        for (int idxExpected = 0; idxEntries < termIndices.length && idxExpected < expectedMessages.length; ++idxExpected, ++idxEntries) {
            try {
                if (!Arrays.equals(expectedMessages[idxExpected].getContent().toByteArray(), log.get(termIndices[idxEntries].getIndex()).getStateMachineLogEntry().getLogData().toByteArray())) continue;
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public static void checkLogEntries(RaftLog log, SimpleMessage[] expectedMessages, Predicate<RaftProtos.LogEntryProto> predicate) {
        LogEntryHeader[] termIndices = log.getEntries(0L, Long.MAX_VALUE);
        for (int i = 0; i < termIndices.length; ++i) {
            for (int j = 0; j < expectedMessages.length; ++j) {
                try {
                    RaftProtos.LogEntryProto e = log.get(termIndices[i].getIndex());
                    if (!Arrays.equals(expectedMessages[j].getContent().toByteArray(), e.getStateMachineLogEntry().getLogData().toByteArray())) continue;
                    Assert.assertTrue((boolean)predicate.test(e));
                    continue;
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static void assertLogEntries(MiniRaftCluster cluster, SimpleMessage[] expectedMessages) {
        for (SimpleMessage m : expectedMessages) {
            RaftTestUtil.assertLogEntries((MiniRaftCluster)cluster, (SimpleMessage)m);
        }
    }

    public static void assertLogEntries(MiniRaftCluster cluster, SimpleMessage expectedMessage) {
        int size = cluster.getNumServers();
        long count = cluster.getServerAliveStream().map(RaftServer.Division::getRaftLog).filter(log -> RaftTestUtil.logEntriesContains((RaftLog)log, (SimpleMessage[])new SimpleMessage[]{expectedMessage})).count();
        if (2L * count <= (long)size) {
            throw new AssertionError((Object)("Not in majority: size=" + size + " but count=" + count));
        }
    }

    public static void assertLogEntries(RaftServer.Division server, long expectedTerm, SimpleMessage ... expectedMessages) {
        LOG.info("checking raft log for {}", (Object)server.getMemberId());
        RaftLog log = server.getRaftLog();
        try {
            RaftTestUtil.assertLogEntries((RaftLog)log, (long)expectedTerm, (SimpleMessage[])expectedMessages);
        }
        catch (AssertionError e) {
            LOG.error("Unexpected raft log in {}", (Object)server.getMemberId(), (Object)e);
            throw e;
        }
    }

    public static Iterable<RaftProtos.LogEntryProto> getLogEntryProtos(RaftLog log) {
        return CollectionUtils.as((Object[])log.getEntries(0L, Long.MAX_VALUE), ti -> {
            try {
                return log.get(ti.getIndex());
            }
            catch (IOException exception) {
                throw new AssertionError("Failed to get log at " + ti, exception);
            }
        });
    }

    public static List<RaftProtos.LogEntryProto> getStateMachineLogEntries(RaftLog log) {
        ArrayList<RaftProtos.LogEntryProto> entries = new ArrayList<RaftProtos.LogEntryProto>();
        for (RaftProtos.LogEntryProto e : RaftTestUtil.getLogEntryProtos((RaftLog)log)) {
            String s = LogProtoUtils.toLogEntryString((RaftProtos.LogEntryProto)e);
            if (e.hasStateMachineLogEntry()) {
                LOG.info(s + ", " + e.getStateMachineLogEntry().toString().trim().replace("\n", ", "));
                entries.add(e);
                continue;
            }
            if (e.hasConfigurationEntry()) {
                LOG.info("Found {}, ignoring it.", (Object)s);
                continue;
            }
            if (e.hasMetadataEntry()) {
                LOG.info("Found {}, ignoring it.", (Object)s);
                continue;
            }
            throw new AssertionError((Object)("Unexpected LogEntryBodyCase " + e.getLogEntryBodyCase() + " at " + s));
        }
        return entries;
    }

    public static void assertLogEntries(RaftLog log, long expectedTerm, SimpleMessage ... expectedMessages) {
        List entries = RaftTestUtil.getStateMachineLogEntries((RaftLog)log);
        try {
            RaftTestUtil.assertLogEntries((List)entries, (long)expectedTerm, (SimpleMessage[])expectedMessages);
        }
        catch (Exception t) {
            throw new AssertionError("entries: " + entries, t);
        }
    }

    public static void assertLogEntries(List<RaftProtos.LogEntryProto> entries, long expectedTerm, SimpleMessage ... expectedMessages) {
        long logIndex = 0L;
        Assert.assertEquals((long)expectedMessages.length, (long)entries.size());
        for (int i = 0; i < expectedMessages.length; ++i) {
            RaftProtos.LogEntryProto e = entries.get(i);
            Assert.assertTrue((e.getTerm() >= expectedTerm ? 1 : 0) != 0);
            if (e.getTerm() > expectedTerm) {
                expectedTerm = e.getTerm();
            }
            Assert.assertTrue((e.getIndex() > logIndex ? 1 : 0) != 0);
            logIndex = e.getIndex();
            Assert.assertArrayEquals((byte[])expectedMessages[i].getContent().toByteArray(), (byte[])e.getStateMachineLogEntry().getLogData().toByteArray());
        }
    }

    public static void block(BooleanSupplier isBlocked) throws InterruptedException {
        while (isBlocked.getAsBoolean()) {
            RaftServerConfigKeys.Rpc.TIMEOUT_MAX_DEFAULT.sleep();
        }
    }

    public static void delay(IntSupplier getDelayMs) throws InterruptedException {
        int t = getDelayMs.getAsInt();
        if (t > 0) {
            Thread.sleep(t);
        }
    }

    public static RaftPeerId changeLeader(MiniRaftCluster cluster, RaftPeerId oldLeader) throws Exception {
        return RaftTestUtil.changeLeader((MiniRaftCluster)cluster, (RaftPeerId)oldLeader, AssumptionViolatedException::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RaftPeerId changeLeader(MiniRaftCluster cluster, RaftPeerId oldLeader, Function<String, Exception> constructor) throws Exception {
        String name = JavaUtils.getCallerStackTraceElement().getMethodName() + "-changeLeader";
        cluster.setBlockRequestsFrom(oldLeader.toString(), true);
        try {
            RaftPeerId raftPeerId = (RaftPeerId)JavaUtils.attemptRepeatedly(() -> {
                RaftPeerId newLeader = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster).getId();
                if (newLeader.equals((Object)oldLeader)) {
                    throw (Exception)constructor.apply("Failed to change leader: newLeader == oldLeader == " + oldLeader);
                }
                LOG.info("Changed leader from " + oldLeader + " to " + newLeader);
                return newLeader;
            }, (int)20, (TimeDuration)BaseTest.HUNDRED_MILLIS, (String)name, (Logger)LOG);
            return raftPeerId;
        }
        finally {
            cluster.setBlockRequestsFrom(oldLeader.toString(), false);
        }
    }

    public static void blockQueueAndSetDelay(Iterable<RaftServer> servers, DelayLocalExecutionInjection injection, String leaderId, int delayMs, TimeDuration maxTimeout) throws InterruptedException {
        boolean block = delayMs > 0;
        LOG.debug("{} requests sent to leader {} and set {}ms delay for the others", new Object[]{block ? "Block" : "Unblock", leaderId, delayMs});
        if (block) {
            BlockRequestHandlingInjection.getInstance().blockReplier(leaderId);
        } else {
            BlockRequestHandlingInjection.getInstance().unblockReplier(leaderId);
        }
        StreamSupport.stream(servers.spliterator(), false).filter(s -> !s.getId().toString().equals(leaderId)).forEach(s -> {
            if (block) {
                injection.setDelayMs(s.getId().toString(), delayMs);
            } else {
                injection.removeDelay(s.getId().toString());
            }
        });
        Thread.sleep(3L * maxTimeout.toLong(TimeUnit.MILLISECONDS));
    }

    public static Thread sendMessageInNewThread(MiniRaftCluster cluster, RaftPeerId leaderId, SimpleMessage ... messages) {
        Thread t = new Thread(() -> {
            try (RaftClient client = cluster.createClient(leaderId);){
                for (SimpleMessage mssg : messages) {
                    client.io().send((Message)mssg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        t.start();
        return t;
    }

    public static void assertSameLog(RaftLog expected, RaftLog computed) throws Exception {
        Assert.assertEquals((Object)expected.getLastEntryTermIndex(), (Object)computed.getLastEntryTermIndex());
        long lastIndex = expected.getNextIndex() - 1L;
        Assert.assertEquals((long)expected.getLastEntryTermIndex().getIndex(), (long)lastIndex);
        for (long i = 0L; i < lastIndex; ++i) {
            Assert.assertEquals((Object)expected.get(i), (Object)computed.get(i));
        }
    }

    public static EnumMap<RaftProtos.LogEntryProto.LogEntryBodyCase, AtomicLong> countEntries(RaftLog raftLog) throws Exception {
        EnumMap<RaftProtos.LogEntryProto.LogEntryBodyCase, AtomicLong> counts = new EnumMap<RaftProtos.LogEntryProto.LogEntryBodyCase, AtomicLong>(RaftProtos.LogEntryProto.LogEntryBodyCase.class);
        for (long i = 0L; i < raftLog.getNextIndex(); ++i) {
            RaftProtos.LogEntryProto e = raftLog.get(i);
            counts.computeIfAbsent(e.getLogEntryBodyCase(), c -> new AtomicLong()).incrementAndGet();
        }
        return counts;
    }

    public static RaftProtos.LogEntryProto getLastEntry(RaftProtos.LogEntryProto.LogEntryBodyCase targetCase, RaftLog raftLog) throws Exception {
        try (AutoCloseableLock readLock = ((RaftLogBase)raftLog).readLock();){
            for (long i = raftLog.getNextIndex() - 1L; i >= 0L; --i) {
                RaftProtos.LogEntryProto entry = raftLog.get(i);
                if (entry.getLogEntryBodyCase() != targetCase) continue;
                RaftProtos.LogEntryProto logEntryProto = entry;
                return logEntryProto;
            }
        }
        return null;
    }

    public static void assertSuccessReply(CompletableFuture<RaftClientReply> reply) throws Exception {
        RaftTestUtil.assertSuccessReply((RaftClientReply)reply.get(10L, TimeUnit.SECONDS));
    }

    public static void assertSuccessReply(RaftClientReply reply) {
        Assert.assertNotNull((String)"reply == null", (Object)reply);
        Assert.assertTrue((String)("reply is not success: " + reply), (boolean)reply.isSuccess());
    }
}

