/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.ReadOnlyRequestTests;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.ReadIndexException;
import org.apache.ratis.retry.ExceptionDependentRetry;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ReadOnlyRequestTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final int NUM_SERVERS = 3;
    static final String INCREMENT = "INCREMENT";
    static final String WAIT_AND_INCREMENT = "WAIT_AND_INCREMENT";
    static final String QUERY = "QUERY";
    final Message incrementMessage;
    final Message waitAndIncrementMessage;
    final Message queryMessage;

    public ReadOnlyRequestTests() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        this.incrementMessage = new RaftTestUtil.SimpleMessage("INCREMENT");
        this.waitAndIncrementMessage = new RaftTestUtil.SimpleMessage("WAIT_AND_INCREMENT");
        this.queryMessage = new RaftTestUtil.SimpleMessage("QUERY");
    }

    @Before
    public void setup() {
        RaftProperties p = this.getProperties();
        p.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, CounterStateMachine.class, StateMachine.class);
    }

    @Test
    public void testLinearizableRead() throws Exception {
        this.getProperties().setEnum(RaftServerConfigKeys.Read.OPTION_KEY, (Enum)RaftServerConfigKeys.Read.Option.LINEARIZABLE);
        this.runWithNewCluster(3, arg_0 -> this.testReadOnlyImpl(arg_0));
    }

    @Test
    public void testLeaseRead() throws Exception {
        this.getProperties().setBoolean(RaftServerConfigKeys.Read.LEADER_LEASE_ENABLED_KEY, true);
        this.runWithNewCluster(3, arg_0 -> this.testReadOnlyImpl(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadOnlyImpl(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            try (RaftClient client = cluster.createClient(leaderId);){
                for (int i = 1; i <= 10; ++i) {
                    RaftClientReply reply = client.io().send(this.incrementMessage);
                    Assert.assertTrue((boolean)reply.isSuccess());
                    reply = client.io().sendReadOnly(this.queryMessage);
                    Assert.assertEquals((long)i, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)reply));
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testLinearizableReadTimeout() throws Exception {
        this.getProperties().setEnum(RaftServerConfigKeys.Read.OPTION_KEY, (Enum)RaftServerConfigKeys.Read.Option.LINEARIZABLE);
        this.runWithNewCluster(3, arg_0 -> this.testReadOnlyTimeoutImpl(arg_0));
    }

    @Test
    public void testLeaseReadTimeout() throws Exception {
        this.getProperties().setBoolean(RaftServerConfigKeys.Read.LEADER_LEASE_ENABLED_KEY, true);
        this.runWithNewCluster(3, arg_0 -> this.testReadOnlyTimeoutImpl(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testReadOnlyTimeoutImpl(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            try (RaftClient client = cluster.createClient(leaderId);
                 RaftClient noRetry = cluster.createClient(leaderId, RetryPolicies.noRetry());){
                CompletableFuture result = client.async().send(this.incrementMessage);
                client.admin().transferLeadership(null, 200L);
                Assert.assertThrows(ReadIndexException.class, () -> {
                    RaftClientReply timeoutReply = noRetry.io().sendReadOnly(this.queryMessage);
                    Assert.assertNotNull((Object)timeoutReply.getException());
                    Assert.assertTrue((boolean)(timeoutReply.getException() instanceof ReadException));
                });
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFollowerLinearizableRead() throws Exception {
        this.getProperties().setEnum(RaftServerConfigKeys.Read.OPTION_KEY, (Enum)RaftServerConfigKeys.Read.Option.LINEARIZABLE);
        this.runWithNewCluster(3, arg_0 -> this.testFollowerReadOnlyImpl(arg_0));
    }

    @Test
    public void testFollowerLeaseRead() throws Exception {
        this.getProperties().setBoolean(RaftServerConfigKeys.Read.LEADER_LEASE_ENABLED_KEY, true);
        this.runWithNewCluster(3, arg_0 -> this.testFollowerReadOnlyImpl(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFollowerReadOnlyImpl(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            List followers = cluster.getFollowers();
            Assert.assertEquals((long)2L, (long)followers.size());
            RaftPeerId f0 = ((RaftServer.Division)followers.get(0)).getId();
            RaftPeerId f1 = ((RaftServer.Division)followers.get(1)).getId();
            try (RaftClient client = cluster.createClient(cluster.getLeader().getId());){
                for (int i = 1; i <= 10; ++i) {
                    RaftClientReply reply = client.io().send(this.incrementMessage);
                    Assert.assertTrue((boolean)reply.isSuccess());
                    RaftClientReply read1 = client.io().sendReadOnly(this.queryMessage, f0);
                    Assert.assertEquals((long)i, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)read1));
                    CompletableFuture read2 = client.async().sendReadOnly(this.queryMessage, f1);
                    Assert.assertEquals((long)i, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)((RaftClientReply)read2.get(1L, TimeUnit.SECONDS))));
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFollowerLinearizableReadParallel() throws Exception {
        this.getProperties().setEnum(RaftServerConfigKeys.Read.OPTION_KEY, (Enum)RaftServerConfigKeys.Read.Option.LINEARIZABLE);
        this.runWithNewCluster(3, arg_0 -> this.testFollowerReadOnlyParallelImpl(arg_0));
    }

    @Test
    public void testFollowerLeaseReadParallel() throws Exception {
        this.getProperties().setBoolean(RaftServerConfigKeys.Read.LEADER_LEASE_ENABLED_KEY, true);
        this.runWithNewCluster(3, arg_0 -> this.testFollowerReadOnlyParallelImpl(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFollowerReadOnlyParallelImpl(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            List followers = cluster.getFollowers();
            Assert.assertEquals((long)2L, (long)followers.size());
            try (RaftClient leaderClient = cluster.createClient(cluster.getLeader().getId());
                 RaftClient followerClient1 = cluster.createClient(((RaftServer.Division)followers.get(0)).getId());){
                leaderClient.io().send(this.incrementMessage);
                leaderClient.async().send(this.waitAndIncrementMessage);
                Thread.sleep(100L);
                RaftClientReply clientReply = followerClient1.io().sendReadOnly(this.queryMessage, ((RaftServer.Division)followers.get(0)).getId());
                Assert.assertEquals((long)2L, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)clientReply));
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFollowerLinearizableReadFailWhenLeaderDown() throws Exception {
        this.getProperties().setEnum(RaftServerConfigKeys.Read.OPTION_KEY, (Enum)RaftServerConfigKeys.Read.Option.LINEARIZABLE);
        this.runWithNewCluster(3, arg_0 -> this.testFollowerReadOnlyFailWhenLeaderDownImpl(arg_0));
    }

    @Test
    public void testFollowerLeaseReadWhenLeaderDown() throws Exception {
        this.getProperties().setBoolean(RaftServerConfigKeys.Read.LEADER_LEASE_ENABLED_KEY, true);
        this.runWithNewCluster(3, arg_0 -> this.testFollowerReadOnlyFailWhenLeaderDownImpl(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFollowerReadOnlyFailWhenLeaderDownImpl(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            List followers = cluster.getFollowers();
            Assert.assertEquals((long)2L, (long)followers.size());
            try (RaftClient leaderClient = cluster.createClient(cluster.getLeader().getId());
                 RaftClient followerClient1 = cluster.createClient(((RaftServer.Division)followers.get(0)).getId(), RetryPolicies.noRetry());){
                leaderClient.io().send(this.incrementMessage);
                RaftClientReply clientReply = followerClient1.io().sendReadOnly(this.queryMessage);
                Assert.assertEquals((long)1L, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)clientReply));
                leaderClient.admin().transferLeadership(null, 200L);
                Assert.assertThrows(ReadIndexException.class, () -> followerClient1.io().sendReadOnly(this.queryMessage, ((RaftServer.Division)followers.get(0)).getId()));
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testFollowerReadOnlyRetryWhenLeaderDown() throws Exception {
        this.getProperties().setEnum(RaftServerConfigKeys.Read.OPTION_KEY, (Enum)RaftServerConfigKeys.Read.Option.LINEARIZABLE);
        this.runWithNewCluster(3, arg_0 -> this.testFollowerReadOnlyRetryWhenLeaderDown(arg_0));
    }

    @Test
    public void testFollowerLeaseReadRetryWhenLeaderDown() throws Exception {
        this.getProperties().setBoolean(RaftServerConfigKeys.Read.LEADER_LEASE_ENABLED_KEY, true);
        this.runWithNewCluster(3, arg_0 -> this.testFollowerReadOnlyRetryWhenLeaderDown(arg_0));
    }

    private void testFollowerReadOnlyRetryWhenLeaderDown(CLUSTER cluster) throws Exception {
        ExceptionDependentRetry retryPolicy = ExceptionDependentRetry.newBuilder().setDefaultPolicy(RetryPolicies.noRetry()).setExceptionToPolicy(ReadIndexException.class, (RetryPolicy)RetryPolicies.retryForeverWithSleep((TimeDuration)TimeDuration.valueOf((long)500L, (TimeUnit)TimeUnit.MILLISECONDS))).build();
        RaftTestUtil.waitForLeader(cluster);
        try (RaftClient client = cluster.createClient(cluster.getLeader().getId(), (RetryPolicy)retryPolicy);){
            client.io().send(this.incrementMessage);
            RaftClientReply clientReply = client.io().sendReadOnly(this.queryMessage);
            Assert.assertEquals((long)1L, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)clientReply));
            client.admin().transferLeadership(null, 200L);
            RaftClientReply replySuccess = client.io().sendReadOnly(this.queryMessage);
            Assert.assertEquals((long)1L, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)clientReply));
        }
    }

    @Test
    public void testReadAfterWrite() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.testReadAfterWriteImpl(arg_0));
    }

    private void testReadAfterWriteImpl(CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        try (RaftClient client = cluster.createClient();){
            client.io().send(this.incrementMessage);
            RaftClientReply blockReply = client.io().sendReadAfterWrite(this.queryMessage);
            Assert.assertEquals((long)1L, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)blockReply));
            client.async().send(this.incrementMessage);
            client.async().sendReadAfterWrite(this.queryMessage).thenAccept(reply -> Assert.assertEquals((long)2L, (long)ReadOnlyRequestTests.retrieve((RaftClientReply)reply)));
            for (int i = 0; i < 20; ++i) {
                client.async().send(this.incrementMessage);
            }
            CompletableFuture linearizable = client.async().sendReadOnly(this.queryMessage);
            CompletableFuture readAfterWrite = client.async().sendReadAfterWrite(this.queryMessage);
            CompletableFuture.allOf(linearizable, readAfterWrite).get();
            Assert.assertTrue((ReadOnlyRequestTests.retrieve((RaftClientReply)((RaftClientReply)readAfterWrite.get())) >= ReadOnlyRequestTests.retrieve((RaftClientReply)((RaftClientReply)linearizable.get())) ? 1 : 0) != 0);
        }
    }

    static int retrieve(RaftClientReply reply) {
        return Integer.parseInt(reply.getMessage().getContent().toString(StandardCharsets.UTF_8));
    }
}

