/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.CallId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.ServerFactory;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.memory.MemoryRaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.NetUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class MiniRaftCluster
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(MiniRaftCluster.class);
    public static final String CLASS_NAME = JavaUtils.getClassSimpleName(MiniRaftCluster.class);
    public static final String STATEMACHINE_CLASS_KEY = CLASS_NAME + ".statemachine.class";
    private static final StateMachine.Registry STATEMACHINE_REGISTRY_DEFAULT = gid -> new BaseStateMachine();
    private static final TimeDuration RETRY_INTERVAL_DEFAULT = TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    static final AtomicInteger THREAD_COUNT = new AtomicInteger(0);
    private final Supplier<File> rootTestDir = JavaUtils.memoize(() -> new File(BaseTest.getRootTestDir(), JavaUtils.getClassSimpleName(this.getClass()) + Integer.toHexString(ThreadLocalRandom.current().nextInt())));
    protected RaftGroup group;
    protected final RaftProperties properties;
    protected final Parameters parameters;
    protected final Map<RaftPeerId, RaftServerProxy> servers = new ConcurrentHashMap();
    protected final Map<RaftPeerId, RaftPeer> peers = new ConcurrentHashMap();
    private volatile StateMachine.Registry stateMachineRegistry = null;
    private final AtomicReference<Timer> timer = new AtomicReference();

    public static RaftGroup initRaftGroup(Collection<String> ids, Collection<String> listenerIds) {
        Stream<RaftPeer> peer = ids.stream().map(id -> RaftPeer.newBuilder().setId(id)).map(MiniRaftCluster::assignAddresses).map(RaftPeer.Builder::build);
        Stream<RaftPeer> listener = listenerIds.stream().map(id -> RaftPeer.newBuilder().setId(id)).map(MiniRaftCluster::assignAddresses).map(p -> p.setStartupRole(RaftProtos.RaftPeerRole.LISTENER)).map(RaftPeer.Builder::build);
        RaftPeer[] peers = (RaftPeer[])Stream.concat(peer, listener).toArray(RaftPeer[]::new);
        return RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), (RaftPeer[])peers);
    }

    private static RaftPeer.Builder assignAddresses(RaftPeer.Builder builder) {
        return builder.setAddress(NetUtils.localhostWithFreePort()).setAdminAddress(NetUtils.localhostWithFreePort()).setClientAddress(NetUtils.localhostWithFreePort()).setDataStreamAddress(NetUtils.localhostWithFreePort());
    }

    public File getStorageDir(RaftPeerId id) {
        return new File((File)this.rootTestDir.get(), id.toString());
    }

    public static String[] generateIds(int numServers, int base) {
        String[] ids = new String[numServers];
        for (int i = 0; i < numServers; ++i) {
            ids[i] = "s" + (i + base);
        }
        return ids;
    }

    public static int getIdIndex(String id) {
        return Integer.parseInt(id.substring(1));
    }

    protected MiniRaftCluster(String[] ids, String[] listenerIds, RaftProperties properties, Parameters parameters) {
        this.group = MiniRaftCluster.initRaftGroup(Arrays.asList(ids), Arrays.asList(listenerIds));
        LOG.info("new {} with {}", (Object)JavaUtils.getClassSimpleName(this.getClass()), (Object)this.group);
        this.properties = new RaftProperties(properties);
        this.parameters = parameters;
        ExitUtils.disableSystemExit();
    }

    public RaftProperties getProperties() {
        return this.properties;
    }

    public MiniRaftCluster initServers() {
        LOG.info("servers = " + this.servers);
        if (this.servers.isEmpty()) {
            this.putNewServers(CollectionUtils.as((Iterable)this.group.getPeers(), RaftPeer::getId), true, this.group);
        }
        return this;
    }

    public RaftServerProxy putNewServer(RaftPeerId id, RaftGroup group, boolean format) {
        RaftServerProxy s = this.newRaftServer(id, group, format);
        this.peers.put(s.getId(), s.getPeer());
        Preconditions.assertTrue((this.servers.put(id, s) == null ? 1 : 0) != 0);
        return s;
    }

    private Collection<RaftServer> putNewServers(Iterable<RaftPeerId> peers, boolean format, RaftGroup raftGroup) {
        return StreamSupport.stream(peers.spliterator(), false).map(id -> this.putNewServer(id, raftGroup, format)).collect(Collectors.toList());
    }

    public void start() throws IOException {
        LOG.info(".............................................................. ");
        LOG.info("... ");
        LOG.info("...     Starting " + JavaUtils.getClassSimpleName(this.getClass()));
        LOG.info("... ");
        LOG.info(".............................................................. ");
        this.initServers();
        this.startServers(this.servers.values());
        this.timer.updateAndGet(t -> t != null ? t : JavaUtils.runRepeatedly(() -> LOG.info("TIMED-PRINT: " + this.printServers()), (long)10L, (long)10L, (TimeUnit)TimeUnit.SECONDS));
    }

    public RaftServer.Division restartServer(RaftPeerId serverId, boolean format) throws IOException {
        return this.restartServer(serverId, this.group, format);
    }

    public RaftServer.Division restartServer(RaftPeerId serverId, RaftGroup group, boolean format) throws IOException {
        this.killServer(serverId);
        this.servers.remove(serverId);
        RaftServerProxy proxy = this.putNewServer(serverId, group, format);
        proxy.start();
        return group == null ? null : proxy.getDivision(group.getGroupId());
    }

    public void restart(boolean format) throws IOException {
        this.shutdown();
        ArrayList idList = new ArrayList(this.servers.keySet());
        this.servers.clear();
        this.putNewServers(idList, format, this.group);
        this.start();
    }

    public TimeDuration getTimeoutMax() {
        return RaftServerConfigKeys.Rpc.timeoutMax((RaftProperties)this.properties);
    }

    private RaftServerProxy newRaftServer(RaftPeerId id, RaftGroup group, boolean format) {
        LOG.info("newRaftServer: {}, {}, format? {}", new Object[]{id, group, format});
        try {
            File dir = this.getStorageDir(id);
            if (format) {
                FileUtils.deleteFully((File)dir);
                LOG.info("Formatted directory {}", (Object)dir);
            }
            RaftProperties prop = new RaftProperties(this.properties);
            RaftServerConfigKeys.setStorageDir((RaftProperties)prop, Collections.singletonList(dir));
            return ServerImplUtils.newRaftServer((RaftPeerId)id, (RaftGroup)group, (RaftStorage.StartupOption)(format ? RaftStorage.StartupOption.FORMAT : RaftStorage.StartupOption.RECOVER), (StateMachine.Registry)this.getStateMachineRegistry(prop), null, (RaftProperties)prop, (Parameters)this.setPropertiesAndInitParameters(id, group, prop));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Parameters setPropertiesAndInitParameters(RaftPeerId var1, RaftGroup var2, RaftProperties var3);

    public void setStateMachineRegistry(StateMachine.Registry stateMachineRegistry) {
        this.stateMachineRegistry = stateMachineRegistry;
    }

    StateMachine.Registry getStateMachineRegistry(RaftProperties properties) {
        if (this.stateMachineRegistry != null) {
            return this.stateMachineRegistry;
        }
        Class smClass = properties.getClass(STATEMACHINE_CLASS_KEY, null, StateMachine.class);
        if (smClass == null) {
            return STATEMACHINE_REGISTRY_DEFAULT;
        }
        return gid -> {
            try {
                return (StateMachine)ReflectionUtils.newInstance((Class)smClass);
            }
            catch (RuntimeException e) {
                RuntimeException exception = e;
                try {
                    Class[] argClasses = new Class[]{RaftProperties.class};
                    return (StateMachine)ReflectionUtils.newInstance((Class)smClass, (Class[])argClasses, (Object[])new Object[]{properties});
                }
                catch (RuntimeException e2) {
                    exception.addSuppressed(e2);
                    throw exception;
                }
            }
        };
    }

    private static List<RaftPeer> toRaftPeers(Iterable<RaftServer> servers) {
        return StreamSupport.stream(servers.spliterator(), false).map(RaftServer::getPeer).collect(Collectors.toList());
    }

    public PeerChanges addNewPeers(int number, boolean startNewPeer) throws IOException {
        return this.addNewPeers(MiniRaftCluster.generateIds((int)number, (int)this.servers.size()), startNewPeer, false);
    }

    public PeerChanges addNewPeers(int number, boolean startNewPeer, boolean emptyPeer) throws IOException {
        return this.addNewPeers(MiniRaftCluster.generateIds((int)number, (int)this.servers.size()), startNewPeer, emptyPeer, RaftProtos.RaftPeerRole.FOLLOWER);
    }

    public PeerChanges addNewPeers(String[] ids, boolean startNewPeer, boolean emptyPeer) throws IOException {
        return this.addNewPeers(ids, startNewPeer, emptyPeer, RaftProtos.RaftPeerRole.FOLLOWER);
    }

    public PeerChanges addNewPeers(int number, boolean startNewPeer, boolean emptyPeer, RaftProtos.RaftPeerRole startRole) throws IOException {
        return this.addNewPeers(MiniRaftCluster.generateIds((int)number, (int)this.servers.size()), startNewPeer, emptyPeer, startRole);
    }

    public PeerChanges addNewPeers(String[] ids, boolean startNewPeer, boolean emptyPeer, RaftProtos.RaftPeerRole startRole) throws IOException {
        RaftGroup raftGroup;
        LOG.info("Add new peers {}", Arrays.asList(ids));
        Iterable peerIds = CollectionUtils.as(Arrays.asList(ids), RaftPeerId::valueOf);
        if (emptyPeer) {
            raftGroup = RaftGroup.valueOf((RaftGroupId)this.group.getGroupId(), Collections.emptyList());
        } else {
            Collection newPeers = StreamSupport.stream(peerIds.spliterator(), false).map(id -> RaftPeer.newBuilder().setId(id).setStartupRole(startRole)).map(MiniRaftCluster::assignAddresses).map(RaftPeer.Builder::build).collect(Collectors.toSet());
            newPeers.addAll(this.group.getPeers());
            raftGroup = RaftGroup.valueOf((RaftGroupId)this.group.getGroupId(), (Iterable)newPeers);
        }
        Collection newServers = this.putNewServers(peerIds, true, raftGroup);
        if (startNewPeer) {
            for (RaftServer s : newServers) {
                s.start();
            }
        }
        List newPeers = MiniRaftCluster.toRaftPeers((Iterable)newServers);
        RaftPeer[] np = newPeers.toArray(RaftPeer.emptyArray());
        newPeers.addAll(this.group.getPeers());
        RaftPeer[] p = newPeers.toArray(RaftPeer.emptyArray());
        this.group = RaftGroup.valueOf((RaftGroupId)this.group.getGroupId(), (RaftPeer[])p);
        return new PeerChanges(p, np, RaftPeer.emptyArray());
    }

    void startServers(Iterable<? extends RaftServer> servers) throws IOException {
        for (RaftServer raftServer : servers) {
            raftServer.start();
            this.peers.put(raftServer.getId(), raftServer.getPeer());
        }
    }

    public PeerChanges removePeers(int number, boolean removeLeader, Collection<RaftPeer> excluded) throws InterruptedException {
        ArrayList peers = new ArrayList(this.group.getPeers());
        ArrayList<RaftPeer> removedPeers = new ArrayList<RaftPeer>(number);
        if (removeLeader) {
            RaftPeer leader = RaftTestUtil.waitForLeader((MiniRaftCluster)this).getPeer();
            Preconditions.assertTrue((!excluded.contains(leader) ? 1 : 0) != 0);
            peers.remove(leader);
            removedPeers.add(leader);
        }
        List followers = this.getFollowers();
        int removed = 0;
        for (int i = 0; i < followers.size() && removed < (removeLeader ? number - 1 : number); ++i) {
            RaftPeer toRemove = ((RaftServer.Division)followers.get(i)).getPeer();
            if (excluded.contains(toRemove)) continue;
            peers.remove(toRemove);
            removedPeers.add(toRemove);
            ++removed;
        }
        RaftPeer[] p = peers.toArray(RaftPeer.emptyArray());
        this.group = RaftGroup.valueOf((RaftGroupId)this.group.getGroupId(), (RaftPeer[])p);
        return new PeerChanges(p, RaftPeer.emptyArray(), removedPeers.toArray(RaftPeer.emptyArray()));
    }

    public void killServer(RaftPeerId id) {
        LOG.info("killServer " + id);
        ((RaftServerProxy)this.servers.get(id)).close();
    }

    public String printServers() {
        return this.printServers(null);
    }

    public String printServers(RaftGroupId groupId) {
        StringBuilder b = new StringBuilder("printing ");
        if (groupId != null) {
            b.append(groupId);
        } else {
            b.append("ALL groups");
        }
        this.getRaftServerProxyStream(groupId).forEach(s -> b.append("\n  ").append(s));
        return b.toString();
    }

    public String printAllLogs() {
        StringBuilder b = new StringBuilder("\n#servers = " + this.servers.size() + "\n");
        for (RaftServer.Division s : this.iterateDivisions()) {
            b.append("  ");
            b.append(s).append("\n");
            RaftLog log = s.getRaftLog();
            if (!(log instanceof MemoryRaftLog)) continue;
            b.append("    ");
            b.append(((MemoryRaftLog)log).getEntryString());
        }
        return b.toString();
    }

    public RaftServer.Division getLeaderAndSendFirstMessage(boolean ignoreException) throws IOException {
        RaftServer.Division leader;
        block14: {
            leader = this.getLeader();
            try (RaftClient client = this.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("first msg to make leader ready"));
            }
            catch (IOException e) {
                if (ignoreException) break block14;
                throw e;
            }
        }
        return leader;
    }

    public IllegalStateException newIllegalStateExceptionForNoLeaders(RaftGroupId groupId) {
        String g = groupId == null ? "" : " for " + groupId;
        return new IllegalStateException("No leader yet " + g + ": " + this.printServers(groupId));
    }

    public IllegalStateException newIllegalStateExceptionForMultipleLeaders(RaftGroupId groupId, List<RaftServer.Division> leaders) {
        String g = groupId == null ? "" : " for " + groupId;
        return new IllegalStateException("Found multiple leaders" + g + " at the same term (=" + leaders.get(0).getInfo().getCurrentTerm() + "), leaders.size() = " + leaders.size() + " > 1, leaders = " + leaders + ": " + this.printServers(groupId));
    }

    public RaftServer.Division getLeader() {
        return MiniRaftCluster.getLeader((List)this.getLeaders(null), null, (T leaders) -> {
            throw this.newIllegalStateExceptionForMultipleLeaders(null, leaders);
        });
    }

    public RaftServer.Division getLeader(RaftGroupId groupId, Runnable handleNoLeaders, Consumer<List<RaftServer.Division>> handleMultipleLeaders) {
        return MiniRaftCluster.getLeader((List)this.getLeaders(groupId), (Runnable)handleNoLeaders, handleMultipleLeaders);
    }

    static RaftServer.Division getLeader(List<RaftServer.Division> leaders, Runnable handleNoLeaders, Consumer<List<RaftServer.Division>> handleMultipleLeaders) {
        if (leaders.isEmpty()) {
            if (handleNoLeaders != null) {
                handleNoLeaders.run();
            }
            return null;
        }
        if (leaders.size() > 1) {
            if (handleMultipleLeaders != null) {
                handleMultipleLeaders.accept(leaders);
            }
            return null;
        }
        return leaders.get(0);
    }

    private List<RaftServer.Division> getLeaders(RaftGroupId groupId) {
        Stream serverAliveStream = this.getServerAliveStream(groupId);
        ArrayList<RaftServer.Division> leaders = new ArrayList<RaftServer.Division>();
        serverAliveStream.filter(server -> server.getInfo().isLeader()).forEach(s -> {
            if (leaders.isEmpty()) {
                leaders.add((RaftServer.Division)s);
            } else {
                long leaderTerm = ((RaftServer.Division)leaders.get(0)).getInfo().getCurrentTerm();
                long term = s.getInfo().getCurrentTerm();
                if (term >= leaderTerm) {
                    if (term > leaderTerm) {
                        leaders.clear();
                    }
                    leaders.add((RaftServer.Division)s);
                }
            }
        });
        return leaders;
    }

    boolean isLeader(String leaderId) {
        RaftServer.Division leader = this.getLeader();
        return leader != null && leader.getId().toString().equals(leaderId);
    }

    public List<RaftServer.Division> getFollowers() {
        return this.getServerAliveStream().filter(server -> server.getInfo().isFollower()).collect(Collectors.toList());
    }

    public List<RaftServer.Division> getListeners() {
        return this.getServerAliveStream().filter(server -> server.getInfo().isListener()).collect(Collectors.toList());
    }

    public int getNumServers() {
        return this.servers.size();
    }

    public Iterable<RaftServer> getServers() {
        return CollectionUtils.as(this.servers.values(), s -> s);
    }

    private Stream<RaftServerProxy> getRaftServerProxyStream(RaftGroupId groupId) {
        return this.servers.values().stream().filter(s -> groupId == null || s.getGroupIds().contains(groupId));
    }

    public Iterable<RaftServer.Division> iterateDivisions() {
        return CollectionUtils.as((Iterable)this.getServers(), arg_0 -> this.getDivision(arg_0));
    }

    private Stream<RaftServer.Division> getServerStream(RaftGroupId groupId) {
        Stream stream = this.getRaftServerProxyStream(groupId);
        return groupId != null ? stream.map(s -> (RaftServer.Division)JavaUtils.callAsUnchecked(() -> s.getDivision(groupId))) : stream.flatMap(s -> ((List)JavaUtils.callAsUnchecked(() -> ((RaftServerProxy)s).getImpls())).stream());
    }

    public Stream<RaftServer.Division> getServerAliveStream() {
        return this.getServerAliveStream(this.getGroupId());
    }

    private Stream<RaftServer.Division> getServerAliveStream(RaftGroupId groupId) {
        return this.getServerStream(groupId).filter(server -> server.getInfo().isAlive());
    }

    private RetryPolicy getDefaultRetryPolicy() {
        return RetryPolicies.retryForeverWithSleep((TimeDuration)RETRY_INTERVAL_DEFAULT);
    }

    public RaftServerProxy getServer(RaftPeerId id) {
        return (RaftServerProxy)this.servers.get(id);
    }

    public ServerFactory getServerFactory(RaftPeerId id) {
        return ((RaftServerProxy)this.servers.get(id)).getFactory();
    }

    public RaftServer.Division getDivision(RaftPeerId id) {
        return this.getDivision((RaftServer)this.servers.get(id));
    }

    public RaftServer.Division getDivision(RaftPeerId id, RaftGroupId groupId) {
        return RaftServerTestUtil.getDivision((RaftServer)((RaftServer)this.servers.get(id)), (RaftGroupId)groupId);
    }

    public RaftServer.Division getDivision(RaftServer server) {
        return RaftServerTestUtil.getDivision((RaftServer)server, (RaftGroupId)this.getGroupId());
    }

    public List<RaftPeer> getPeers() {
        return MiniRaftCluster.toRaftPeers((Iterable)this.getServers());
    }

    RaftPeer getPeer(RaftPeerId id, RaftGroup group) {
        RaftPeer p = (RaftPeer)this.peers.get(id);
        if (p != null) {
            return p;
        }
        if (group != null) {
            p = group.getPeer(id);
        }
        if (p == null) {
            p = Optional.ofNullable(this.servers.get(id)).map(RaftServerProxy::getPeer).orElse(null);
        }
        if (p != null) {
            this.peers.put(id, p);
        }
        return p;
    }

    public RaftGroup getGroup() {
        return this.group;
    }

    public RaftClient createClient() {
        return this.createClient(null, this.group);
    }

    public RaftClient createClient(RaftGroup g) {
        return this.createClient(null, g);
    }

    public RaftClient createClient(RaftPeerId leaderId) {
        return this.createClient(leaderId, this.group);
    }

    public RaftClient createClient(RetryPolicy retryPolicy) {
        return this.createClient(null, this.group, retryPolicy);
    }

    public RaftClient createClient(RaftPeerId leaderId, RetryPolicy retryPolicy) {
        return this.createClient(leaderId, this.group, retryPolicy);
    }

    public RaftClient createClient(RaftPeerId leaderId, RaftGroup group) {
        return this.createClient(leaderId, group, this.getDefaultRetryPolicy());
    }

    public RaftClient createClient(RaftPeer primaryServer) {
        return this.createClient(null, this.group, this.getDefaultRetryPolicy(), primaryServer);
    }

    public RaftClient createClient(RaftPeerId leaderId, RaftGroup group, RetryPolicy retryPolicy) {
        return this.createClient(leaderId, group, retryPolicy, null);
    }

    public RaftClient createClient(RaftPeerId leaderId, RaftGroup group, RetryPolicy retryPolicy, RaftPeer primaryServer) {
        RaftClient.Builder builder = RaftClient.newBuilder().setRaftGroup(group).setLeaderId(leaderId).setProperties(this.properties).setParameters(this.parameters).setPrimaryDataStreamServer(primaryServer).setRetryPolicy(retryPolicy);
        return builder.build();
    }

    public RaftClientRequest newRaftClientRequest(ClientId clientId, RaftPeerId leaderId, Message message) {
        return this.newRaftClientRequest(clientId, leaderId, CallId.getDefault(), message);
    }

    public RaftClientRequest newRaftClientRequest(ClientId clientId, RaftPeerId leaderId, long callId, Message message) {
        return RaftClientRequest.newBuilder().setClientId(clientId).setLeaderId(leaderId).setGroupId(this.getGroupId()).setCallId(callId).setMessage(message).setType(RaftClientRequest.writeRequestType()).build();
    }

    public SetConfigurationRequest newSetConfigurationRequest(ClientId clientId, RaftPeerId leaderId, RaftPeer ... peers) {
        return new SetConfigurationRequest(clientId, leaderId, this.getGroupId(), CallId.getDefault(), SetConfigurationRequest.Arguments.newBuilder().setServersInNewConf(peers).build());
    }

    public void setConfiguration(RaftPeer ... peers) throws IOException {
        try (RaftClient client = this.createClient();){
            LOG.info("Start changing the configuration: {}", Arrays.asList(peers));
            RaftClientReply reply = client.admin().setConfiguration(peers);
            Preconditions.assertTrue((boolean)reply.isSuccess());
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        LOG.info("************************************************************** ");
        LOG.info("*** ");
        LOG.info("***     Stopping " + JavaUtils.getClassSimpleName(this.getClass()));
        LOG.info("*** ");
        LOG.info("************************************************************** ");
        LOG.info(this.printServers());
        ExitUtils.setTerminateOnUncaughtException((boolean)false);
        ExecutorService executor = Executors.newFixedThreadPool(this.servers.size(), t -> Daemon.newBuilder().setName("MiniRaftCluster-" + THREAD_COUNT.incrementAndGet()).setRunnable(t).build());
        this.getServers().forEach(proxy -> executor.submit(() -> JavaUtils.runAsUnchecked(() -> proxy.close())));
        try {
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("shutdown interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        Optional.ofNullable(this.timer.get()).ifPresent(Timer::cancel);
        ExitUtils.assertNotTerminated();
        LOG.info("{} shutdown completed", (Object)JavaUtils.getClassSimpleName(this.getClass()));
    }

    protected abstract void blockQueueAndSetDelay(String var1, int var2) throws InterruptedException;

    public boolean tryEnforceLeader(String leaderId) throws InterruptedException {
        if (this.isLeader(leaderId)) {
            return true;
        }
        this.blockQueueAndSetDelay(leaderId, RaftServerConfigKeys.Rpc.TIMEOUT_MIN_DEFAULT.toIntExact(TimeUnit.MILLISECONDS));
        this.blockQueueAndSetDelay(leaderId, 0);
        return this.isLeader(leaderId);
    }

    public abstract void setBlockRequestsFrom(String var1, boolean var2);

    public RaftGroupId getGroupId() {
        return this.group.getGroupId();
    }
}

