/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import java.util.SortedMap;
import org.apache.ratis.BaseTest;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLeaderElectionMetrics
extends BaseTest {
    private static LeaderElectionMetrics leaderElectionMetrics;
    private static RatisMetricRegistryImpl ratisMetricRegistry;

    @BeforeClass
    public static void setUp() {
        RaftGroupId raftGroupId = RaftGroupId.randomId();
        RaftPeerId raftPeerId = RaftPeerId.valueOf((String)"TestId");
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)raftPeerId, (RaftGroupId)raftGroupId);
        leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics((RaftGroupMemberId)raftGroupMemberId, () -> 1000L);
        ratisMetricRegistry = (RatisMetricRegistryImpl)leaderElectionMetrics.getRegistry();
    }

    @Test
    public void testOnLeaderElectionCompletion() throws Exception {
        leaderElectionMetrics.onNewLeaderElectionCompletion();
        SortedMap gauges = ratisMetricRegistry.getGauges((s, metric) -> s.contains("lastLeaderElectionElapsedTime"));
        this.LOG.info("{} gauges: {}", (Object)"lastLeaderElectionElapsedTime", (Object)gauges);
        Long leaderElectionLatency = (Long)((Gauge)gauges.values().iterator().next()).getValue();
        Assert.assertTrue((String)("leaderElectionLatency = " + leaderElectionLatency), (leaderElectionLatency >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testOnLeaderElectionTimeout() throws Exception {
        long numLeaderElectionTimeouts = ratisMetricRegistry.counter("timeoutCount").getCount();
        Assert.assertTrue((numLeaderElectionTimeouts == 0L ? 1 : 0) != 0);
        leaderElectionMetrics.onLeaderElectionTimeout();
        numLeaderElectionTimeouts = ratisMetricRegistry.counter("timeoutCount").getCount();
        Assert.assertEquals((long)1L, (long)numLeaderElectionTimeouts);
    }
}

