/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.util.List;
import org.apache.ratis.BaseTest;
import org.apache.ratis.InstallSnapshotFromLeaderTests;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.RaftRetryFailureException;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstallSnapshotFromLeaderTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final Logger LOG = LoggerFactory.getLogger(InstallSnapshotFromLeaderTests.class);
    private static final int SNAPSHOT_TRIGGER_THRESHOLD = 64;
    private static final int PURGE_GAP = 8;

    public InstallSnapshotFromLeaderTests() {
        RaftProperties prop = this.getProperties();
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)prop, (boolean)true);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)prop, (long)64L);
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)prop, (int)8);
        RaftServerConfigKeys.Log.Appender.setSnapshotChunkSizeMax((RaftProperties)prop, (SizeInBytes)SizeInBytes.ONE_KB);
        RaftServerConfigKeys.LeaderElection.setMemberMajorityAdd((RaftProperties)prop, (boolean)true);
    }

    public void testMultiFileInstallSnapshot() throws Exception {
        this.getProperties().setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachineWithMultiNestedSnapshotFile.class, StateMachine.class);
        this.runWithNewCluster(1, arg_0 -> this.testMultiFileInstallSnapshot(arg_0));
    }

    public void testSeparateSnapshotInstallPath() throws Exception {
        this.getProperties().setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachineWithSeparatedSnapshotPath.class, StateMachine.class);
        this.runWithNewCluster(1, arg_0 -> this.testMultiFileInstallSnapshot(arg_0));
    }

    public void testInstallSnapshotLeaderSwitch() throws Exception {
        this.getProperties().setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachineWithSeparatedSnapshotPath.class, StateMachine.class);
        this.runWithNewCluster(3, arg_0 -> this.testInstallSnapshotDuringLeaderSwitch(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMultiFileInstallSnapshot(CLUSTER cluster) throws Exception {
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            try (RaftClient client = cluster.createClient(leaderId);){
                for (int i = 0; i < 127; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assertions.assertTrue((boolean)reply.isSuccess());
                }
                client.getSnapshotManagementApi(leaderId).create(3000L);
            }
            SnapshotInfo snapshot = cluster.getLeader().getStateMachine().getLatestSnapshot();
            Assertions.assertEquals((int)3, (int)snapshot.getFiles().size());
            MiniRaftCluster.PeerChanges change = cluster.addNewPeers(2, true, true);
            cluster.setConfiguration(change.allPeersInNewConf);
            RaftServerTestUtil.waitAndCheckNewConf(cluster, (RaftPeer[])change.allPeersInNewConf, (int)0, null);
            JavaUtils.attempt(() -> {
                for (RaftServer.Division follower : cluster.getFollowers()) {
                    SnapshotInfo info = follower.getStateMachine().getLatestSnapshot();
                    Assertions.assertNotNull((Object)info);
                    Assertions.assertEquals((int)3, (int)info.getFiles().size());
                }
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"check snapshot", (Logger)LOG);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInstallSnapshotDuringLeaderSwitch(CLUSTER cluster) throws Exception {
        try {
            Object snapshotReply;
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = cluster.getLeader().getId();
            try (RaftClient client = cluster.createClient(leaderId);){
                for (int i = 0; i < 128; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assertions.assertTrue((boolean)reply.isSuccess());
                }
                for (RaftPeer peer : cluster.getPeers()) {
                    snapshotReply = client.getSnapshotManagementApi(leaderId).create(3000L);
                    Assertions.assertTrue((boolean)snapshotReply.isSuccess());
                }
            }
            SnapshotInfo snapshot = cluster.getLeader().getStateMachine().getLatestSnapshot();
            Assertions.assertNotNull((Object)snapshot);
            List oldFollowers = cluster.getFollowers();
            for (RaftServer.Division f : oldFollowers) {
                RaftTestUtil.isolate(cluster, (RaftPeerId)f.getId());
            }
            MiniRaftCluster.PeerChanges change = cluster.addNewPeers(2, true, true);
            RaftClient client = cluster.createClient(leaderId, RetryPolicies.noRetry());
            snapshotReply = null;
            try {
                Assertions.assertThrows(RaftRetryFailureException.class, () -> client.admin().setConfiguration(change.allPeersInNewConf));
            }
            catch (Throwable throwable) {
                snapshotReply = throwable;
                throw throwable;
            }
            finally {
                if (client != null) {
                    if (snapshotReply != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)snapshotReply).addSuppressed(throwable);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            SnapshotInfo snapshotInfo = cluster.getDivision(change.newPeers[0].getId()).getStateMachine().getLatestSnapshot();
            Assertions.assertNotNull((Object)snapshotInfo);
            RaftTestUtil.isolate(cluster, (RaftPeerId)leaderId);
            for (RaftServer.Division f : oldFollowers) {
                RaftTestUtil.deIsolate(cluster, (RaftPeerId)f.getId());
            }
            RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client2 = cluster.createClient(cluster.getLeader().getId());){
                RaftClientReply setConf = client2.admin().setConfiguration(change.allPeersInNewConf);
                Assertions.assertTrue((boolean)setConf.isSuccess());
                RaftTestUtil.deIsolate(cluster, (RaftPeerId)leaderId);
                RaftClientReply reply = client2.io().send((Message)new RaftTestUtil.SimpleMessage("final"));
                Assertions.assertTrue((boolean)reply.isSuccess());
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

