/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.impl.RetryCacheTestUtil;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class RetryCacheTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public static final int NUM_SERVERS = 3;

    @Test
    public void testBasicRetry() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestBasicRetry(arg_0));
    }

    void runTestBasicRetry(CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = cluster.getLeaderAndSendFirstMessage(false).getId();
        long oldLastApplied = cluster.getLeader().getInfo().getLastAppliedIndex();
        try (RaftClient client = cluster.createClient(leaderId);){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftClientRequest r = cluster.newRaftClientRequest(client.getId(), leaderId, 999L, (Message)new RaftTestUtil.SimpleMessage("message"));
            RetryCacheTests.assertReply((RaftClientReply)rpc.sendRequest(r), (RaftClient)client, (long)999L);
            for (int i = 0; i < 5; ++i) {
                RetryCacheTests.assertReply((RaftClientReply)rpc.sendRequest(r), (RaftClient)client, (long)999L);
            }
            this.assertServer(cluster, client.getId(), 999L, oldLastApplied);
        }
    }

    public static void assertReply(RaftClientReply reply, RaftClient client, long callId) {
        Assertions.assertEquals((Object)client.getId(), (Object)reply.getClientId());
        Assertions.assertEquals((long)callId, (long)reply.getCallId());
        Assertions.assertTrue((boolean)reply.isSuccess());
    }

    public void assertServer(MiniRaftCluster cluster, ClientId clientId, long callId, long oldLastApplied) throws Exception {
        long leaderApplied = cluster.getLeader().getInfo().getLastAppliedIndex();
        for (RaftServer.Division server : cluster.iterateDivisions()) {
            this.LOG.info("check server " + server.getId());
            if (server.getInfo().getLastAppliedIndex() < leaderApplied) {
                Thread.sleep(1000L);
            }
            Assertions.assertEquals((long)2L, (long)server.getRetryCache().getStatistics().size());
            Assertions.assertNotNull((Object)RetryCacheTestUtil.get((RaftServer.Division)server, (ClientId)clientId, (long)callId));
            Assertions.assertEquals((int)1, (int)RetryCacheTests.count((RaftLog)server.getRaftLog(), (long)(oldLastApplied + 1L)));
        }
    }

    static int count(RaftLog log, long startIndex) throws RaftLogIOException {
        long nextIndex = log.getNextIndex();
        int count = 0;
        for (long i = startIndex; i < nextIndex; ++i) {
            if (!log.get(i).hasStateMachineLogEntry()) continue;
            ++count;
        }
        return count;
    }

    @Test
    public void testRetryOnNewLeader() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestRetryOnNewLeader(arg_0));
    }

    void runTestRetryOnNewLeader(CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = cluster.getLeaderAndSendFirstMessage(false).getId();
        try (RaftClient client = cluster.createClient(leaderId);){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftClientRequest r = cluster.newRaftClientRequest(client.getId(), leaderId, 999L, (Message)new RaftTestUtil.SimpleMessage("message"));
            RetryCacheTests.assertReply((RaftClientReply)rpc.sendRequest(r), (RaftClient)client, (long)999L);
            long oldLastApplied = cluster.getLeader().getInfo().getLastAppliedIndex();
            MiniRaftCluster.PeerChanges change = cluster.addNewPeers(2, true);
            RaftPeer[] allPeers = cluster.removePeers((int)2, (boolean)true, Arrays.asList(change.newPeers)).allPeersInNewConf;
            RaftServerTestUtil.runWithMinorityPeers(cluster, Arrays.asList(allPeers), peers -> cluster.setConfiguration(peers.toArray(RaftPeer.emptyArray())));
            RaftPeerId newLeaderId = (RaftPeerId)JavaUtils.attemptRepeatedly(() -> {
                RaftPeerId id = RaftTestUtil.waitForLeader((MiniRaftCluster)cluster).getId();
                Assertions.assertNotEquals((Object)leaderId, (Object)id);
                return id;
            }, (int)10, (TimeDuration)TimeDuration.valueOf((long)100L, (TimeUnit)TimeUnit.MILLISECONDS), (String)("wait for a leader different than " + leaderId), (Logger)this.LOG);
            Assertions.assertNotEquals((Object)leaderId, (Object)newLeaderId);
            r = cluster.newRaftClientRequest(client.getId(), newLeaderId, 999L, (Message)new RaftTestUtil.SimpleMessage("message"));
            rpc.addRaftPeers(Arrays.asList(change.newPeers));
            for (int i = 0; i < 10; ++i) {
                try {
                    RetryCacheTests.assertReply((RaftClientReply)rpc.sendRequest(r), (RaftClient)client, (long)999L);
                    this.LOG.info("successfully sent out the retry request_" + i);
                }
                catch (Exception e) {
                    this.LOG.info("hit exception while retrying the same request: " + r, (Throwable)e);
                }
                Thread.sleep(100L);
            }
            Assertions.assertEquals((int)0, (int)RetryCacheTests.count((RaftLog)cluster.getLeader().getRaftLog(), (long)(oldLastApplied + 1L)));
        }
    }

    static {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
    }
}

