/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.JavaUtils;

public final class BlockRequestHandlingInjection
implements CodeInjectionForTesting.Code {
    private static final BlockRequestHandlingInjection INSTANCE = new BlockRequestHandlingInjection();
    private final Map<String, Boolean> requestors = new ConcurrentHashMap();
    private final Map<String, Boolean> repliers = new ConcurrentHashMap();

    public static BlockRequestHandlingInjection getInstance() {
        return INSTANCE;
    }

    private BlockRequestHandlingInjection() {
    }

    public void blockRequestor(String requestor) {
        LOG.info("Block requestor " + requestor);
        this.requestors.put(requestor, true);
    }

    public void unblockRequestor(String requestor) {
        LOG.info("UnBlock requestor " + requestor);
        this.requestors.remove(requestor);
    }

    public void blockReplier(String replier) {
        this.repliers.put(replier, true);
    }

    public void unblockReplier(String replier) {
        this.repliers.remove(replier);
    }

    public void unblockAll() {
        this.requestors.clear();
        this.repliers.clear();
    }

    public boolean execute(Object localId, Object remoteId, Object ... args) {
        if (!this.shouldBlock(localId, remoteId)) {
            return false;
        }
        LOG.info(localId + ": Block request from " + remoteId);
        try {
            RaftTestUtil.block(() -> this.shouldBlock(localId, remoteId));
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted while blocking request from " + remoteId + " to " + localId, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        LOG.info(localId + ": unBlock request from " + remoteId);
        return true;
    }

    private boolean shouldBlock(Object localId, Object remoteId) {
        return localId != null && this.repliers.containsKey(localId.toString()) || remoteId != null && this.requestors.containsKey(remoteId.toString());
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ": requestors=" + this.requestors.keySet() + ", repliers=" + this.repliers.keySet();
    }

    static {
        CodeInjectionForTesting.put((String)RaftServerImpl.REQUEST_VOTE, (CodeInjectionForTesting.Code)INSTANCE);
        CodeInjectionForTesting.put((String)RaftServerImpl.APPEND_ENTRIES, (CodeInjectionForTesting.Code)INSTANCE);
        CodeInjectionForTesting.put((String)RaftServerImpl.INSTALL_SNAPSHOT, (CodeInjectionForTesting.Code)INSTANCE);
        CodeInjectionForTesting.put((String)RaftServerImpl.START_LEADER_ELECTION, (CodeInjectionForTesting.Code)INSTANCE);
    }
}

