/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.junit.Assert;
import org.junit.Test;

public abstract class LogMetadataTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    @Test
    public void testLogMetadataEnabled() throws Exception {
        this.testLogMetadataBasicTest(true, x -> x > -1L);
    }

    @Test
    public void testLogMetadataDisabled() throws Exception {
        this.testLogMetadataBasicTest(false, x -> x == -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogMetadataBasicTest(boolean logMetadata, Predicate<Long> checker) throws Exception {
        RaftProperties prop = this.getProperties();
        RaftServerConfigKeys.Log.setLogMetadataEnabled((RaftProperties)prop, (boolean)logMetadata);
        MiniRaftCluster cluster = this.newCluster(3);
        try {
            cluster.start();
            RaftTestUtil.waitForLeader((MiniRaftCluster)cluster);
            RaftServer.Division leader = cluster.getLeader();
            RaftPeerId leaderId = leader.getId();
            cluster.getLeaderAndSendFirstMessage(true);
            for (RaftPeerId id : cluster.getGroup().getPeers().stream().map(RaftPeer::getId).filter(x -> !x.equals((Object)leaderId)).collect(Collectors.toList())) {
                cluster.killServer(id);
            }
            cluster.restartServer(leaderId, false);
            long commitIndex = cluster.getServer(leaderId).getDivision(cluster.getGroupId()).getRaftLog().getLastCommittedIndex();
            Assert.assertTrue((boolean)checker.test(commitIndex));
        }
        finally {
            cluster.shutdown();
        }
    }
}

