/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.ReadIndexHeartbeats;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.raftlog.RaftLogIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadIndexHeartbeats {
    private static final Logger LOG = LoggerFactory.getLogger(ReadIndexHeartbeats.class);
    private final AppendEntriesListeners appendEntriesListeners = new AppendEntriesListeners(this);
    private final RaftLogIndex ackedCommitIndex = new RaftLogIndex((Object)"ackedCommitIndex", -1L);

    ReadIndexHeartbeats() {
    }

    AppendEntriesListener addAppendEntriesListener(long commitIndex, Function<Long, AppendEntriesListener> constructor) {
        if (commitIndex <= this.ackedCommitIndex.get()) {
            return null;
        }
        LOG.debug("listen commitIndex {}", (Object)commitIndex);
        return this.appendEntriesListeners.add(commitIndex, constructor);
    }

    void onAppendEntriesReply(LogAppender appender, RaftProtos.AppendEntriesReplyProto reply, Predicate<Predicate<RaftPeerId>> hasMajority) {
        this.appendEntriesListeners.onAppendEntriesReply(appender, reply, hasMajority);
    }

    void failListeners(Exception e) {
        this.appendEntriesListeners.failAll(e);
    }

    static /* synthetic */ RaftLogIndex access$100(ReadIndexHeartbeats x0) {
        return x0.ackedCommitIndex;
    }

    static /* synthetic */ Logger access$200() {
        return LOG;
    }
}

