/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.ConfigurationManager;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ReadRequests;
import org.apache.ratis.server.impl.StateMachineUpdater;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.memory.MemoryRaftLog;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageImpl;
import org.apache.ratis.server.storage.RaftStorageMetadata;
import org.apache.ratis.server.storage.SnapshotManager;
import org.apache.ratis.server.storage.StorageImplUtils;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedCheckedSupplier;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;

/*
 * Exception performing whole class analysis ignored.
 */
class ServerState {
    private final RaftGroupMemberId memberId;
    private final RaftServerImpl server;
    private final MemoizedSupplier<RaftLog> log;
    private final ConfigurationManager configurationManager;
    private final MemoizedSupplier<StateMachineUpdater> stateMachineUpdater;
    private final MemoizedCheckedSupplier<RaftStorageImpl, IOException> raftStorage;
    private final SnapshotManager snapshotManager;
    private final AtomicReference<Timestamp> lastNoLeaderTime;
    private final TimeDuration noLeaderTimeout;
    private final ReadRequests readRequests;
    private final AtomicLong currentTerm = new AtomicLong();
    private final AtomicReference<RaftPeerId> leaderId = new AtomicReference();
    private volatile RaftPeerId votedFor;
    private final AtomicReference<TermIndex> latestInstalledSnapshot = new AtomicReference();

    ServerState(RaftPeerId id, RaftGroup group, StateMachine stateMachine, RaftServerImpl server, RaftStorage.StartupOption option, RaftProperties prop) {
        this.memberId = RaftGroupMemberId.valueOf((RaftPeerId)id, (RaftGroupId)group.getGroupId());
        this.server = server;
        Collection followerPeers = group.getPeers().stream().filter(peer -> peer.getStartupRole() == RaftProtos.RaftPeerRole.FOLLOWER).collect(Collectors.toList());
        Collection listenerPeers = group.getPeers().stream().filter(peer -> peer.getStartupRole() == RaftProtos.RaftPeerRole.LISTENER).collect(Collectors.toList());
        RaftConfigurationImpl initialConf = RaftConfigurationImpl.newBuilder().setConf((Iterable)followerPeers, (Iterable)listenerPeers).build();
        this.configurationManager = new ConfigurationManager(id, initialConf);
        RaftServer.Division.LOG.info("{}: {}", (Object)this.getMemberId(), (Object)this.configurationManager);
        String storageDirName = group.getGroupId().getUuid().toString();
        this.raftStorage = MemoizedCheckedSupplier.valueOf(() -> StorageImplUtils.initRaftStorage((String)storageDirName, (RaftStorage.StartupOption)option, (RaftProperties)prop));
        this.snapshotManager = StorageImplUtils.newSnapshotManager((RaftPeerId)id, () -> this.getStorage().getStorageDir(), (StateMachineStorage)stateMachine.getStateMachineStorage());
        this.lastNoLeaderTime = new AtomicReference<Timestamp>(Timestamp.currentTime());
        this.noLeaderTimeout = RaftServerConfigKeys.Notification.noLeaderTimeout((RaftProperties)prop);
        LongSupplier getSnapshotIndexFromStateMachine = () -> Optional.ofNullable(stateMachine.getLatestSnapshot()).map(SnapshotInfo::getIndex).filter(i -> i >= 0L).orElse(-1L);
        this.log = JavaUtils.memoize(() -> this.initRaftLog(getSnapshotIndexFromStateMachine, prop));
        this.readRequests = new ReadRequests(prop, stateMachine);
        this.stateMachineUpdater = JavaUtils.memoize(() -> new StateMachineUpdater(stateMachine, server, this, this.getLog().getSnapshotIndex(), prop, this.readRequests.getAppliedIndexConsumer()));
    }

    void initialize(StateMachine stateMachine) throws IOException {
        RaftStorageImpl storage = (RaftStorageImpl)this.raftStorage.get();
        Optional.ofNullable(storage.readRaftConfiguration()).ifPresent(arg_0 -> this.setRaftConf(arg_0));
        stateMachine.initialize((RaftServer)this.server.getRaftServer(), this.getMemberId().getGroupId(), (RaftStorage)storage);
        RaftStorageMetadata metadata = ((RaftLog)this.log.get()).loadMetadata();
        this.currentTerm.set(metadata.getTerm());
        this.votedFor = metadata.getVotedFor();
    }

    RaftGroupMemberId getMemberId() {
        return this.memberId;
    }

    void writeRaftConfiguration(RaftProtos.LogEntryProto conf) {
        this.getStorage().writeRaftConfiguration(conf);
    }

    void start() {
        ((StateMachineUpdater)this.stateMachineUpdater.get()).start();
    }

    private RaftLog initRaftLog(LongSupplier getSnapshotIndexFromStateMachine, RaftProperties prop) {
        try {
            return ServerState.initRaftLog((RaftGroupMemberId)this.getMemberId(), (RaftServerImpl)this.server, (RaftStorage)this.getStorage(), arg_0 -> this.setRaftConf(arg_0), (LongSupplier)getSnapshotIndexFromStateMachine, (RaftProperties)prop);
        }
        catch (IOException e) {
            throw new IllegalStateException(this.getMemberId() + ": Failed to initRaftLog.", e);
        }
    }

    private static RaftLog initRaftLog(RaftGroupMemberId memberId, RaftServerImpl server, RaftStorage storage, Consumer<RaftProtos.LogEntryProto> logConsumer, LongSupplier getSnapshotIndexFromStateMachine, RaftProperties prop) throws IOException {
        Object log = RaftServerConfigKeys.Log.useMemory((RaftProperties)prop) ? new MemoryRaftLog(memberId, getSnapshotIndexFromStateMachine, prop) : SegmentedRaftLog.newBuilder().setMemberId(memberId).setServer((RaftServer.Division)server).setNotifyTruncatedLogEntry(arg_0 -> ((RaftServerImpl)server).notifyTruncatedLogEntry(arg_0)).setGetTransactionContext((arg_0, arg_1) -> ((RaftServerImpl)server).getTransactionContext(arg_0, arg_1)).setSubmitUpdateCommitEvent(() -> ((RaftServerImpl)server).submitUpdateCommitEvent()).setStorage(storage).setSnapshotIndexSupplier(getSnapshotIndexFromStateMachine).setProperties(prop).build();
        log.open(log.getSnapshotIndex(), logConsumer);
        return log;
    }

    RaftConfigurationImpl getRaftConf() {
        return this.configurationManager.getCurrent();
    }

    RaftPeer getCurrentPeer() {
        return this.configurationManager.getCurrentPeer();
    }

    long getCurrentTerm() {
        return this.currentTerm.get();
    }

    boolean updateCurrentTerm(long newTerm) {
        long current = this.currentTerm.getAndUpdate(curTerm -> Math.max(curTerm, newTerm));
        if (newTerm > current) {
            this.votedFor = null;
            this.setLeader(null, (Object)"updateCurrentTerm");
            return true;
        }
        return false;
    }

    RaftPeerId getLeaderId() {
        return (RaftPeerId)this.leaderId.get();
    }

    LeaderElection.ConfAndTerm initElection(LeaderElection.Phase phase) throws IOException {
        long term;
        this.setLeader(null, (Object)phase);
        if (phase == LeaderElection.Phase.PRE_VOTE) {
            term = this.getCurrentTerm();
        } else if (phase == LeaderElection.Phase.ELECTION) {
            term = this.currentTerm.incrementAndGet();
            this.votedFor = this.getMemberId().getPeerId();
            this.persistMetadata();
        } else {
            throw new IllegalArgumentException("Unexpected phase " + phase);
        }
        return new LeaderElection.ConfAndTerm(this.getRaftConf(), term);
    }

    void persistMetadata() throws IOException {
        this.getLog().persistMetadata(RaftStorageMetadata.valueOf((long)this.currentTerm.get(), (RaftPeerId)this.votedFor));
    }

    RaftPeerId getVotedFor() {
        return this.votedFor;
    }

    void grantVote(RaftPeerId candidateId) {
        this.votedFor = candidateId;
        this.setLeader(null, (Object)"grantVote");
    }

    void setLeader(RaftPeerId newLeaderId, Object op) {
        RaftPeerId oldLeaderId = this.leaderId.getAndSet(newLeaderId);
        if (!Objects.equals(oldLeaderId, newLeaderId)) {
            String suffix;
            if (newLeaderId == null) {
                this.lastNoLeaderTime.set(Timestamp.currentTime());
                suffix = "";
            } else {
                Timestamp previous = this.lastNoLeaderTime.getAndSet(null);
                suffix = ", leader elected after " + previous.elapsedTimeMs() + "ms";
                this.server.setFirstElection(op);
                this.server.getStateMachine().event().notifyLeaderChanged(this.getMemberId(), newLeaderId);
            }
            RaftServer.Division.LOG.info("{}: change Leader from {} to {} at term {} for {}{}", new Object[]{this.getMemberId(), oldLeaderId, newLeaderId, this.getCurrentTerm(), op, suffix});
            if (newLeaderId != null) {
                this.server.onGroupLeaderElected();
            }
        }
    }

    boolean shouldNotifyExtendedNoLeader() {
        return Optional.ofNullable(this.lastNoLeaderTime.get()).map(Timestamp::elapsedTime).filter(t -> t.compareTo(this.noLeaderTimeout) > 0).isPresent();
    }

    long getLastLeaderElapsedTimeMs() {
        return Optional.ofNullable(this.lastNoLeaderTime.get()).map(Timestamp::elapsedTimeMs).orElse(0L);
    }

    void becomeLeader() {
        this.setLeader(this.getMemberId().getPeerId(), (Object)"becomeLeader");
    }

    StateMachineUpdater getStateMachineUpdater() {
        if (!this.stateMachineUpdater.isInitialized()) {
            throw new IllegalStateException(this.getMemberId() + ": stateMachineUpdater is uninitialized.");
        }
        return (StateMachineUpdater)this.stateMachineUpdater.get();
    }

    RaftLog getLog() {
        if (!this.log.isInitialized()) {
            throw new IllegalStateException(this.getMemberId() + ": log is uninitialized.");
        }
        return (RaftLog)this.log.get();
    }

    TermIndex getLastEntry() {
        SnapshotInfo snapshot;
        TermIndex lastEntry = this.getLog().getLastEntryTermIndex();
        if (lastEntry == null && (snapshot = this.getLatestSnapshot()) != null) {
            lastEntry = snapshot.getTermIndex();
        }
        return lastEntry;
    }

    void appendLog(TransactionContext operation) throws StateMachineException {
        this.getLog().append(this.currentTerm.get(), operation);
        Objects.requireNonNull(operation.getLogEntry());
    }

    boolean recognizeLeader(Object op, RaftPeerId peerId, long peerTerm) {
        long current = this.currentTerm.get();
        if (peerTerm < current) {
            RaftServer.Division.LOG.warn("{}: Failed to recognize {} as leader for {} since peerTerm = {} < currentTerm = {}", new Object[]{this.getMemberId(), peerId, op, peerTerm, current});
            return false;
        }
        RaftPeerId curLeaderId = this.getLeaderId();
        if (peerTerm == current && curLeaderId != null && !curLeaderId.equals((Object)peerId)) {
            RaftServer.Division.LOG.warn("{}: Failed to recognize {} as leader for {} since current leader is {} (peerTerm = currentTerm = {})", new Object[]{this.getMemberId(), peerId, op, curLeaderId, current});
            return false;
        }
        return true;
    }

    static int compareLog(TermIndex lastEntry, TermIndex candidateLastEntry) {
        if (lastEntry == null) {
            if (candidateLastEntry == null || candidateLastEntry.getTerm() == 0L && candidateLastEntry.getIndex() == 0L) {
                return 0;
            }
            return -1;
        }
        if (candidateLastEntry == null) {
            return 1;
        }
        return lastEntry.compareTo(candidateLastEntry);
    }

    public String toString() {
        return this.getMemberId() + ":t" + this.currentTerm + ", leader=" + this.getLeaderId() + ", voted=" + this.votedFor + ", raftlog=" + this.log + ", conf=" + this.getRaftConf();
    }

    boolean isConfCommitted() {
        return this.getLog().getLastCommittedIndex() >= this.getRaftConf().getLogEntryIndex();
    }

    void setRaftConf(RaftProtos.LogEntryProto entry) {
        if (entry.hasConfigurationEntry()) {
            this.setRaftConf(LogProtoUtils.toRaftConfiguration((RaftProtos.LogEntryProto)entry));
        }
    }

    void setRaftConf(RaftConfiguration conf) {
        this.configurationManager.addConfiguration(conf);
        this.server.getServerRpc().addRaftPeers(conf.getAllPeers());
        Collection listeners = conf.getAllPeers(RaftProtos.RaftPeerRole.LISTENER);
        if (!listeners.isEmpty()) {
            this.server.getServerRpc().addRaftPeers(listeners);
        }
        RaftServer.Division.LOG.info("{}: set configuration {}", (Object)this.getMemberId(), (Object)conf);
        RaftServer.Division.LOG.trace("{}: {}", (Object)this.getMemberId(), (Object)this.configurationManager);
    }

    void truncate(long logIndex) {
        this.configurationManager.removeConfigurations(logIndex);
    }

    void updateConfiguration(List<RaftProtos.LogEntryProto> entries) {
        if (entries != null && !entries.isEmpty()) {
            this.configurationManager.removeConfigurations(entries.get(0).getIndex());
            entries.forEach(arg_0 -> this.setRaftConf(arg_0));
        }
    }

    boolean updateCommitIndex(long majorityIndex, long curTerm, boolean isLeader) {
        if (this.getLog().updateCommitIndex(majorityIndex, curTerm, isLeader)) {
            this.getStateMachineUpdater().notifyUpdater();
            return true;
        }
        return false;
    }

    void notifyStateMachineUpdater() {
        this.getStateMachineUpdater().notifyUpdater();
    }

    void reloadStateMachine(TermIndex snapshotTermIndex) {
        this.getStateMachineUpdater().reloadStateMachine();
        this.getLog().onSnapshotInstalled(snapshotTermIndex.getIndex());
        this.latestInstalledSnapshot.set(snapshotTermIndex);
    }

    void close() {
        try {
            if (this.stateMachineUpdater.isInitialized()) {
                this.getStateMachineUpdater().stopAndJoin();
            }
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            RaftServer.Division.LOG.warn(this.getMemberId() + ": Failed to join " + this.getStateMachineUpdater(), e);
        }
        try {
            if (this.log.isInitialized()) {
                this.getLog().close();
            }
        }
        catch (Throwable e) {
            RaftServer.Division.LOG.warn(this.getMemberId() + ": Failed to close raft log " + this.getLog(), e);
        }
        try {
            if (this.raftStorage.isInitialized()) {
                this.getStorage().close();
            }
        }
        catch (Throwable e) {
            RaftServer.Division.LOG.warn(this.getMemberId() + ": Failed to close raft storage " + this.getStorage(), e);
        }
    }

    RaftStorageImpl getStorage() {
        if (!this.raftStorage.isInitialized()) {
            throw new IllegalStateException(this.getMemberId() + ": raftStorage is uninitialized.");
        }
        return (RaftStorageImpl)this.raftStorage.getUnchecked();
    }

    void installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        StateMachine sm = this.server.getStateMachine();
        sm.pause();
        this.snapshotManager.installSnapshot(request, sm);
    }

    private SnapshotInfo getLatestSnapshot() {
        return this.server.getStateMachine().getLatestSnapshot();
    }

    long getLatestInstalledSnapshotIndex() {
        TermIndex ti = (TermIndex)this.latestInstalledSnapshot.get();
        return ti != null ? ti.getIndex() : -1L;
    }

    long getSnapshotIndex() {
        SnapshotInfo s = this.getLatestSnapshot();
        long latestSnapshotIndex = s != null ? s.getIndex() : -1L;
        return Math.max(latestSnapshotIndex, this.getLatestInstalledSnapshotIndex());
    }

    long getNextIndex() {
        long logNextIndex = this.getLog().getNextIndex();
        long snapshotNextIndex = this.getLog().getSnapshotIndex() + 1L;
        return Math.max(logNextIndex, snapshotNextIndex);
    }

    long getLastAppliedIndex() {
        return this.getStateMachineUpdater().getStateMachineLastAppliedIndex();
    }

    boolean containsTermIndex(TermIndex ti) {
        Objects.requireNonNull(ti, "ti == null");
        if (Optional.ofNullable(this.latestInstalledSnapshot.get()).filter(ti::equals).isPresent()) {
            return true;
        }
        if (Optional.ofNullable(this.getLatestSnapshot()).map(SnapshotInfo::getTermIndex).filter(ti::equals).isPresent()) {
            return true;
        }
        return this.getLog().contains(ti);
    }

    ReadRequests getReadRequests() {
        return this.readRequests;
    }
}

