/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.TestLogAppenderMetrics;
import org.apache.ratis.server.metrics.LogAppenderMetrics;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestLogAppenderMetrics {
    private RatisMetricRegistryImpl ratisMetricRegistry;
    private RaftPeerId raftPeerId;
    private MyFollowerInfo followerInfo;

    @BeforeEach
    public void setup() {
        RaftGroupId raftGroupId = RaftGroupId.randomId();
        this.raftPeerId = RaftPeerId.valueOf((String)"TestId");
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)this.raftPeerId, (RaftGroupId)raftGroupId);
        this.followerInfo = new MyFollowerInfo(100L);
        LogAppenderMetrics logAppenderMetrics = new LogAppenderMetrics(raftGroupMemberId);
        this.ratisMetricRegistry = (RatisMetricRegistryImpl)logAppenderMetrics.getRegistry();
        logAppenderMetrics.addFollowerGauges(this.raftPeerId, () -> ((MyFollowerInfo)this.followerInfo).getNextIndex(), () -> ((MyFollowerInfo)this.followerInfo).getMatchIndex(), () -> ((MyFollowerInfo)this.followerInfo).getLastRpcTime());
    }

    @Test
    public void testLogAppenderGauges() {
        Gauge nextIndex = (Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains(String.format("follower_%s_next_index", this.raftPeerId.toString()))).values().iterator().next();
        Assertions.assertEquals((Object)100L, (Object)nextIndex.getValue());
        Gauge matchIndex = (Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains(String.format("follower_%s_match_index", this.raftPeerId.toString()))).values().iterator().next();
        Assertions.assertEquals((Object)0L, (Object)matchIndex.getValue());
        Gauge rpcTime = (Gauge)this.ratisMetricRegistry.getGauges((s, metric) -> s.contains(String.format("follower_%s_rpc_response_time", this.raftPeerId.toString()))).values().iterator().next();
        Assertions.assertTrue(((Long)rpcTime.getValue() > 0L ? 1 : 0) != 0);
        this.followerInfo.updateNextIndex(200L);
        this.followerInfo.updateMatchIndex(100L);
        this.followerInfo.updateLastRpcResponseTime();
        Assertions.assertEquals((Object)200L, (Object)nextIndex.getValue());
        Assertions.assertEquals((Object)100L, (Object)matchIndex.getValue());
        Assertions.assertNotNull((Object)rpcTime.getValue());
    }
}

