/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.impl.VoteContext;
import org.apache.ratis.server.protocol.TermIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VoteContext {
    static final Logger LOG = LoggerFactory.getLogger(VoteContext.class);
    private final RaftServerImpl impl;
    private final RaftConfigurationImpl conf;
    private final LeaderElection.Phase phase;
    private final RaftPeerId candidateId;

    VoteContext(RaftServerImpl impl, LeaderElection.Phase phase, RaftPeerId candidateId) {
        this.impl = impl;
        this.conf = impl.getRaftConf();
        this.phase = phase;
        this.candidateId = candidateId;
    }

    private boolean reject(String reason) {
        return this.log(false, reason);
    }

    private boolean log(boolean accept, String reason) {
        LOG.info("{}-{}: {} {} from {}: {}", new Object[]{this.impl.getMemberId(), this.impl.getInfo().getCurrentRole(), accept ? "accept" : "reject", this.phase, this.candidateId, reason});
        return accept;
    }

    private RaftPeer checkConf() {
        if (!this.conf.containsInConf(this.candidateId, new RaftProtos.RaftPeerRole[0])) {
            this.reject(this.candidateId + " is not in current conf " + this.conf.getCurrentPeers());
            return null;
        }
        return this.conf.getPeer(this.candidateId, new RaftProtos.RaftPeerRole[0]);
    }

    private CheckTermResult checkTerm(long candidateTerm) {
        if (this.phase == LeaderElection.Phase.PRE_VOTE) {
            return CheckTermResult.CHECK_LEADER;
        }
        ServerState state = this.impl.getState();
        long currentTerm = state.getCurrentTerm();
        if (currentTerm > candidateTerm) {
            this.reject("current term " + currentTerm + " > candidate's term " + candidateTerm);
            return CheckTermResult.FAILED;
        }
        if (currentTerm == candidateTerm) {
            RaftPeerId votedFor = state.getVotedFor();
            if (votedFor != null && !votedFor.equals((Object)this.candidateId)) {
                this.reject("already has voted for " + votedFor + " at current term " + currentTerm);
                return CheckTermResult.FAILED;
            }
            return CheckTermResult.CHECK_LEADER;
        }
        return CheckTermResult.SKIP_CHECK_LEADER;
    }

    private boolean checkLeader() {
        RaftPeerId leader;
        DivisionInfo info = this.impl.getInfo();
        if (info.isLeader() && this.impl.getRole().getLeaderState().map(LeaderStateImpl::checkLeadership).orElse(false).booleanValue()) {
            return this.reject("this server is the leader and still has leadership");
        }
        if (info.isFollower() && (leader = this.impl.getState().getLeaderId()) != null && !leader.equals((Object)this.candidateId) && this.impl.getRole().getFollowerState().map(FollowerState::isCurrentLeaderValid).orElse(false).booleanValue()) {
            return this.reject("this server is a follower and still has a valid leader " + leader + " different than the candidate " + this.candidateId);
        }
        return true;
    }

    RaftPeer recognizeCandidate(long candidateTerm) {
        RaftPeer candidate = this.checkConf();
        if (candidate == null) {
            return null;
        }
        CheckTermResult r = this.checkTerm(candidateTerm);
        if (r == CheckTermResult.FAILED) {
            return null;
        }
        if (r == CheckTermResult.CHECK_LEADER && !this.checkLeader()) {
            return null;
        }
        return candidate;
    }

    boolean decideVote(RaftPeer candidate, TermIndex candidateLastEntry) {
        if (this.impl.getRole().getCurrentRole() == RaftProtos.RaftPeerRole.LISTENER) {
            return this.reject("this server is a listener, who is a non-voting member");
        }
        if (candidate == null) {
            return false;
        }
        TermIndex lastEntry = this.impl.getState().getLastEntry();
        int compare = ServerState.compareLog((TermIndex)lastEntry, (TermIndex)candidateLastEntry);
        if (compare < 0) {
            return this.log(true, "our last entry " + lastEntry + " < candidate's last entry " + candidateLastEntry);
        }
        if (compare > 0) {
            return this.reject("our last entry " + lastEntry + " > candidate's last entry " + candidateLastEntry);
        }
        RaftPeer peer = this.conf.getPeer(this.impl.getId(), new RaftProtos.RaftPeerRole[0]);
        if (peer == null) {
            return this.reject("our server " + this.impl.getId() + " is not in the conf " + this.conf);
        }
        int priority = peer.getPriority();
        if (priority <= candidate.getPriority()) {
            return this.log(true, "our priority " + priority + " <= candidate's priority " + candidate.getPriority());
        }
        return this.reject("our priority " + priority + " > candidate's priority " + candidate.getPriority());
    }
}

