/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.leader.InstallSnapshotRequests;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.util.JavaUtils;

class InstallSnapshotRequests
implements Iterable<RaftProtos.InstallSnapshotRequestProto> {
    private final RaftServer.Division server;
    private final RaftPeerId followerId;
    private final Function<FileInfo, Path> getRelativePath;
    private final SnapshotInfo snapshot;
    private final String requestId;
    private final int snapshotChunkMaxSize;
    private final long totalSize;
    private final int numFiles;

    InstallSnapshotRequests(RaftServer.Division server, RaftPeerId followerId, String requestId, SnapshotInfo snapshot, int snapshotChunkMaxSize) {
        Function<Path, Path> relativize;
        this.server = server;
        this.followerId = followerId;
        this.requestId = requestId;
        this.snapshot = snapshot;
        this.snapshotChunkMaxSize = snapshotChunkMaxSize;
        List files = snapshot.getFiles();
        this.totalSize = files.stream().mapToLong(FileInfo::getFileSize).reduce(Long::sum).orElseThrow(() -> new IllegalStateException("Failed to compute total size for snapshot " + snapshot));
        this.numFiles = files.size();
        File snapshotDir = server.getStateMachine().getStateMachineStorage().getSnapshotDir();
        if (snapshotDir != null) {
            Path dir = snapshotDir.toPath();
            relativize = p -> new File("sm", dir.relativize((Path)p).toString()).toPath();
        } else {
            Path dir = server.getRaftStorage().getStorageDir().getRoot().toPath();
            relativize = dir::relativize;
        }
        this.getRelativePath = info -> Optional.of(info.getPath()).filter(Path::isAbsolute).map(relativize).orElseGet(() -> ((FileInfo)info).getPath());
    }

    @Override
    public Iterator<RaftProtos.InstallSnapshotRequestProto> iterator() {
        return new Iter(this, null);
    }

    public String toString() {
        return this.server.getId() + "->" + this.followerId + JavaUtils.getClassSimpleName(this.getClass()) + ": requestId=" + this.requestId + ", snapshot=" + this.snapshot;
    }

    static /* synthetic */ int access$100(InstallSnapshotRequests x0) {
        return x0.numFiles;
    }

    static /* synthetic */ SnapshotInfo access$200(InstallSnapshotRequests x0) {
        return x0.snapshot;
    }

    static /* synthetic */ Function access$300(InstallSnapshotRequests x0) {
        return x0.getRelativePath;
    }

    static /* synthetic */ int access$400(InstallSnapshotRequests x0) {
        return x0.snapshotChunkMaxSize;
    }

    static /* synthetic */ RaftServer.Division access$500(InstallSnapshotRequests x0) {
        return x0.server;
    }

    static /* synthetic */ String access$600(InstallSnapshotRequests x0) {
        return x0.requestId;
    }

    static /* synthetic */ long access$700(InstallSnapshotRequests x0) {
        return x0.totalSize;
    }

    static /* synthetic */ RaftPeerId access$800(InstallSnapshotRequests x0) {
        return x0.followerId;
    }
}

