/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.raftlog.segmented.BufferedWriteChannel;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogFormat;
import org.apache.ratis.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.PureJavaCrc32C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SegmentedRaftLogOutputStream
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentedRaftLogOutputStream.class);
    private static final ByteBuffer FILL;
    private static final int BUFFER_SIZE = 0x100000;
    private final String name;
    private final BufferedWriteChannel out;
    private final PureJavaCrc32C checksum = new PureJavaCrc32C();
    private final long segmentMaxSize;
    private final long preallocatedSize;

    public SegmentedRaftLogOutputStream(File file, boolean append, long segmentMaxSize, long preallocatedSize, ByteBuffer byteBuffer) throws IOException {
        this.name = JavaUtils.getClassSimpleName(this.getClass()) + "(" + file.getName() + ")";
        this.segmentMaxSize = segmentMaxSize;
        this.preallocatedSize = preallocatedSize;
        this.out = BufferedWriteChannel.open((File)file, (boolean)append, (ByteBuffer)byteBuffer);
        if (!append) {
            this.preallocateIfNecessary(SegmentedRaftLogFormat.getHeaderLength());
            this.out.writeToChannel(SegmentedRaftLogFormat.getHeaderBytebuffer());
            this.out.flush();
        }
    }

    public void write(RaftProtos.LogEntryProto entry) throws IOException {
        int serialized = entry.getSerializedSize();
        int proto = CodedOutputStream.computeUInt32SizeNoTag((int)serialized) + serialized;
        int total = proto + 4;
        this.preallocateIfNecessary(total);
        this.out.writeToBuffer(total, buf -> {
            int pos = buf.position();
            int protoEndPos = pos + proto;
            CodedOutputStream encoder = CodedOutputStream.newInstance((ByteBuffer)buf);
            encoder.writeUInt32NoTag(serialized);
            entry.writeTo(encoder);
            ByteBuffer duplicated = buf.duplicate();
            duplicated.position(pos).limit(protoEndPos);
            this.checksum.reset();
            this.checksum.update(duplicated);
            buf.position(protoEndPos);
            buf.putInt((int)this.checksum.getValue());
            Preconditions.assertSame((int)(pos + total), (int)buf.position(), (String)"buf.position()");
        });
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Logger)LOG, (Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
        IOUtils.cleanup((Logger)LOG, (Closeable[])new Closeable[]{this.out});
    }

    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException ioe) {
            String msg = "Failed to flush " + this;
            LOG.error(msg, (Throwable)ioe);
            throw new IOException(msg, ioe);
        }
    }

    CompletableFuture<Void> asyncFlush(ExecutorService executor) throws IOException {
        try {
            return this.out.asyncFlush(executor);
        }
        catch (IOException ioe) {
            String msg = "Failed to asyncFlush " + this;
            LOG.error(msg, (Throwable)ioe);
            throw new IOException(msg, ioe);
        }
    }

    private static long actualPreallocateSize(long outstandingData, long remainingSpace, long preallocate) {
        return outstandingData > remainingSpace ? outstandingData : (outstandingData > preallocate ? outstandingData : Math.min(preallocate, remainingSpace));
    }

    private long preallocate(FileChannel fc, long outstanding) throws IOException {
        long size = fc.size();
        long actual = SegmentedRaftLogOutputStream.actualPreallocateSize((long)outstanding, (long)(this.segmentMaxSize - size), (long)this.preallocatedSize);
        Preconditions.assertTrue((actual >= outstanding ? 1 : 0) != 0);
        long pos = fc.position();
        LOG.debug("Preallocate {} bytes (pos={}, size={}) for {}", new Object[]{actual, pos, size, this});
        long allocated = IOUtils.preallocate((FileChannel)fc, (long)actual, (ByteBuffer)FILL);
        Preconditions.assertSame((long)pos, (long)fc.position(), (String)"fc.position()");
        Preconditions.assertSame((long)actual, (long)allocated, (String)"allocated");
        Preconditions.assertSame((long)(size + allocated), (long)fc.size(), (String)"fc.size()");
        return allocated;
    }

    private void preallocateIfNecessary(int size) throws IOException {
        this.out.preallocateIfNecessary((long)size, (arg_0, arg_1) -> this.preallocate(arg_0, arg_1));
    }

    public String toString() {
        return this.name;
    }

    static {
        ByteBuffer buffer = ByteBuffer.allocateDirect(0x100000);
        for (int i = 0; i < 0x100000; ++i) {
            buffer.put(SegmentedRaftLogFormat.getTerminator());
        }
        buffer.flip();
        FILL = buffer.asReadOnlyBuffer();
    }
}

