/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.File;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogInputStream;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogWorker;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.Slf4jUtils;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public interface SegmentedRaftLogTestUtils {
    public static final SizeInBytes MAX_OP_SIZE = SizeInBytes.valueOf((String)"32MB");

    public static SegmentedRaftLogInputStream newSegmentedRaftLogInputStream(File log, long startIndex, long endIndex, boolean isOpen) {
        return new SegmentedRaftLogInputStream(log, startIndex, endIndex, isOpen, MAX_OP_SIZE, null);
    }

    public static void setRaftLogWorkerLogLevel(Level level) {
        Slf4jUtils.setLogLevel((Logger)SegmentedRaftLogWorker.LOG, (Level)level);
    }

    public static String getLogFlushTimeMetric(String memberId) {
        return SegmentedRaftLogWorker.class.getName() + "." + memberId + ".flush-time";
    }
}

