/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.storage;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.server.storage.RaftStorageImpl;
import org.apache.ratis.server.storage.SnapshotManager;
import org.apache.ratis.server.storage.StorageImplUtils;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.util.SizeInBytes;

public final class StorageImplUtils {
    private static final File[] EMPTY_FILE_ARRAY = new File[0];

    private StorageImplUtils() {
    }

    public static SnapshotManager newSnapshotManager(RaftPeerId id, Supplier<RaftStorageDirectory> dir, StateMachineStorage smStorage) {
        return new SnapshotManager(id, dir, smStorage);
    }

    public static RaftStorageImpl newRaftStorage(File dir, SizeInBytes freeSpaceMin, RaftStorage.StartupOption option, RaftServerConfigKeys.Log.CorruptionPolicy logCorruptionPolicy) {
        return new RaftStorageImpl(dir, freeSpaceMin, option, logCorruptionPolicy);
    }

    static List<File> getExistingStorageSubs(List<File> volumes, String targetSubDir, Map<File, Integer> dirsPerVol) {
        return volumes.stream().flatMap(volume -> {
            File[] dirs = Optional.ofNullable(volume.listFiles()).orElse(EMPTY_FILE_ARRAY);
            Optional.ofNullable(dirsPerVol).ifPresent(map -> map.put(volume, dirs.length));
            return Arrays.stream(dirs);
        }).filter(dir -> targetSubDir.equals(dir.getName())).collect(Collectors.toList());
    }

    static File chooseMin(Map<File, Integer> dirsPerVol) throws IOException {
        return dirsPerVol.entrySet().stream().min(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElseThrow(() -> new IOException("No storage directory found."));
    }

    public static RaftStorageImpl initRaftStorage(String storageDirName, RaftStorage.StartupOption option, RaftProperties properties) throws IOException {
        return new Op(storageDirName, option, properties).run();
    }
}

