/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.util;

import java.util.List;
import java.util.function.Function;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.util.ProtoUtils;

public final class ServerStringUtils {
    private ServerStringUtils() {
    }

    public static String toAppendEntriesRequestString(RaftProtos.AppendEntriesRequestProto request, Function<RaftProtos.StateMachineLogEntryProto, String> stateMachineToString) {
        if (request == null) {
            return null;
        }
        List entries = request.getEntriesList();
        return ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()) + "-t" + request.getLeaderTerm() + ",previous=" + TermIndex.valueOf((RaftProtos.TermIndexProto)request.getPreviousLog()) + ",leaderCommit=" + request.getLeaderCommit() + ",initializing? " + request.getInitializing() + "," + (entries.isEmpty() ? "HEARTBEAT" : "entries: " + LogProtoUtils.toLogEntriesShortString((List)entries, stateMachineToString));
    }

    public static String toAppendEntriesReplyString(RaftProtos.AppendEntriesReplyProto reply) {
        if (reply == null) {
            return null;
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcReplyProto)reply.getServerReply()) + "-t" + reply.getTerm() + "," + reply.getResult() + ",nextIndex=" + reply.getNextIndex() + ",followerCommit=" + reply.getFollowerCommit() + ",matchIndex=" + reply.getMatchIndex();
    }

    public static String toInstallSnapshotRequestString(RaftProtos.InstallSnapshotRequestProto request) {
        String s;
        if (request == null) {
            return null;
        }
        switch (1.$SwitchMap$org$apache$ratis$proto$RaftProtos$InstallSnapshotRequestProto$InstallSnapshotRequestBodyCase[request.getInstallSnapshotRequestBodyCase().ordinal()]) {
            case 1: {
                RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto chunk = request.getSnapshotChunk();
                s = "chunk:" + chunk.getRequestId() + "," + chunk.getRequestIndex();
                break;
            }
            case 2: {
                RaftProtos.InstallSnapshotRequestProto.NotificationProto notification = request.getNotification();
                s = "notify:" + TermIndex.valueOf((RaftProtos.TermIndexProto)notification.getFirstAvailableTermIndex());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected body case in " + request);
            }
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()) + "-t" + request.getLeaderTerm() + "," + s;
    }

    public static String toInstallSnapshotReplyString(RaftProtos.InstallSnapshotReplyProto reply) {
        String s;
        if (reply == null) {
            return null;
        }
        switch (1.$SwitchMap$org$apache$ratis$proto$RaftProtos$InstallSnapshotReplyProto$InstallSnapshotReplyBodyCase[reply.getInstallSnapshotReplyBodyCase().ordinal()]) {
            case 1: {
                s = ",requestIndex=" + reply.getRequestIndex();
                break;
            }
            case 2: {
                s = ",snapshotIndex=" + reply.getSnapshotIndex();
                break;
            }
            default: {
                s = "";
            }
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcReplyProto)reply.getServerReply()) + "-t" + reply.getTerm() + "," + reply.getResult() + s;
    }

    public static String toRequestVoteReplyString(RaftProtos.RequestVoteReplyProto proto) {
        if (proto == null) {
            return null;
        }
        return ProtoUtils.toString((RaftProtos.RaftRpcReplyProto)proto.getServerReply()) + "-t" + proto.getTerm();
    }
}

