/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.ReadOnlyRequestTests;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class ReadOnlyRequestWithLongTimeoutTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final int NUM_SERVERS = 3;
    static final String INCREMENT = "INCREMENT";
    static final String WAIT_AND_INCREMENT = "WAIT_AND_INCREMENT";
    static final String TIMEOUT_INCREMENT = "TIMEOUT_INCREMENT";
    static final String QUERY = "QUERY";
    final Message incrementMessage;
    final Message waitAndIncrementMessage;
    final Message timeoutMessage;
    final Message queryMessage;

    public ReadOnlyRequestWithLongTimeoutTests() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        this.incrementMessage = new RaftTestUtil.SimpleMessage(INCREMENT);
        this.waitAndIncrementMessage = new RaftTestUtil.SimpleMessage(WAIT_AND_INCREMENT);
        this.timeoutMessage = new RaftTestUtil.SimpleMessage(TIMEOUT_INCREMENT);
        this.queryMessage = new RaftTestUtil.SimpleMessage(QUERY);
    }

    @Before
    public void setup() {
        RaftProperties p = this.getProperties();
        p.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, ReadOnlyRequestTests.CounterStateMachine.class, StateMachine.class);
        RaftServerConfigKeys.Read.setOption((RaftProperties)p, (RaftServerConfigKeys.Read.Option)RaftServerConfigKeys.Read.Option.LINEARIZABLE);
        RaftServerConfigKeys.Read.setTimeout((RaftProperties)p, (TimeDuration)TimeDuration.ONE_SECOND);
        RaftServerConfigKeys.Rpc.setFirstElectionTimeoutMin((RaftProperties)p, (TimeDuration)TimeDuration.valueOf((long)150L, (TimeUnit)TimeUnit.MILLISECONDS));
        RaftServerConfigKeys.Rpc.setFirstElectionTimeoutMax((RaftProperties)p, (TimeDuration)TimeDuration.valueOf((long)300L, (TimeUnit)TimeUnit.MILLISECONDS));
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)p, (TimeDuration)TimeDuration.valueOf((long)3L, (TimeUnit)TimeUnit.SECONDS));
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)p, (TimeDuration)TimeDuration.valueOf((long)6L, (TimeUnit)TimeUnit.SECONDS));
        RaftServerConfigKeys.Rpc.setRequestTimeout((RaftProperties)p, (TimeDuration)TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS));
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)p, (TimeDuration)TimeDuration.valueOf((long)10L, (TimeUnit)TimeUnit.SECONDS));
    }

    @Test
    public void testLinearizableReadParallel() throws Exception {
        this.runWithNewCluster(3, this::testLinearizableReadParallelImpl);
    }

    private void testLinearizableReadParallelImpl(CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeader().getId();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId, RetryPolicies.noRetry());){
            RaftClientReply reply = client.io().send(this.incrementMessage);
            Assert.assertTrue((boolean)reply.isSuccess());
            client.async().send(this.waitAndIncrementMessage);
            Thread.sleep(100L);
            RaftClientReply staleValueBefore = client.io().sendStaleRead(this.queryMessage, 0L, leaderId);
            Assert.assertEquals((long)1L, (long)ReadOnlyRequestTests.retrieve(staleValueBefore));
            RaftClientReply linearizableReadValue = client.io().sendReadOnly(this.queryMessage);
            Assert.assertEquals((long)2L, (long)ReadOnlyRequestTests.retrieve(linearizableReadValue));
        }
    }

    @Test
    public void testLinearizableReadTimeout() throws Exception {
        this.runWithNewCluster(3, this::testLinearizableReadTimeoutImpl);
    }

    private void testLinearizableReadTimeoutImpl(CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeader().getId();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId, RetryPolicies.noRetry());){
            RaftClientReply reply = client.io().send(this.incrementMessage);
            Assert.assertTrue((boolean)reply.isSuccess());
            CompletableFuture asyncTimeoutReply = client.async().send(this.timeoutMessage);
            Thread.sleep(100L);
            Assert.assertThrows(ReadException.class, () -> {
                RaftClientReply timeoutReply = client.io().sendReadOnly(this.queryMessage);
                Assert.assertTrue((boolean)(timeoutReply.getException().getCause() instanceof TimeoutIOException));
            });
            asyncTimeoutReply.join();
        }
    }
}

