/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ratis.BaseTest;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.api.GroupManagementApi;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.Slf4jUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class GroupInfoBaseTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public GroupInfoBaseTest() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
    }

    @Test
    public void testGroupInfo() throws Exception {
        this.runWithNewCluster(3, this::runTest);
    }

    private void runTest(CLUSTER cluster) throws Exception {
        Throwable throwable;
        RaftClient client;
        RaftGroup group = ((MiniRaftCluster)cluster).getGroup();
        List<RaftPeer> peers = ((MiniRaftCluster)cluster).getPeers();
        RaftGroup group2 = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), peers);
        for (RaftPeer peer : peers) {
            client = ((MiniRaftCluster)cluster).createClient(peer.getId());
            throwable = null;
            try {
                client.getGroupManagementApi(peer.getId()).add(group2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                client.close();
            }
        }
        for (RaftPeer peer : peers) {
            client = ((MiniRaftCluster)cluster).createClient(peer.getId());
            throwable = null;
            try {
                GroupManagementApi api = client.getGroupManagementApi(peer.getId());
                GroupListReply info = api.list();
                List groupList = info.getGroupIds().stream().filter(id -> group.getGroupId().equals(id)).collect(Collectors.toList());
                assert (groupList.size() == 1);
                GroupInfoReply gi = api.info((RaftGroupId)groupList.get(0));
                assert (this.sameGroup(group, gi.getGroup()));
                groupList = info.getGroupIds().stream().filter(id -> group2.getGroupId().equals(id)).collect(Collectors.toList());
                assert (groupList.size() == 1);
                GroupInfoReply gi2 = api.info((RaftGroupId)groupList.get(0));
                assert (this.sameGroup(group2, gi2.getGroup()));
            }
            catch (Throwable api) {
                throwable = api;
                throw api;
            }
            finally {
                if (client == null) continue;
                if (throwable != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable api) {
                        throwable.addSuppressed(api);
                    }
                    continue;
                }
                client.close();
            }
        }
        int numMessages = 5;
        RaftClientReply reply = this.sendMessages(5, (MiniRaftCluster)cluster);
        long maxCommit = reply.getCommitInfos().stream().mapToLong(RaftProtos.CommitInfoProto::getCommitIndex).max().getAsLong();
        RaftPeerId killedFollower = ((MiniRaftCluster)cluster).getFollowers().iterator().next().getId();
        ((MiniRaftCluster)cluster).killServer(killedFollower);
        RaftClientReply reply2 = this.sendMessages(5, (MiniRaftCluster)cluster);
        for (RaftProtos.CommitInfoProto i : reply2.getCommitInfos()) {
            if (RaftPeerId.valueOf((ByteString)i.getServer().getId()).equals((Object)killedFollower)) continue;
            Assert.assertTrue((i.getCommitIndex() > maxCommit ? 1 : 0) != 0);
        }
        for (RaftPeer peer : peers) {
            if (peer.getId().equals((Object)killedFollower)) continue;
            RaftClient client2 = ((MiniRaftCluster)cluster).createClient(peer.getId());
            Throwable throwable4 = null;
            try {
                GroupListReply info = client2.getGroupManagementApi(peer.getId()).list();
                Assert.assertEquals((long)1L, (long)info.getGroupIds().stream().filter(id -> group.getGroupId().equals(id)).count());
                for (RaftProtos.CommitInfoProto i : info.getCommitInfos()) {
                    if (RaftPeerId.valueOf((ByteString)i.getServer().getId()).equals((Object)killedFollower)) {
                        Assert.assertTrue((i.getCommitIndex() <= maxCommit ? 1 : 0) != 0);
                        continue;
                    }
                    Assert.assertTrue((i.getCommitIndex() > maxCommit ? 1 : 0) != 0);
                }
            }
            catch (Throwable throwable5) {
                throwable4 = throwable5;
                throw throwable5;
            }
            finally {
                if (client2 == null) continue;
                if (throwable4 != null) {
                    try {
                        client2.close();
                    }
                    catch (Throwable throwable6) {
                        throwable4.addSuppressed(throwable6);
                    }
                    continue;
                }
                client2.close();
            }
        }
    }

    RaftClientReply sendMessages(int n, MiniRaftCluster cluster) throws Exception {
        this.LOG.info("sendMessages: " + n);
        RaftClientReply reply = null;
        try (RaftClient client = cluster.createClient();){
            for (int i = 0; i < n; ++i) {
                reply = client.io().send(Message.valueOf((String)("m" + i)));
            }
        }
        return reply;
    }

    private boolean sameGroup(RaftGroup expected, RaftGroup given) {
        if (!expected.getGroupId().toString().equals(given.getGroupId().toString())) {
            return false;
        }
        Collection expectedPeers = expected.getPeers();
        Collection givenPeers = given.getPeers();
        if (expectedPeers.size() != givenPeers.size()) {
            return false;
        }
        for (RaftPeer peerGiven : givenPeers) {
            boolean found = false;
            for (RaftPeer peerExpect : expectedPeers) {
                if (!peerGiven.getId().toString().equals(peerExpect.getId().toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

