/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.metrics.impl.DefaultTimekeeperImpl;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.BlockRequestHandlingInjection;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.TransferLeadership;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogTestUtils;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.apache.ratis.thirdparty.com.codahale.metrics.Timer;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.apache.ratis.util.function.CheckedBiConsumer;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class LeaderElectionTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    public LeaderElectionTests() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
    }

    @Test
    public void testBasicLeaderElection() throws Exception {
        this.LOG.info("Running testBasicLeaderElection");
        MiniRaftCluster cluster = this.newCluster(5);
        cluster.start();
        RaftTestUtil.waitAndKillLeader(cluster);
        RaftTestUtil.waitAndKillLeader(cluster);
        RaftTestUtil.waitAndKillLeader(cluster);
        this.testFailureCase("waitForLeader after killed a majority of servers", () -> RaftTestUtil.waitForLeader(cluster, null, false), IllegalStateException.class, new Class[0]);
        cluster.shutdown();
    }

    @Test
    public void testChangeLeader() throws Exception {
        SegmentedRaftLogTestUtils.setRaftLogWorkerLogLevel(Level.TRACE);
        this.LOG.info("Running testChangeLeader");
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftPeerId leader = RaftTestUtil.waitForLeader(cluster).getId();
        for (int i = 0; i < 10; ++i) {
            leader = RaftTestUtil.changeLeader(cluster, leader, IllegalStateException::new);
            ExitUtils.assertNotTerminated();
        }
        SegmentedRaftLogTestUtils.setRaftLogWorkerLogLevel(Level.INFO);
        cluster.shutdown();
    }

    @Test
    public void testLostMajorityHeartbeats() throws Exception {
        this.runWithNewCluster(3, this::runTestLostMajorityHeartbeats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestLostMajorityHeartbeats(CLUSTER cluster) throws Exception {
        TimeDuration maxTimeout = RaftServerConfigKeys.Rpc.timeoutMax((RaftProperties)this.getProperties());
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        try {
            RaftTestUtil.isolate(cluster, leader.getId());
            maxTimeout.sleep();
            maxTimeout.sleep();
            RaftServerTestUtil.assertLostMajorityHeartbeatsRecently(leader);
        }
        finally {
            RaftTestUtil.deIsolate(cluster, leader.getId());
        }
    }

    @Test
    public void testLeaderNotCountListenerForMajority() throws Exception {
        this.runWithNewCluster(3, 2, this::runTestLeaderNotCountListenerForMajority);
    }

    void runTestLeaderNotCountListenerForMajority(CLUSTER cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        Assertions.assertEquals((int)2, (int)((RaftConfigurationImpl)((MiniRaftCluster)cluster).getLeader().getRaftConf()).getMajorityCount());
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leader.getId());){
            client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
            List listeners = ((MiniRaftCluster)cluster).getListeners().stream().map(RaftServer.Division::getPeer).collect(Collectors.toList());
            Assertions.assertEquals((int)2, (int)listeners.size());
            RaftClientReply reply = client.admin().setConfiguration(((MiniRaftCluster)cluster).getPeers());
            Assertions.assertTrue((boolean)reply.isSuccess());
            Collection peer = leader.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.LISTENER);
            Assertions.assertEquals((int)0, (int)peer.size());
        }
        Assertions.assertEquals((int)3, (int)((RaftConfigurationImpl)((MiniRaftCluster)cluster).getLeader().getRaftConf()).getMajorityCount());
    }

    @Test
    public void testListenerNotStartLeaderElection() throws Exception {
        this.runWithNewCluster(3, 2, this::runTestListenerNotStartLeaderElection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestListenerNotStartLeaderElection(CLUSTER cluster) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        TimeDuration maxTimeout = RaftServerConfigKeys.Rpc.timeoutMax((RaftProperties)this.getProperties());
        RaftServer.Division listener = ((MiniRaftCluster)cluster).getListeners().get(0);
        RaftPeerId listenerId = listener.getId();
        try {
            RaftTestUtil.isolate(cluster, listenerId);
            maxTimeout.sleep();
            maxTimeout.sleep();
            Assertions.assertEquals((Object)RaftProtos.RaftPeerRole.LISTENER, (Object)listener.getInfo().getCurrentRole());
        }
        finally {
            RaftTestUtil.deIsolate(cluster, listener.getId());
        }
    }

    @Test
    public void testTransferLeader() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                List<RaftServer.Division> followers = cluster.getFollowers();
                Assertions.assertEquals((int)2, (int)followers.size());
                RaftServer.Division newLeader = followers.get(0);
                RaftClientReply reply = client.admin().transferLeadership(newLeader.getId(), 20000L);
                Assertions.assertTrue((boolean)reply.isSuccess());
                RaftServer.Division currLeader = RaftTestUtil.waitForLeader(cluster);
                Assertions.assertEquals((Object)newLeader.getId(), (Object)currLeader.getId());
                reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assertions.assertEquals((Object)newLeader.getId().toString(), (Object)reply.getReplierId());
                Assertions.assertTrue((boolean)reply.isSuccess());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testYieldLeaderToHigherPriority() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                List<RaftServer.Division> followers = cluster.getFollowers();
                Assertions.assertEquals((int)2, (int)followers.size());
                RaftServer.Division newLeader = followers.get(0);
                List<RaftPeer> peers = cluster.getPeers();
                List peersWithNewPriority = this.getPeersWithPriority(peers, newLeader.getPeer());
                RaftClientReply reply = client.admin().setConfiguration(peersWithNewPriority.toArray(new RaftPeer[0]));
                Assertions.assertTrue((boolean)reply.isSuccess());
                TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS).sleep();
                RaftServer.Division currLeader = RaftTestUtil.waitForLeader(cluster);
                Assertions.assertEquals((Object)newLeader.getId(), (Object)currLeader.getId());
                reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assertions.assertEquals((Object)newLeader.getId().toString(), (Object)reply.getReplierId());
                Assertions.assertTrue((boolean)reply.isSuccess());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testTransferLeaderTimeout() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                List<RaftServer.Division> followers = cluster.getFollowers();
                Assertions.assertEquals((int)followers.size(), (int)2);
                RaftServer.Division newLeader = followers.get(0);
                RaftTestUtil.isolate(cluster, newLeader.getId());
                List<RaftPeer> peers = cluster.getPeers();
                CompletableFuture<Boolean> transferTimeoutFuture = CompletableFuture.supplyAsync(() -> {
                    try {
                        long timeoutMs = 5000L;
                        long start = System.currentTimeMillis();
                        try {
                            client.admin().transferLeadership(newLeader.getId(), timeoutMs);
                        }
                        catch (TransferLeadershipException e) {
                            long cost = System.currentTimeMillis() - start;
                            Assertions.assertTrue((cost > timeoutMs ? 1 : 0) != 0);
                            Assertions.assertTrue((boolean)e.getMessage().contains("Failed to transfer leadership to"));
                            Assertions.assertTrue((boolean)e.getMessage().contains(TransferLeadership.Result.Type.TIMED_OUT.toString()));
                        }
                        return true;
                    }
                    catch (IOException e) {
                        return false;
                    }
                });
                JavaUtils.attemptRepeatedly(() -> {
                    try {
                        client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                    }
                    catch (LeaderSteppingDownException e) {
                        Assertions.assertTrue((boolean)e.getMessage().contains("is stepping down"));
                    }
                    return null;
                }, (int)5, (TimeDuration)TimeDuration.ONE_SECOND, (String)"check leader steppingDown", (Logger)RaftServer.LOG);
                Assertions.assertTrue((boolean)transferTimeoutFuture.get());
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assertions.assertEquals((Object)leader.getId().toString(), (Object)reply.getReplierId());
                Assertions.assertTrue((boolean)reply.isSuccess());
                RaftTestUtil.deIsolate(cluster, newLeader.getId());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testEnforceLeader() throws Exception {
        this.LOG.info("Running testEnforceLeader");
        int numServer = 5;
        try (MiniRaftCluster cluster = this.newCluster(5);){
            cluster.start();
            RaftPeerId firstLeader = RaftTestUtil.waitForLeader(cluster).getId();
            this.LOG.info("firstLeader = {}", (Object)firstLeader);
            int first = MiniRaftCluster.getIdIndex(firstLeader.toString());
            int random = ThreadLocalRandom.current().nextInt(4);
            String newLeader = "s" + (random < first ? random : random + 1);
            this.LOG.info("enforce leader to {}", (Object)newLeader);
            LeaderElectionTests.enforceLeader(cluster, newLeader, this.LOG);
        }
    }

    static void enforceLeader(MiniRaftCluster cluster, String newLeader, Logger log) throws InterruptedException {
        log.info(cluster.printServers());
        for (int i = 0; !cluster.tryEnforceLeader(newLeader) && i < 10; ++i) {
            RaftServer.Division currLeader = cluster.getLeader();
            log.info("try enforcing leader to " + newLeader + " but " + (currLeader == null ? "no leader for round " + i : "new leader is " + currLeader.getId()));
            TimeDuration.ONE_SECOND.sleep();
        }
        log.info(cluster.printServers());
        RaftServer.Division leader = cluster.getLeader();
        Assertions.assertEquals((Object)newLeader, (Object)leader.getId().toString());
    }

    @Test
    public void testLateServerStart() throws Exception {
        int numServer = 3;
        this.LOG.info("Running testLateServerStart");
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.initServers();
        Iterator<RaftServer> i = cluster.getServers().iterator();
        for (int j = 1; j < 3; ++j) {
            i.next().start();
        }
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        TimeDuration sleepTime = TimeDuration.valueOf((long)3L, (TimeUnit)TimeUnit.SECONDS);
        this.LOG.info("sleep " + sleepTime);
        sleepTime.sleep();
        RaftServerProxy lastServer = (RaftServerProxy)i.next();
        lastServer.start();
        RaftPeerId lastServerLeaderId = (RaftPeerId)JavaUtils.attemptRepeatedly(() -> Optional.ofNullable(((RaftServerImpl)lastServer.getImpls().iterator().next()).getState().getLeaderId()).orElseThrow(() -> new IllegalStateException("No leader yet")), (int)10, (TimeDuration)ONE_SECOND, (String)"getLeaderId", (Logger)this.LOG);
        this.LOG.info(cluster.printServers());
        Assertions.assertEquals((Object)leader.getId(), (Object)lastServerLeaderId);
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testDisconnectLeader() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Thread.sleep(1000L);
                RaftTestUtil.isolate(cluster, leader.getId());
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assertions.assertNotEquals((Object)reply.getReplierId(), (Object)leader.getId().toString());
                Assertions.assertTrue((boolean)reply.isSuccess());
            }
            finally {
                RaftTestUtil.deIsolate(cluster, leader.getId());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testAddListener() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                List<RaftPeer> servers = cluster.getPeers();
                Assertions.assertEquals((int)servers.size(), (int)3);
                MiniRaftCluster.PeerChanges changes = cluster.addNewPeers(1, true, false, RaftProtos.RaftPeerRole.LISTENER);
                RaftClientReply reply = client.admin().setConfiguration(servers, Arrays.asList(changes.newPeers));
                Assertions.assertTrue((boolean)reply.isSuccess());
                Collection listener = leader.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.LISTENER);
                Assertions.assertEquals((int)1, (int)listener.size());
                Assertions.assertEquals((Object)changes.newPeers[0].getId(), (Object)((RaftPeer)new ArrayList(listener).get(0)).getId());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testAddFollowerWhenExistsListener() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3, 1);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                List<RaftPeer> servers = cluster.getPeers();
                Assertions.assertEquals((int)4, (int)servers.size());
                ArrayList listener = new ArrayList(leader.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.LISTENER));
                Assertions.assertEquals((int)1, (int)listener.size());
                MiniRaftCluster.PeerChanges changes = cluster.addNewPeers(1, true, false);
                ArrayList<RaftPeer> newPeers = new ArrayList<RaftPeer>(Arrays.asList(changes.newPeers));
                newPeers.addAll(leader.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.FOLLOWER));
                RaftClientReply reply = client.admin().setConfiguration(newPeers, listener);
                Assertions.assertTrue((boolean)reply.isSuccess());
                Assertions.assertEquals((int)4, (int)leader.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.FOLLOWER).size());
                Assertions.assertEquals((int)1, (int)leader.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.LISTENER).size());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testRemoveListener() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3, 1);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assertions.assertEquals((int)1, (int)cluster.getListeners().size());
                List servers = cluster.getFollowers().stream().map(RaftServer.Division::getPeer).collect(Collectors.toList());
                servers.add(leader.getPeer());
                RaftClientReply reply = client.admin().setConfiguration(servers);
                Assertions.assertTrue((boolean)reply.isSuccess());
                Assertions.assertEquals((int)0, (int)leader.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.LISTENER).size());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testChangeFollowerToListener() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient();){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                List followers = cluster.getFollowers().stream().map(RaftServer.Division::getPeer).collect(Collectors.toList());
                Assertions.assertEquals((int)2, (int)followers.size());
                ArrayList listeners = new ArrayList();
                listeners.add(followers.get(1));
                followers.remove(1);
                RaftClientReply reply = client.admin().setConfiguration(followers, listeners);
                Assertions.assertTrue((boolean)reply.isSuccess());
                Collection peer = leader.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.LISTENER);
                Assertions.assertEquals((int)1, (int)peer.size());
                Assertions.assertEquals((Object)((RaftPeer)listeners.get(0)).getId(), (Object)((RaftPeer)new ArrayList(peer).get(0)).getId());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testChangeListenerToFollower() throws Exception {
        try (MiniRaftCluster cluster = this.newCluster(2, 1);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                List listeners = cluster.getListeners().stream().map(RaftServer.Division::getPeer).collect(Collectors.toList());
                Assertions.assertEquals((int)listeners.size(), (int)1);
                RaftClientReply reply = client.admin().setConfiguration(cluster.getPeers());
                Assertions.assertTrue((boolean)reply.isSuccess());
                Collection peer = leader.getRaftConf().getAllPeers(RaftProtos.RaftPeerRole.LISTENER);
                Assertions.assertEquals((int)0, (int)peer.size());
            }
            cluster.shutdown();
        }
    }

    @Test
    public void testLeaderElectionMetrics() throws IOException, InterruptedException {
        Timestamp timestamp = Timestamp.currentTime();
        MiniRaftCluster cluster = this.newCluster(3);
        cluster.start();
        RaftServer.Division leaderServer = RaftTestUtil.waitForLeader(cluster);
        RatisMetricRegistryImpl ratisMetricRegistry = (RatisMetricRegistryImpl)LeaderElectionMetrics.createRegistry((RaftGroupMemberId)leaderServer.getMemberId());
        long numLeaderElections = ratisMetricRegistry.counter("electionCount").getCount();
        Assert.assertTrue((numLeaderElections > 0L ? 1 : 0) != 0);
        long numLeaderElectionTimeout = ratisMetricRegistry.counter("timeoutCount").getCount();
        Assert.assertTrue((numLeaderElectionTimeout > 0L ? 1 : 0) != 0);
        DefaultTimekeeperImpl timekeeper = (DefaultTimekeeperImpl)ratisMetricRegistry.timer("electionTime");
        Timer timer = timekeeper.getTimer();
        double meanTimeNs = timer.getSnapshot().getMean();
        long elapsedNs = timestamp.elapsedTime().toLong(TimeUnit.NANOSECONDS);
        Assert.assertTrue((timer.getCount() > 0L && meanTimeNs < (double)elapsedNs ? 1 : 0) != 0);
        Long leaderElectionLatency = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("lastLeaderElectionElapsedTime")).values().iterator().next()).getValue();
        Assert.assertTrue((leaderElectionLatency > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testImmediatelyRevertedToFollower() {
        RaftServerImpl server = LeaderElectionTests.createMockServer(true);
        LeaderElection subject = new LeaderElection(server, false);
        try {
            subject.startInForeground();
            Assert.assertEquals((Object)LifeCycle.State.CLOSED, (Object)subject.getCurrentState());
        }
        catch (Exception e) {
            this.LOG.info("Error starting LeaderElection", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testShutdownBeforeStart() {
        RaftServerImpl server = LeaderElectionTests.createMockServer(false);
        LeaderElection subject = new LeaderElection(server, false);
        try {
            subject.shutdown();
            subject.startInForeground();
            Assert.assertEquals((Object)LifeCycle.State.CLOSED, (Object)subject.getCurrentState());
        }
        catch (Exception e) {
            this.LOG.info("Error starting LeaderElection", (Throwable)e);
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPreVote() {
        try (MiniRaftCluster cluster = this.newCluster(3);){
            cluster.start();
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            try (RaftClient client = cluster.createClient(leader.getId());){
                client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                List<RaftServer.Division> followers = cluster.getFollowers();
                Assert.assertEquals((long)followers.size(), (long)2L);
                RaftServer.Division follower = followers.get(0);
                RaftTestUtil.isolate(cluster, follower.getId());
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assertions.assertTrue((boolean)reply.isSuccess());
                long savedTerm = leader.getInfo().getCurrentTerm();
                this.LOG.info("Wait follower {} timeout and trigger pre-vote", (Object)follower.getId());
                Thread.sleep(2000L);
                RaftTestUtil.deIsolate(cluster, follower.getId());
                Thread.sleep(2000L);
                RaftServer.Division newleader = RaftTestUtil.waitForLeader(cluster);
                Assert.assertNotNull((Object)newleader);
                Assert.assertEquals((Object)newleader.getId(), (Object)leader.getId());
                Assert.assertEquals((long)savedTerm, (long)leader.getInfo().getCurrentTerm());
                reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
                Assertions.assertTrue((boolean)reply.isSuccess());
            }
            cluster.shutdown();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testListenerRejectRequestVote() throws Exception {
        this.runWithNewCluster(3, 2, this::runTestListenerRejectRequestVote);
    }

    void runTestListenerRejectRequestVote(CLUSTER cluster) throws IOException, InterruptedException {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        TermIndex lastEntry = leader.getRaftLog().getLastEntryTermIndex();
        RaftServer.Division listener = ((MiniRaftCluster)cluster).getListeners().get(0);
        RaftProtos.RequestVoteRequestProto r = ServerProtoUtils.toRequestVoteRequestProto((RaftGroupMemberId)leader.getMemberId(), (RaftPeerId)listener.getId(), (long)(leader.getRaftLog().getLastEntryTermIndex().getTerm() + 1L), (TermIndex)lastEntry, (boolean)true);
        RaftProtos.RequestVoteReplyProto listenerReply = listener.getRaftServer().requestVote(r);
        Assertions.assertFalse((boolean)listenerReply.getServerReply().getSuccess());
    }

    @Test
    public void testPauseResumeLeaderElection() throws Exception {
        this.runWithNewCluster(3, this::runTestPauseResumeLeaderElection);
    }

    void runTestPauseResumeLeaderElection(CLUSTER cluster) throws IOException, InterruptedException {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = leader.getId();
        List<RaftServer.Division> followers = ((MiniRaftCluster)cluster).getFollowers();
        Assertions.assertTrue((followers.size() >= 1 ? 1 : 0) != 0);
        RaftServerImpl f1 = (RaftServerImpl)followers.get(0);
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient();){
            RaftClientReply pauseLeaderReply = client.getLeaderElectionManagementApi(f1.getId()).pause();
            Assertions.assertTrue((boolean)pauseLeaderReply.isSuccess());
            client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
            RaftServer.Division newLeader = followers.get(0);
            List<RaftPeer> peers = ((MiniRaftCluster)cluster).getPeers();
            List peersWithNewPriority = this.getPeersWithPriority(peers, newLeader.getPeer());
            RaftClientReply reply = client.admin().setConfiguration(peersWithNewPriority.toArray(new RaftPeer[0]));
            Assertions.assertTrue((boolean)reply.isSuccess());
            JavaUtils.attempt(() -> Assertions.assertEquals((Object)leaderId, (Object)leader.getId()), (int)20, (TimeDuration)HUNDRED_MILLIS, (String)"check leader id", (Logger)this.LOG);
            RaftClientReply resumeLeaderReply = client.getLeaderElectionManagementApi(f1.getId()).resume();
            Assertions.assertTrue((boolean)resumeLeaderReply.isSuccess());
            JavaUtils.attempt(() -> Assertions.assertEquals((Object)f1.getId(), (Object)cluster.getLeader().getId()), (int)20, (TimeDuration)HUNDRED_MILLIS, (String)"check new leader", (Logger)this.LOG);
        }
    }

    private void runLeaseTest(CLUSTER cluster, CheckedBiConsumer<CLUSTER, Long, Exception> testCase) throws Exception {
        double leaseRatio = RaftServerConfigKeys.Read.leaderLeaseTimeoutRatio((RaftProperties)this.getProperties());
        long leaseTimeoutMs = RaftServerConfigKeys.Rpc.timeoutMin((RaftProperties)this.getProperties()).multiply(leaseRatio).toIntExact(TimeUnit.MILLISECONDS);
        testCase.accept(cluster, (Object)leaseTimeoutMs);
    }

    @Test
    public void testLeaderLease() throws Exception {
        RaftServerConfigKeys.Read.setLeaderLeaseEnabled((RaftProperties)this.getProperties(), (boolean)true);
        RaftServerConfigKeys.Read.setLeaderLeaseTimeoutRatio((RaftProperties)this.getProperties(), (double)0.5);
        this.runWithNewCluster(3, c -> this.runLeaseTest(c, this::runTestLeaderLease));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestLeaderLease(CLUSTER cluster, long leaseTimeoutMs) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leader.getId());){
            client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
            Assertions.assertTrue((boolean)leader.getInfo().isLeader());
            Assertions.assertTrue((boolean)leader.getInfo().isLeaderReady());
            RaftServerTestUtil.assertLeaderLease(leader, true);
            RaftTestUtil.isolate(cluster, leader.getId());
            Thread.sleep(leaseTimeoutMs);
            Assertions.assertTrue((boolean)leader.getInfo().isLeader());
            Assertions.assertTrue((boolean)leader.getInfo().isLeaderReady());
            RaftServerTestUtil.assertLeaderLease(leader, false);
        }
        finally {
            RaftTestUtil.deIsolate(cluster, leader.getId());
        }
    }

    @Test
    public void testLeaderLeaseDuringReconfiguration() throws Exception {
        RaftServerConfigKeys.Read.setLeaderLeaseEnabled((RaftProperties)this.getProperties(), (boolean)true);
        RaftServerConfigKeys.Read.setLeaderLeaseTimeoutRatio((RaftProperties)this.getProperties(), (double)0.5);
        this.runWithNewCluster(3, c -> this.runLeaseTest(c, this::runTestLeaderLeaseDuringReconfiguration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTestLeaderLeaseDuringReconfiguration(CLUSTER cluster, long leaseTimeoutMs) throws Exception {
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leader.getId());){
            client.io().send((Message)new RaftTestUtil.SimpleMessage("message"));
            Assertions.assertTrue((boolean)leader.getInfo().isLeader());
            Assertions.assertTrue((boolean)leader.getInfo().isLeaderReady());
            RaftServerTestUtil.assertLeaderLease(leader, true);
            List<RaftServer.Division> followers = ((MiniRaftCluster)cluster).getFollowers();
            MiniRaftCluster.PeerChanges changes = ((MiniRaftCluster)cluster).addNewPeers(2, true);
            BlockRequestHandlingInjection.getInstance().blockReplier(followers.get(0).getId().toString());
            BlockRequestHandlingInjection.getInstance().blockReplier(followers.get(1).getId().toString());
            new Thread(() -> {
                try {
                    client.admin().setConfiguration(changes.allPeersInNewConf);
                }
                catch (IOException e) {
                    System.out.println("as expected: " + e.getMessage());
                }
            }).start();
            Thread.sleep(leaseTimeoutMs);
            Assertions.assertTrue((boolean)leader.getInfo().isLeader());
            Assertions.assertTrue((boolean)leader.getInfo().isLeaderReady());
            RaftServerTestUtil.assertLeaderLease(leader, false);
        }
        finally {
            BlockRequestHandlingInjection.getInstance().unblockAll();
        }
    }

    private static RaftServerImpl createMockServer(boolean alive) {
        DivisionInfo info = (DivisionInfo)Mockito.mock(DivisionInfo.class);
        Mockito.when((Object)info.isAlive()).thenReturn((Object)alive);
        Mockito.when((Object)info.isCandidate()).thenReturn((Object)false);
        RaftServerImpl server = (RaftServerImpl)Mockito.mock(RaftServerImpl.class);
        Mockito.when((Object)server.getInfo()).thenReturn((Object)info);
        RaftGroupMemberId memberId = RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((String)"any"), (RaftGroupId)RaftGroupId.randomId());
        Mockito.when((Object)server.getMemberId()).thenReturn((Object)memberId);
        LeaderElectionMetrics leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics((RaftGroupMemberId)memberId, () -> 0L);
        Mockito.when((Object)server.getLeaderElectionMetrics()).thenReturn((Object)leaderElectionMetrics);
        RaftServerProxy proxy = (RaftServerProxy)Mockito.mock(RaftServerProxy.class);
        RaftProperties properties = new RaftProperties();
        RaftServerConfigKeys.LeaderElection.setPreVote((RaftProperties)properties, (boolean)true);
        Mockito.when((Object)proxy.getProperties()).thenReturn((Object)properties);
        Mockito.when((Object)server.getRaftServer()).thenReturn((Object)proxy);
        return server;
    }
}

