/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RetryCache;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RetryCacheTestUtil;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class RaftStateMachineExceptionTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    private static volatile boolean failPreAppend = false;

    public RaftStateMachineExceptionTests() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachineWithException.class, StateMachine.class);
    }

    @Test
    public void testHandleStateMachineException() throws Exception {
        this.runWithNewCluster(3, this::runTestHandleStateMachineException);
    }

    private void runTestHandleStateMachineException(CLUSTER cluster) throws Exception {
        RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
            client.io().send((Message)new RaftTestUtil.SimpleMessage("m"));
            Assert.fail((String)"Exception expected");
        }
        catch (StateMachineException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Fake Exception"));
        }
        ((MiniRaftCluster)cluster).shutdown();
    }

    @Test
    public void testRetryOnStateMachineException() throws Exception {
        this.runWithNewCluster(3, this::runTestRetryOnStateMachineException);
    }

    private void runTestRetryOnStateMachineException(CLUSTER cluster) throws Exception {
        RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
        ((MiniRaftCluster)cluster).getLeaderAndSendFirstMessage(true);
        long oldLastApplied = ((MiniRaftCluster)cluster).getLeader().getInfo().getLastAppliedIndex();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftTestUtil.SimpleMessage message = new RaftTestUtil.SimpleMessage("message");
            RaftClientRequest r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), leaderId, 999L, message);
            RaftClientReply reply = rpc.sendRequest(r);
            Assert.assertFalse((boolean)reply.isSuccess());
            Assert.assertNotNull((Object)((Object)reply.getStateMachineException()));
            for (int i = 0; i < 5; ++i) {
                reply = rpc.sendRequest(r);
                Assert.assertEquals((Object)client.getId(), (Object)reply.getClientId());
                Assert.assertEquals((long)999L, (long)reply.getCallId());
                Assert.assertFalse((boolean)reply.isSuccess());
                Assert.assertNotNull((Object)((Object)reply.getStateMachineException()));
            }
            for (RaftServer.Division server : ((MiniRaftCluster)cluster).iterateDivisions()) {
                this.LOG.info("check server " + server.getId());
                JavaUtils.attemptRepeatedly(() -> {
                    Assert.assertNotNull((Object)RetryCacheTestUtil.get(server, client.getId(), 999L));
                    return null;
                }, (int)5, (TimeDuration)BaseTest.ONE_SECOND, (String)"GetRetryEntry", (Logger)this.LOG);
                RaftLog log = server.getRaftLog();
                RaftTestUtil.logEntriesContains(log, oldLastApplied + 1L, log.getNextIndex(), message);
            }
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    @Test
    public void testRetryOnExceptionDuringReplication() throws Exception {
        this.runWithNewCluster(3, this::runTestRetryOnExceptionDuringReplication);
    }

    private void runTestRetryOnExceptionDuringReplication(CLUSTER cluster) throws Exception {
        RaftServer.Division oldLeader = RaftTestUtil.waitForLeader(cluster);
        ((MiniRaftCluster)cluster).getLeaderAndSendFirstMessage(true);
        failPreAppend = true;
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(oldLeader.getId());){
            RaftClientRpc rpc = client.getClientRpc();
            long callId = 999L;
            RaftTestUtil.SimpleMessage message = new RaftTestUtil.SimpleMessage("message");
            RaftClientRequest r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), oldLeader.getId(), 999L, message);
            RaftClientReply reply = rpc.sendRequest(r);
            Objects.requireNonNull(reply.getStateMachineException());
            RetryCache.Entry oldEntry = RetryCacheTestUtil.get(oldLeader, client.getId(), 999L);
            Assert.assertNotNull((Object)oldEntry);
            Assert.assertTrue((boolean)RetryCacheTestUtil.isFailed(oldEntry));
            Thread.sleep(100L);
            RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
            r = ((MiniRaftCluster)cluster).newRaftClientRequest(client.getId(), leader.getId(), 999L, message);
            reply = rpc.sendRequest(r);
            Objects.requireNonNull(reply.getStateMachineException());
            RetryCache.Entry currentEntry = RetryCacheTestUtil.get(leader, client.getId(), 999L);
            Assert.assertNotNull((Object)currentEntry);
            Assert.assertTrue((boolean)RetryCacheTestUtil.isFailed(currentEntry));
            Assert.assertNotEquals((Object)oldEntry, (Object)currentEntry);
            failPreAppend = false;
        }
    }

    protected static class StateMachineWithException
    extends SimpleStateMachine4Testing {
        protected StateMachineWithException() {
        }

        @Override
        public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
            CompletableFuture<Message> future = new CompletableFuture<Message>();
            future.completeExceptionally((Throwable)new StateMachineException("Fake Exception"));
            return future;
        }

        public TransactionContext preAppendTransaction(TransactionContext trx) throws IOException {
            if (failPreAppend) {
                throw new IOException("Fake Exception in preAppend");
            }
            return trx;
        }
    }
}

