/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.TimeUnit;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RetryCache;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RetryCacheImpl;
import org.apache.ratis.server.impl.TransactionManager;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLog;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public final class RetryCacheTestUtil {
    private RetryCacheTestUtil() {
    }

    public static RetryCache createRetryCache() {
        return new RetryCacheImpl(TimeDuration.valueOf((long)60L, (TimeUnit)TimeUnit.SECONDS), null);
    }

    public static void createEntry(RetryCache cache, RaftProtos.LogEntryProto logEntry) {
        if (logEntry.hasStateMachineLogEntry()) {
            ClientInvocationId invocationId = ClientInvocationId.valueOf((RaftProtos.StateMachineLogEntryProto)logEntry.getStateMachineLogEntry());
            RetryCacheTestUtil.getOrCreateEntry(cache, invocationId);
        }
    }

    public static boolean isFailed(RetryCache.Entry entry) {
        return ((RetryCacheImpl.CacheEntry)entry).isFailed();
    }

    public static void assertFailure(RetryCache cache, RaftProtos.LogEntryProto logEntry, boolean isFailed) {
        if (logEntry.hasStateMachineLogEntry()) {
            ClientInvocationId invocationId = ClientInvocationId.valueOf((RaftProtos.StateMachineLogEntryProto)logEntry.getStateMachineLogEntry());
            Assert.assertEquals((Object)isFailed, (Object)RetryCacheTestUtil.get(cache, invocationId).isFailed());
        }
    }

    public static void getOrCreateEntry(RaftServer.Division server, ClientInvocationId invocationId) {
        RetryCacheTestUtil.getOrCreateEntry(server.getRetryCache(), invocationId);
    }

    private static RetryCache.Entry getOrCreateEntry(RetryCache cache, ClientInvocationId invocationId) {
        return ((RetryCacheImpl)cache).getOrCreateEntry(invocationId);
    }

    public static RetryCache.Entry get(RaftServer.Division server, ClientId clientId, long callId) {
        return RetryCacheTestUtil.get(server.getRetryCache(), ClientInvocationId.valueOf((ClientId)clientId, (long)callId));
    }

    private static RetryCacheImpl.CacheEntry get(RetryCache cache, ClientInvocationId invocationId) {
        return ((RetryCacheImpl)cache).getIfPresent(invocationId);
    }

    public static SegmentedRaftLog newSegmentedRaftLog(RaftGroupMemberId memberId, RetryCache retryCache, RaftStorage storage, RaftProperties properties) {
        RaftServerImpl server = (RaftServerImpl)Mockito.mock(RaftServerImpl.class);
        Mockito.when((Object)server.getRetryCache()).thenReturn((Object)((RetryCacheImpl)retryCache));
        Mockito.when((Object)server.getMemberId()).thenReturn((Object)memberId);
        TransactionManager transactionManager = new TransactionManager((Object)memberId.getPeerId());
        Mockito.when((Object)server.getTransactionManager()).thenReturn((Object)transactionManager);
        ((RaftServerImpl)Mockito.doCallRealMethod().when((Object)server)).notifyTruncatedLogEntry((RaftProtos.LogEntryProto)ArgumentMatchers.any(RaftProtos.LogEntryProto.class));
        return SegmentedRaftLog.newBuilder().setMemberId(memberId).setServer((RaftServer.Division)server).setNotifyTruncatedLogEntry(arg_0 -> ((RaftServerImpl)server).notifyTruncatedLogEntry(arg_0)).setGetTransactionContext((arg_0, arg_1) -> ((RaftServerImpl)server).getTransactionContext(arg_0, arg_1)).setSubmitUpdateCommitEvent(() -> ((RaftServerImpl)server).submitUpdateCommitEvent()).setStorage(storage).setProperties(properties).build();
    }
}

