/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.util.Slf4jUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class TestRatisServerMetricsBase<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    private static final int NUM_SERVERS = 3;

    public TestRatisServerMetricsBase() {
        Slf4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Slf4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
    }

    @Test
    public void testClientFailedRequest() throws Exception {
        this.runWithNewCluster(3, this::runTestClientFailedRequest);
    }

    void runTestClientFailedRequest(CLUSTER cluster) throws InterruptedException, IOException, ExecutionException {
        RaftServer.Division leaderImpl = RaftTestUtil.waitForLeader(cluster);
        ClientId clientId = ClientId.randomId();
        RaftClientRequest r = RaftClientRequest.newBuilder().setClientId(clientId).setLeaderId(leaderImpl.getId()).setGroupId(((MiniRaftCluster)cluster).getGroupId()).setCallId(0L).setMessage(Message.EMPTY).setType(RaftClientRequest.staleReadRequestType((long)Long.MAX_VALUE)).build();
        CompletableFuture f = leaderImpl.getRaftServer().submitClientRequestAsync(r);
        Assert.assertFalse((boolean)((RaftClientReply)f.get()).isSuccess());
        Assert.assertEquals((long)1L, (long)((RaftServerMetricsImpl)leaderImpl.getRaftServerMetrics()).getNumFailedClientStaleRead().getCount());
    }
}

