/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.impl.RaftServerTestUtil;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.segmented.LogSegmentPath;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.RaftSnapshotBaseTest;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.Slf4jUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.function.CheckedConsumer;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class InstallSnapshotNotificationTests<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final Logger LOG = LoggerFactory.getLogger(InstallSnapshotNotificationTests.class);
    private static final int SNAPSHOT_TRIGGER_THRESHOLD = 64;
    private static final int PURGE_GAP = 8;
    private static final AtomicReference<SnapshotInfo> LEADER_SNAPSHOT_INFO_REF = new AtomicReference();
    private static final AtomicInteger numSnapshotRequests = new AtomicInteger();
    private static final AtomicInteger numNotifyInstallSnapshotFinished = new AtomicInteger();

    public InstallSnapshotNotificationTests() {
        Slf4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.DEBUG);
        RaftProperties prop = this.getProperties();
        prop.setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, StateMachine4InstallSnapshotNotificationTests.class, StateMachine.class);
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled((RaftProperties)prop, (boolean)false);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)prop, (long)64L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)prop, (boolean)true);
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)prop, (int)8);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)prop, (SizeInBytes)SizeInBytes.valueOf((long)1024L));
    }

    @Test
    public void testAddNewFollowers() throws Exception {
        int numRequests = 127;
        this.runWithNewCluster(1, c -> this.testAddNewFollowers(c, 127));
    }

    @Test
    public void testAddNewFollowersNoSnapshot() throws Exception {
        int numRequests = 8;
        this.runWithNewCluster(1, c -> this.testAddNewFollowers(c, 8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAddNewFollowers(CLUSTER cluster, int numRequests) throws Exception {
        List logs;
        int i;
        boolean shouldInstallSnapshot = numRequests >= 64;
        LEADER_SNAPSHOT_INFO_REF.set(null);
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeader().getId();
            try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
                for (i = 0; i < numRequests; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
            }
            if (shouldInstallSnapshot) {
                RaftServer.Division leader = ((MiniRaftCluster)cluster).getLeader();
                long nextIndex = leader.getRaftLog().getNextIndex();
                LOG.info("nextIndex = {}", (Object)nextIndex);
                List<File> snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, nextIndex - 64L, nextIndex);
                JavaUtils.attemptRepeatedly(() -> {
                    Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                    return null;
                }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
                logs = LogSegmentPath.getLogSegmentPaths((RaftStorage)leader.getRaftStorage());
            } else {
                logs = Collections.emptyList();
            }
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
        LOG.info("Delete logs {}", logs);
        for (Object path : logs) {
            FileUtils.deleteFully((Path)path.getPath());
        }
        LOG.info("Restarting the cluster");
        ((MiniRaftCluster)cluster).restart(false);
        try {
            Object path;
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
            RaftClient client = ((MiniRaftCluster)cluster).createClient(((MiniRaftCluster)cluster).getLeader().getId());
            path = null;
            try {
                Assert.assertTrue((boolean)client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
            }
            catch (Throwable nextIndex) {
                path = nextIndex;
                throw nextIndex;
            }
            finally {
                if (client != null) {
                    if (path != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable nextIndex) {
                            ((Throwable)path).addSuppressed(nextIndex);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            SnapshotInfo leaderSnapshotInfo = ((MiniRaftCluster)cluster).getLeader().getStateMachine().getLatestSnapshot();
            LOG.info("LeaderSnapshotInfo: {}", (Object)leaderSnapshotInfo.getTermIndex());
            boolean set = LEADER_SNAPSHOT_INFO_REF.compareAndSet(null, leaderSnapshotInfo);
            Assert.assertTrue((boolean)set);
            MiniRaftCluster.PeerChanges change = ((MiniRaftCluster)cluster).addNewPeers(2, true, true);
            RaftServerTestUtil.runWithMinorityPeers(cluster, Arrays.asList(change.allPeersInNewConf), (CheckedConsumer<Collection<RaftPeer>, IOException>)((CheckedConsumer)peers -> cluster.setConfiguration(peers.toArray(RaftPeer.emptyArray()))));
            RaftServerTestUtil.waitAndCheckNewConf(cluster, change.allPeersInNewConf, 0, null);
            for (RaftServer.Division follower : ((MiniRaftCluster)cluster).getFollowers()) {
                long expected = shouldInstallSnapshot ? leaderSnapshotInfo.getIndex() : -1L;
                Assert.assertEquals((long)expected, (long)RaftServerTestUtil.getLatestInstalledSnapshotIndex(follower));
                RaftSnapshotBaseTest.assertLogContent(follower, false);
            }
            ((MiniRaftCluster)cluster).restartServer(((MiniRaftCluster)cluster).getLeader().getId(), false);
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    @Test
    public void testRestartFollower() throws Exception {
        this.runWithNewCluster(3, this::testRestartFollower);
    }

    private void testRestartFollower(CLUSTER cluster) throws Exception {
        int i;
        LEADER_SNAPSHOT_INFO_REF.set(null);
        RaftServer.Division leader = RaftTestUtil.waitForLeader(cluster);
        RaftPeerId leaderId = leader.getId();
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
            for (i = 0; i < 127; ++i) {
                RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                Assert.assertTrue((boolean)reply.isSuccess());
            }
        }
        long oldLeaderNextIndex = leader.getRaftLog().getNextIndex();
        LOG.info("{}: oldLeaderNextIndex = {}", (Object)leaderId, (Object)oldLeaderNextIndex);
        List<File> snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, oldLeaderNextIndex - 64L, oldLeaderNextIndex);
        JavaUtils.attemptRepeatedly(() -> {
            Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
            return null;
        }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
        RaftPeerId followerId = ((MiniRaftCluster)cluster).getFollowers().get(0).getId();
        ((MiniRaftCluster)cluster).killServer(followerId);
        try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leader.getId());){
            Assert.assertTrue((boolean)client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
        }
        FIVE_SECONDS.sleep();
        ((MiniRaftCluster)cluster).restartServer(followerId, false);
        RaftServer.Division follower = ((MiniRaftCluster)cluster).getDivision(followerId);
        JavaUtils.attempt(() -> {
            long newLeaderNextIndex = leader.getRaftLog().getNextIndex();
            LOG.info("{}: newLeaderNextIndex = {}", (Object)leaderId, (Object)newLeaderNextIndex);
            Assert.assertTrue((newLeaderNextIndex > oldLeaderNextIndex ? 1 : 0) != 0);
            Assert.assertEquals((long)newLeaderNextIndex, (long)follower.getRaftLog().getNextIndex());
        }, (int)10, (TimeDuration)ONE_SECOND, (String)"followerNextIndex", (Logger)LOG);
    }

    @Test
    public void testInstallSnapshotNotificationCount() throws Exception {
        this.runWithNewCluster(3, this::testInstallSnapshotNotificationCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInstallSnapshotNotificationCount(CLUSTER cluster) throws Exception {
        LEADER_SNAPSHOT_INFO_REF.set(null);
        numSnapshotRequests.set(0);
        try {
            int i;
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeader().getId();
            ONE_SECOND.sleep();
            Assert.assertEquals((long)0L, (long)numSnapshotRequests.get());
            try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
                for (i = 0; i < 10; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
            }
            RaftTestUtil.waitFor(() -> cluster.getLeader().getStateMachine().getLastAppliedTermIndex().getIndex() == 20L, 300, 15000);
            long snapshotIndex = ((MiniRaftCluster)cluster).getLeader().getStateMachine().takeSnapshot();
            Assert.assertEquals((long)20L, (long)snapshotIndex);
            SnapshotInfo leaderSnapshotInfo = ((MiniRaftCluster)cluster).getLeader().getStateMachine().getLatestSnapshot();
            Assert.assertEquals((long)20L, (long)leaderSnapshotInfo.getIndex());
            boolean set = LEADER_SNAPSHOT_INFO_REF.compareAndSet(null, leaderSnapshotInfo);
            Assert.assertTrue((boolean)set);
            RaftServer.Division leader = ((MiniRaftCluster)cluster).getLeader();
            long nextIndex = leader.getRaftLog().getNextIndex();
            Assert.assertEquals((long)21L, (long)nextIndex);
            List<File> snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, 0L, nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            long snapshotInstallIndex = (Long)leader.getRaftLog().onSnapshotInstalled(leader.getRaftLog().getLastCommittedIndex()).get();
            Assert.assertEquals((long)20L, (long)snapshotInstallIndex);
            Assert.assertEquals((long)0L, (long)LogSegmentPath.getLogSegmentPaths((RaftStorage)leader.getRaftStorage()).size());
            Assert.assertEquals((long)-1L, (long)leader.getRaftLog().getStartIndex());
            ONE_SECOND.sleep();
            Assert.assertEquals((long)0L, (long)numSnapshotRequests.get());
            for (RaftServer.Division follower : ((MiniRaftCluster)cluster).getFollowers()) {
                Assert.assertEquals((long)leader.getRaftLog().getNextIndex(), (long)follower.getRaftLog().getNextIndex());
            }
            MiniRaftCluster.PeerChanges change = ((MiniRaftCluster)cluster).addNewPeers(2, true, true);
            RaftServerTestUtil.runWithMinorityPeers(cluster, Arrays.asList(change.allPeersInNewConf), (CheckedConsumer<Collection<RaftPeer>, IOException>)((CheckedConsumer)peers -> cluster.setConfiguration(peers.toArray(RaftPeer.emptyArray()))));
            RaftServerTestUtil.waitAndCheckNewConf(cluster, change.allPeersInNewConf, 0, null);
            try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leader.getId());){
                Assert.assertTrue((boolean)client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
            }
            for (RaftServer.Division follower : ((MiniRaftCluster)cluster).getFollowers()) {
                RaftTestUtil.waitFor(() -> leader.getRaftLog().getNextIndex() == follower.getRaftLog().getNextIndex(), 300, 15000);
            }
            Assert.assertEquals((long)2L, (long)numSnapshotRequests.get());
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    @Test
    public void testInstallSnapshotInstalledEvent() throws Exception {
        this.runWithNewCluster(1, this::testInstallSnapshotInstalledEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInstallSnapshotInstalledEvent(CLUSTER cluster) throws Exception {
        List logs;
        int i;
        LEADER_SNAPSHOT_INFO_REF.set(null);
        numNotifyInstallSnapshotFinished.set(0);
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeader().getId();
            try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
                for (i = 0; i < 127; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
            }
            RaftServer.Division leader = ((MiniRaftCluster)cluster).getLeader();
            long nextIndex = leader.getRaftLog().getNextIndex();
            LOG.info("nextIndex = {}", (Object)nextIndex);
            List<File> snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, nextIndex - 64L, nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            logs = LogSegmentPath.getLogSegmentPaths((RaftStorage)leader.getRaftStorage());
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
        LOG.info("Delete logs {}", (Object)logs);
        for (Object path : logs) {
            FileUtils.deleteFully((Path)path.getPath());
        }
        LOG.info("Restarting the cluster");
        ((MiniRaftCluster)cluster).restart(false);
        try {
            Object path;
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
            RaftClient client = ((MiniRaftCluster)cluster).createClient(((MiniRaftCluster)cluster).getLeader().getId());
            path = null;
            try {
                Assert.assertTrue((boolean)client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i)).isSuccess());
            }
            catch (Throwable nextIndex) {
                path = nextIndex;
                throw nextIndex;
            }
            finally {
                if (client != null) {
                    if (path != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable nextIndex) {
                            ((Throwable)path).addSuppressed(nextIndex);
                        }
                    } else {
                        client.close();
                    }
                }
            }
            SnapshotInfo leaderSnapshotInfo = ((MiniRaftCluster)cluster).getLeader().getStateMachine().getLatestSnapshot();
            LOG.info("LeaderSnapshotInfo: {}", (Object)leaderSnapshotInfo.getTermIndex());
            boolean set = LEADER_SNAPSHOT_INFO_REF.compareAndSet(null, leaderSnapshotInfo);
            Assert.assertTrue((boolean)set);
            MiniRaftCluster.PeerChanges change = ((MiniRaftCluster)cluster).addNewPeers(1, true, true);
            RaftServerTestUtil.runWithMinorityPeers(cluster, Arrays.asList(change.allPeersInNewConf), (CheckedConsumer<Collection<RaftPeer>, IOException>)((CheckedConsumer)peers -> cluster.setConfiguration(peers.toArray(RaftPeer.emptyArray()))));
            RaftServerTestUtil.waitAndCheckNewConf(cluster, change.allPeersInNewConf, 0, null);
            for (RaftServer.Division follower : ((MiniRaftCluster)cluster).getFollowers()) {
                Assert.assertEquals((long)leaderSnapshotInfo.getIndex(), (long)RaftServerTestUtil.getLatestInstalledSnapshotIndex(follower));
            }
            File leaderSnapshotFile = ((FileInfo)leaderSnapshotInfo.getFiles().get(0)).getPath().toFile();
            SimpleStateMachine4Testing followerStateMachine = (SimpleStateMachine4Testing)((MiniRaftCluster)cluster).getFollowers().get(0).getStateMachine();
            File followerSnapshotFile = new File(followerStateMachine.getStateMachineDir(), leaderSnapshotFile.getName());
            Assert.assertEquals((long)numNotifyInstallSnapshotFinished.get(), (long)2L);
            Assert.assertTrue((boolean)leaderSnapshotFile.exists());
            Assert.assertFalse((boolean)followerSnapshotFile.exists());
            ((MiniRaftCluster)cluster).restartServer(((MiniRaftCluster)cluster).getLeader().getId(), false);
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    @Test
    public void testInstallSnapshotDuringBootstrap() throws Exception {
        this.runWithNewCluster(1, this::testInstallSnapshotDuringBootstrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInstallSnapshotDuringBootstrap(CLUSTER cluster) throws Exception {
        LEADER_SNAPSHOT_INFO_REF.set(null);
        numSnapshotRequests.set(0);
        try {
            RaftTestUtil.waitForLeader(cluster);
            RaftPeerId leaderId = ((MiniRaftCluster)cluster).getLeader().getId();
            try (RaftClient client = ((MiniRaftCluster)cluster).createClient(leaderId);){
                for (int i = 0; i < 127; ++i) {
                    RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage("m" + i));
                    Assert.assertTrue((boolean)reply.isSuccess());
                }
            }
            RaftServer.Division leader = ((MiniRaftCluster)cluster).getLeader();
            long nextIndex = leader.getRaftLog().getNextIndex();
            LOG.info("nextIndex = {}", (Object)nextIndex);
            List<File> snapshotFiles = RaftSnapshotBaseTest.getSnapshotFiles(cluster, nextIndex - 64L, nextIndex);
            JavaUtils.attemptRepeatedly(() -> {
                Assert.assertTrue((boolean)snapshotFiles.stream().anyMatch(RaftSnapshotBaseTest::exists));
                return null;
            }, (int)10, (TimeDuration)ONE_SECOND, (String)"snapshotFile.exist", (Logger)LOG);
            RaftSnapshotBaseTest.assertLeaderContent(cluster);
            SnapshotInfo leaderSnapshotInfo = ((MiniRaftCluster)cluster).getLeader().getStateMachine().getLatestSnapshot();
            boolean set = LEADER_SNAPSHOT_INFO_REF.compareAndSet(null, leaderSnapshotInfo);
            Assert.assertTrue((boolean)set);
            MiniRaftCluster.PeerChanges change = ((MiniRaftCluster)cluster).addNewPeers(2, true, true);
            RaftServerTestUtil.runWithMinorityPeers(cluster, Arrays.asList(change.allPeersInNewConf), (CheckedConsumer<Collection<RaftPeer>, IOException>)((CheckedConsumer)peers -> cluster.setConfiguration(peers.toArray(RaftPeer.emptyArray()))));
            RaftServerTestUtil.waitAndCheckNewConf(cluster, change.allPeersInNewConf, 0, null);
            for (RaftServer.Division follower : ((MiniRaftCluster)cluster).getFollowers()) {
                Assert.assertEquals((long)leaderSnapshotInfo.getIndex(), (long)RaftServerTestUtil.getLatestInstalledSnapshotIndex(follower));
            }
            Assert.assertTrue((2 <= numSnapshotRequests.get() ? 1 : 0) != 0);
        }
        finally {
            ((MiniRaftCluster)cluster).shutdown();
        }
    }

    private static class StateMachine4InstallSnapshotNotificationTests
    extends SimpleStateMachine4Testing {
        private final Executor stateMachineExecutor = Executors.newSingleThreadExecutor();

        private StateMachine4InstallSnapshotNotificationTests() {
        }

        public CompletableFuture<TermIndex> notifyInstallSnapshotFromLeader(RaftProtos.RoleInfoProto roleInfoProto, TermIndex termIndex) {
            if (!roleInfoProto.getFollowerInfo().hasLeaderInfo()) {
                return JavaUtils.completeExceptionally((Throwable)new IOException("Failed notifyInstallSnapshotFromLeader due to missing leader info"));
            }
            numSnapshotRequests.incrementAndGet();
            SingleFileSnapshotInfo leaderSnapshotInfo = (SingleFileSnapshotInfo)LEADER_SNAPSHOT_INFO_REF.get();
            LOG.info("{}: leaderSnapshotInfo = {}", (Object)this.getId(), (Object)leaderSnapshotInfo);
            if (leaderSnapshotInfo == null) {
                return super.notifyInstallSnapshotFromLeader(roleInfoProto, termIndex);
            }
            Supplier<TermIndex> supplier = () -> {
                try {
                    Path leaderSnapshotFile = leaderSnapshotInfo.getFile().getPath();
                    File followerSnapshotFilePath = new File(this.getStateMachineDir(), leaderSnapshotFile.getFileName().toString());
                    Thread.sleep(1000L);
                    if (followerSnapshotFilePath.exists()) {
                        LOG.warn(followerSnapshotFilePath + " exists");
                    } else {
                        Files.copy(leaderSnapshotFile, followerSnapshotFilePath.toPath(), new CopyOption[0]);
                    }
                }
                catch (IOException | InterruptedException e) {
                    LOG.error("Failed notifyInstallSnapshotFromLeader", (Throwable)e);
                    return null;
                }
                return leaderSnapshotInfo.getTermIndex();
            };
            return CompletableFuture.supplyAsync(supplier, this.stateMachineExecutor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifySnapshotInstalled(RaftProtos.InstallSnapshotResult result, long installIndex, RaftPeer peer) {
            if (result != RaftProtos.InstallSnapshotResult.SUCCESS && result != RaftProtos.InstallSnapshotResult.SNAPSHOT_UNAVAILABLE) {
                return;
            }
            numNotifyInstallSnapshotFinished.incrementAndGet();
            SingleFileSnapshotInfo leaderSnapshotInfo = (SingleFileSnapshotInfo)LEADER_SNAPSHOT_INFO_REF.get();
            File leaderSnapshotFile = leaderSnapshotInfo.getFile().getPath().toFile();
            StateMachine4InstallSnapshotNotificationTests stateMachine4InstallSnapshotNotificationTests = this;
            synchronized (stateMachine4InstallSnapshotNotificationTests) {
                try {
                    if (((RaftServer)this.getServer().get()).getDivision(this.getGroupId()).getInfo().isLeader()) {
                        LOG.info("Receive the notification to clean up snapshot as leader for {}, result: {}", (Object)peer, (Object)result);
                        if (leaderSnapshotFile.exists()) {
                            LOG.info("leader snapshot {} existed", (Object)leaderSnapshotFile);
                        }
                    } else {
                        LOG.info("Receive the notification to clean up snapshot as follower for {}, result: {}", (Object)peer, (Object)result);
                        File followerSnapshotFile = new File(this.getStateMachineDir(), leaderSnapshotFile.getName());
                        if (followerSnapshotFile.exists()) {
                            FileUtils.deleteFile((File)followerSnapshotFile);
                            LOG.info("follower snapshot {} deleted", (Object)followerSnapshotFile);
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error("Failed to notify installSnapshot Finished", (Throwable)ex);
                }
            }
        }
    }
}

