/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.impl.OrderedAsync;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.conf.ReconfigurationBase;
import org.apache.ratis.conf.ReconfigurationException;
import org.apache.ratis.conf.ReconfigurationStatus;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachine4Testing;
import org.apache.ratis.util.Slf4jUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public abstract class TestReConfigProperty<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    private RaftProperties conf1;
    private RaftProperties conf2;
    private static final String PROP1 = "test.prop.one";
    private static final String PROP2 = "test.prop.two";
    private static final String PROP3 = "test.prop.three";
    private static final String PROP4 = "test.prop.four";
    private static final String PROP5 = "test.prop.five";
    private static final String VAL1 = "val1";
    private static final String VAL2 = "val2";
    private static final String DEFAULT = "default";

    public TestReConfigProperty() {
        Slf4jUtils.setLogLevel((Logger)OrderedAsync.LOG, (Level)Level.DEBUG);
        this.getProperties().setClass(MiniRaftCluster.STATEMACHINE_CLASS_KEY, SimpleStateMachine4Testing.class, StateMachine.class);
    }

    @Before
    public void setup() {
        this.conf1 = new RaftProperties();
        this.conf2 = new RaftProperties();
        this.conf1.set(PROP1, VAL1);
        this.conf1.set(PROP2, VAL1);
        this.conf1.set(PROP3, VAL1);
        this.conf2.set(PROP1, VAL1);
        this.conf2.set(PROP2, VAL2);
        this.conf2.set(PROP4, VAL1);
    }

    @Test
    public void testGetChangedProperty() {
        Collection changes = ReconfigurationBase.getChangedProperties((RaftProperties)this.conf2, (RaftProperties)this.conf1);
        Assert.assertTrue((String)("expected 3 changed properties but got " + changes.size()), (changes.size() == 3 ? 1 : 0) != 0);
        boolean changeFound = false;
        boolean unsetFound = false;
        boolean setFound = false;
        for (ReconfigurationStatus.PropertyChange c : changes) {
            if (c.getProperty().equals(PROP2) && c.getOldValue() != null && c.getOldValue().equals(VAL1) && c.getNewValue() != null && c.getNewValue().equals(VAL2)) {
                changeFound = true;
                continue;
            }
            if (c.getProperty().equals(PROP3) && c.getOldValue() != null && c.getOldValue().equals(VAL1) && c.getNewValue() == null) {
                unsetFound = true;
                continue;
            }
            if (!c.getProperty().equals(PROP4) || c.getOldValue() != null || c.getNewValue() == null || !c.getNewValue().equals(VAL1)) continue;
            setFound = true;
        }
        Assert.assertTrue((String)"not all changes have been applied", (changeFound && unsetFound && setFound ? 1 : 0) != 0);
    }

    @Test
    public void testReconfigure() {
        ReconfigurableDummy dummy = new ReconfigurableDummy(this.conf1);
        Assert.assertEquals((String)"test.prop.one set to wrong value ", (Object)VAL1, (Object)dummy.getProperties().get(PROP1));
        Assert.assertEquals((String)"test.prop.two set to wrong value ", (Object)VAL1, (Object)dummy.getProperties().get(PROP2));
        Assert.assertEquals((String)"test.prop.three set to wrong value ", (Object)VAL1, (Object)dummy.getProperties().get(PROP3));
        Assert.assertNull((String)"test.prop.four set to wrong value ", (Object)dummy.getProperties().get(PROP4));
        Assert.assertNull((String)"test.prop.five set to wrong value ", (Object)dummy.getProperties().get(PROP5));
        Assert.assertTrue((String)"test.prop.one should be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP1));
        Assert.assertTrue((String)"test.prop.two should be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP2));
        Assert.assertFalse((String)"test.prop.three should not be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP3));
        Assert.assertTrue((String)"test.prop.four should be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP4));
        Assert.assertFalse((String)"test.prop.five should not be reconfigurable ", (boolean)dummy.isPropertyReconfigurable(PROP5));
        boolean exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, VAL1);
            dummy.startReconfiguration();
            RaftTestUtil.waitFor(() -> dummy.getReconfigurationStatus().ended(), 100, 60000);
            Assert.assertEquals((String)"test.prop.one set to wrong value ", (Object)VAL1, (Object)dummy.getProperties().get(PROP1));
        }
        catch (IOException | InterruptedException | TimeoutException | ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, null);
            dummy.startReconfiguration();
            RaftTestUtil.waitFor(() -> dummy.getReconfigurationStatus().ended(), 100, 60000);
            Assert.assertEquals((String)"test.prop.oneset to wrong value ", (Object)DEFAULT, (Object)dummy.getProperties().get(PROP1));
        }
        catch (IOException | InterruptedException | TimeoutException | ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP1, VAL2);
            dummy.startReconfiguration();
            RaftTestUtil.waitFor(() -> dummy.getReconfigurationStatus().ended(), 100, 60000);
            Assert.assertEquals((String)"test.prop.oneset to wrong value ", (Object)VAL2, (Object)dummy.getProperties().get(PROP1));
        }
        catch (IOException | InterruptedException | TimeoutException | ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP4, null);
            dummy.startReconfiguration();
            RaftTestUtil.waitFor(() -> dummy.getReconfigurationStatus().ended(), 100, 60000);
            Assert.assertSame((String)"test.prop.fourset to wrong value ", (Object)DEFAULT, (Object)dummy.getProperties().get(PROP4));
        }
        catch (IOException | InterruptedException | TimeoutException | ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP4, VAL1);
            dummy.startReconfiguration();
            RaftTestUtil.waitFor(() -> dummy.getReconfigurationStatus().ended(), 100, 60000);
            Assert.assertEquals((String)"test.prop.fourset to wrong value ", (Object)VAL1, (Object)dummy.getProperties().get(PROP4));
        }
        catch (IOException | InterruptedException | TimeoutException | ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertFalse((String)"received unexpected exception", (boolean)exceptionCaught);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP5, null);
            dummy.startReconfiguration();
            RaftTestUtil.waitFor(() -> dummy.getReconfigurationStatus().ended(), 100, 60000);
        }
        catch (IOException | InterruptedException | TimeoutException | ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (((Throwable)dummy.getReconfigurationStatus().getChanges().get(new ReconfigurationStatus.PropertyChange(PROP5, DEFAULT, null))).getMessage().contains("Property is not reconfigurable.") && !exceptionCaught ? 1 : 0) != 0);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP5, VAL1);
            dummy.startReconfiguration();
            RaftTestUtil.waitFor(() -> dummy.getReconfigurationStatus().ended(), 100, 60000);
        }
        catch (IOException | InterruptedException | TimeoutException | ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (((Throwable)dummy.getReconfigurationStatus().getChanges().get(new ReconfigurationStatus.PropertyChange(PROP5, VAL1, null))).getMessage().contains("Property is not reconfigurable.") && !exceptionCaught ? 1 : 0) != 0);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP3, VAL2);
            dummy.startReconfiguration();
            RaftTestUtil.waitFor(() -> dummy.getReconfigurationStatus().ended(), 100, 60000);
        }
        catch (IOException | InterruptedException | TimeoutException | ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (((Throwable)dummy.getReconfigurationStatus().getChanges().get(new ReconfigurationStatus.PropertyChange(PROP3, VAL2, VAL1))).getMessage().contains("Property is not reconfigurable.") && !exceptionCaught ? 1 : 0) != 0);
        exceptionCaught = false;
        try {
            dummy.reconfigureProperty(PROP3, null);
            dummy.startReconfiguration();
            RaftTestUtil.waitFor(() -> dummy.getReconfigurationStatus().ended(), 100, 60000);
        }
        catch (IOException | InterruptedException | TimeoutException | ReconfigurationException e) {
            exceptionCaught = true;
        }
        Assert.assertTrue((String)"did not receive expected exception", (((Throwable)dummy.getReconfigurationStatus().getChanges().get(new ReconfigurationStatus.PropertyChange(PROP3, DEFAULT, VAL1))).getMessage().contains("Property is not reconfigurable.") && !exceptionCaught ? 1 : 0) != 0);
    }

    @Test
    public void testThread() throws ReconfigurationException, IOException {
        ReconfigurableDummy dummy = new ReconfigurableDummy(this.conf1);
        Assert.assertEquals((Object)VAL1, (Object)dummy.getProperties().get(PROP1));
        Thread dummyThread = new Thread(dummy);
        dummyThread.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        dummy.reconfigureProperty(PROP1, VAL2);
        dummy.startReconfiguration();
        long endWait = System.currentTimeMillis() + 2000L;
        while (dummyThread.isAlive() && System.currentTimeMillis() < endWait) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Assert.assertFalse((String)"dummy thread should not be alive", (boolean)dummyThread.isAlive());
        dummy.running = false;
        try {
            dummyThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((String)"test.prop.one is set to wrong value", (boolean)dummy.getProperties().get(PROP1).equals(VAL2));
    }

    @Test(timeout=300000L)
    public void testConfIsUpdatedOnSuccess() throws ReconfigurationException, IOException, InterruptedException, TimeoutException {
        String property = "FOO";
        String value1 = "value1";
        String value2 = "value2";
        RaftProperties conf = new RaftProperties();
        conf.set("FOO", "value1");
        RaftProperties newConf = new RaftProperties();
        newConf.set("FOO", "value2");
        ReconfigurationBase reconfigurable = this.makeReconfigurable(conf, newConf, Arrays.asList("FOO"));
        reconfigurable.reconfigureProperty("FOO", "value2");
        reconfigurable.startReconfiguration();
        RaftTestUtil.waitFor(() -> reconfigurable.getReconfigurationStatus().ended(), 100, 60000);
        Assert.assertEquals((Object)"value2", (Object)reconfigurable.getProperties().get("FOO"));
    }

    @Test(timeout=300000L)
    public void testConfIsUpdatedOnSuccessAsync() throws InterruptedException, IOException, TimeoutException {
        String property = "FOO";
        String value1 = "value1";
        String value2 = "value2";
        RaftProperties conf = new RaftProperties();
        conf.set("FOO", "value1");
        RaftProperties newConf = new RaftProperties();
        newConf.set("FOO", "value2");
        ReconfigurationBase reconfigurable = this.makeReconfigurable(conf, newConf, Arrays.asList("FOO"));
        reconfigurable.startReconfiguration();
        RaftTestUtil.waitFor(() -> reconfigurable.getReconfigurationStatus().ended(), 100, 60000);
        Assert.assertEquals((Object)"value2", (Object)reconfigurable.getProperties().get("FOO"));
    }

    @Test(timeout=300000L)
    public void testConfIsUnset() throws InterruptedException, TimeoutException, IOException {
        String property = "FOO";
        String value1 = "value1";
        RaftProperties conf = new RaftProperties();
        conf.set("FOO", "value1");
        RaftProperties newConf = new RaftProperties();
        ReconfigurationBase reconfigurable = this.makeReconfigurable(conf, newConf, Arrays.asList("FOO"));
        reconfigurable.startReconfiguration();
        RaftTestUtil.waitFor(() -> reconfigurable.getReconfigurationStatus().ended(), 100, 60000);
        Assert.assertNull((Object)reconfigurable.getProperties().get("FOO"));
    }

    @Test(timeout=300000L)
    public void testConfIsUnsetAsync() throws ReconfigurationException, IOException, TimeoutException, InterruptedException {
        String property = "FOO";
        String value1 = "value1";
        RaftProperties conf = new RaftProperties();
        conf.set("FOO", "value1");
        RaftProperties newConf = new RaftProperties();
        ReconfigurationBase reconfigurable = this.makeReconfigurable(conf, newConf, Arrays.asList("FOO"));
        reconfigurable.startReconfiguration();
        RaftTestUtil.waitFor(() -> reconfigurable.getReconfigurationStatus().ended(), 100, 60000);
        Assert.assertNull((Object)reconfigurable.getProperties().get("FOO"));
    }

    private ReconfigurationBase makeReconfigurable(RaftProperties oldProperties, final RaftProperties newProperties, final Collection<String> reconfigurableProperties) {
        return new ReconfigurationBase("tempReConfigDummy", oldProperties){

            protected RaftProperties getNewProperties() {
                return newProperties;
            }

            public String reconfigureProperty(String property, String newValue) {
                return newValue;
            }

            public Collection<String> getReconfigurableProperties() {
                return reconfigurableProperties;
            }
        };
    }

    public static class ReconfigurableDummy
    extends ReconfigurationBase
    implements Runnable {
        public volatile boolean running = true;
        private RaftProperties newProp;

        public ReconfigurableDummy(RaftProperties prop) {
            super("reConfigDummy", prop);
        }

        protected RaftProperties getNewProperties() {
            return this.newProp;
        }

        public synchronized String reconfigureProperty(String property, String newValue) throws ReconfigurationException {
            this.newProp = new RaftProperties();
            this.newProp.set(property, newValue != null ? newValue : TestReConfigProperty.DEFAULT);
            return newValue;
        }

        public Collection<String> getReconfigurableProperties() {
            return Arrays.asList(TestReConfigProperty.PROP1, TestReConfigProperty.PROP2, TestReConfigProperty.PROP4);
        }

        @Override
        public void run() {
            while (this.running && this.getProperties().get(TestReConfigProperty.PROP1).equals(TestReConfigProperty.VAL1)) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

