/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Map;
import java.util.SortedMap;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.RetryCacheImpl;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestRetryCacheMetrics {
    private static RatisMetricRegistryImpl ratisMetricRegistry;
    private static RetryCacheImpl retryCache;

    @BeforeAll
    public static void setUp() {
        RaftGroupId raftGroupId = RaftGroupId.randomId();
        RaftPeerId raftPeerId = RaftPeerId.valueOf((String)"TestId");
        RaftGroupMemberId raftGroupMemberId = RaftGroupMemberId.valueOf((RaftPeerId)raftPeerId, (RaftGroupId)raftGroupId);
        retryCache = new RetryCacheImpl(RaftServerConfigKeys.RetryCache.EXPIRY_TIME_DEFAULT, null);
        RaftServerMetricsImpl raftServerMetrics = RaftServerMetricsImpl.computeIfAbsentRaftServerMetrics((RaftGroupMemberId)raftGroupMemberId, id -> 0L, () -> ((RetryCacheImpl)retryCache).getStatistics());
        ratisMetricRegistry = (RatisMetricRegistryImpl)raftServerMetrics.getRegistry();
    }

    @AfterEach
    public void tearDown() {
        retryCache.close();
        TestRetryCacheMetrics.checkEntryCount(0L);
    }

    @Test
    public void testRetryCacheEntryCount() {
        TestRetryCacheMetrics.checkEntryCount(0L);
        ClientId clientId = ClientId.randomId();
        ClientInvocationId key = ClientInvocationId.valueOf((ClientId)clientId, (long)1L);
        RetryCacheImpl.CacheEntry entry = new RetryCacheImpl.CacheEntry(key);
        retryCache.refreshEntry(entry);
        TestRetryCacheMetrics.checkEntryCount(1L);
    }

    @Test
    public void testRetryCacheHitMissCount() {
        TestRetryCacheMetrics.checkHit(0L, 1.0);
        TestRetryCacheMetrics.checkMiss(0L, 0.0);
        ClientInvocationId invocationId = ClientInvocationId.valueOf((ClientId)ClientId.randomId(), (long)2L);
        retryCache.getOrCreateEntry(invocationId);
        TestRetryCacheMetrics.checkHit(0L, 0.0);
        TestRetryCacheMetrics.checkMiss(1L, 1.0);
        retryCache.getOrCreateEntry(invocationId);
        TestRetryCacheMetrics.checkHit(1L, 0.5);
        TestRetryCacheMetrics.checkMiss(1L, 0.5);
    }

    private static void checkHit(long count, double rate) {
        long hitCount = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheHitCount")).values().iterator().next()).getValue();
        Assertions.assertEquals((long)hitCount, (long)count);
        double hitRate = (Double)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheHitRate")).values().iterator().next()).getValue();
        Assertions.assertEquals((double)hitRate, (double)rate, (double)0.0);
    }

    private static void checkMiss(long count, double rate) {
        long missCount = (Long)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheMissCount")).values().iterator().next()).getValue();
        Assertions.assertEquals((long)missCount, (long)count);
        double missRate = (Double)((Gauge)ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheMissRate")).values().iterator().next()).getValue();
        Assertions.assertEquals((double)missRate, (double)rate, (double)0.0);
    }

    private static void checkEntryCount(long expected) {
        SortedMap map = ratisMetricRegistry.getGauges((s, metric) -> s.contains("retryCacheEntryCount"));
        Assertions.assertEquals((int)1, (int)map.size());
        Map.Entry entry = map.entrySet().iterator().next();
        Assertions.assertEquals((Object)expected, (Object)((Gauge)entry.getValue()).getValue());
    }
}

