/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import java.util.SortedMap;
import java.util.function.Supplier;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.metrics.impl.RatisMetricRegistryImpl;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.thirdparty.com.codahale.metrics.Gauge;
import org.apache.ratis.util.Preconditions;

public interface ServerMetricsTestUtils {
    public static Gauge getGaugeWithName(String gaugeName, Supplier<RatisMetricRegistry> metrics) {
        SortedMap gaugeMap = ((RatisMetricRegistryImpl)metrics.get()).getGauges((s, metric) -> s.contains(gaugeName));
        return (Gauge)gaugeMap.get(gaugeMap.firstKey());
    }

    public static Gauge getPeerCommitIndexGauge(RaftGroupMemberId serverId, RaftPeerId peerId) {
        RaftServerMetricsImpl serverMetrics = RaftServerMetricsImpl.getImpl((RaftGroupMemberId)serverId);
        if (serverMetrics == null) {
            return null;
        }
        String followerCommitIndexKey = RaftServerMetricsImpl.getPeerCommitIndexGaugeKey((RaftPeerId)peerId);
        SortedMap map = ((RatisMetricRegistryImpl)serverMetrics.getRegistry()).getGauges((s, metric) -> s.contains(followerCommitIndexKey));
        Preconditions.assertTrue((map.size() <= 1 ? 1 : 0) != 0);
        return (Gauge)map.get(map.firstKey());
    }
}

