/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.simulation;

import java.util.Objects;
import org.apache.ratis.client.ClientFactory;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.ServerFactory;
import org.apache.ratis.server.simulation.RaftServerReply;
import org.apache.ratis.server.simulation.RaftServerRequest;
import org.apache.ratis.server.simulation.SimulatedClientRpc;
import org.apache.ratis.server.simulation.SimulatedRequestReply;
import org.apache.ratis.server.simulation.SimulatedServerRpc;
import org.apache.ratis.util.JavaUtils;

public class SimulatedRpc
implements RpcType {
    static final SimulatedRpc INSTANCE = new SimulatedRpc();

    public static SimulatedRpc get() {
        return INSTANCE;
    }

    public String name() {
        return this.getClass().getName();
    }

    public Factory newFactory(Parameters parameters) {
        return new Factory(parameters);
    }

    static class Factory
    implements ServerFactory,
    ClientFactory {
        static String SERVER_REQUEST_REPLY_KEY = "raft.simulated.serverRequestReply";
        static String CLIENT_TO_SERVER_REQUEST_REPLY_KEY = "raft.simulated.client2serverRequestReply";
        private final SimulatedRequestReply<RaftServerRequest, RaftServerReply> serverRequestReply;
        private final SimulatedClientRpc client2serverRequestReply;

        static Parameters newRaftParameters(SimulatedRequestReply<RaftServerRequest, RaftServerReply> server, SimulatedClientRpc client2server) {
            Parameters p = new Parameters();
            p.put(SERVER_REQUEST_REPLY_KEY, server, SimulatedRequestReply.class);
            p.put(CLIENT_TO_SERVER_REQUEST_REPLY_KEY, (Object)client2server, SimulatedClientRpc.class);
            return p;
        }

        Factory(Parameters parameters) {
            this.serverRequestReply = (SimulatedRequestReply)JavaUtils.cast((Object)parameters.getNonNull(SERVER_REQUEST_REPLY_KEY, SimulatedRequestReply.class));
            this.client2serverRequestReply = (SimulatedClientRpc)parameters.getNonNull(CLIENT_TO_SERVER_REQUEST_REPLY_KEY, SimulatedClientRpc.class);
        }

        public SimulatedServerRpc newRaftServerRpc(RaftServer server) {
            return new SimulatedServerRpc(server, Objects.requireNonNull(this.serverRequestReply), Objects.requireNonNull(this.client2serverRequestReply));
        }

        public SimulatedClientRpc newRaftClientRpc(ClientId clientId, RaftProperties properties) {
            return Objects.requireNonNull(this.client2serverRequestReply);
        }

        public RpcType getRpcType() {
            return INSTANCE;
        }
    }
}

