/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.simulation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.simulation.RaftServerReply;
import org.apache.ratis.server.simulation.RaftServerRequest;
import org.apache.ratis.server.simulation.RequestHandler;
import org.apache.ratis.server.simulation.SimulatedRequestReply;
import org.apache.ratis.server.simulation.SimulatedRpc;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimulatedServerRpc
implements RaftServerRpc {
    static final Logger LOG = LoggerFactory.getLogger(SimulatedServerRpc.class);
    static final AtomicInteger THREAD_COUNT = new AtomicInteger(0);
    private final RaftServer server;
    private final RequestHandler<RaftServerRequest, RaftServerReply> serverHandler;
    private final RequestHandler<RaftClientRequest, RaftClientReply> clientHandler;
    private final ExecutorService executor = Executors.newFixedThreadPool(3, t -> Daemon.newBuilder().setName("SimulatedServerRpc-" + THREAD_COUNT.incrementAndGet()).setRunnable(t).build());
    final RequestHandler.HandlerInterface<RaftServerRequest, RaftServerReply> serverHandlerImpl = new RequestHandler.HandlerInterface<RaftServerRequest, RaftServerReply>(){

        @Override
        public boolean isAlive() {
            return !SimulatedServerRpc.this.server.getLifeCycleState().isClosingOrClosed();
        }

        @Override
        public RaftServerReply handleRequest(RaftServerRequest r) throws IOException {
            if (r.isAppendEntries()) {
                return new RaftServerReply(SimulatedServerRpc.this.server.appendEntries(r.getAppendEntries()));
            }
            if (r.isRequestVote()) {
                return new RaftServerReply(SimulatedServerRpc.this.server.requestVote(r.getRequestVote()));
            }
            if (r.isInstallSnapshot()) {
                return new RaftServerReply(SimulatedServerRpc.this.server.installSnapshot(r.getInstallSnapshot()));
            }
            if (r.isStartLeaderElection()) {
                return new RaftServerReply(SimulatedServerRpc.this.server.startLeaderElection(r.getStartLeaderElection()));
            }
            throw new IllegalStateException("unexpected state");
        }
    };
    final RequestHandler.HandlerInterface<RaftClientRequest, RaftClientReply> clientHandlerImpl = new RequestHandler.HandlerInterface<RaftClientRequest, RaftClientReply>(){

        @Override
        public boolean isAlive() {
            return !SimulatedServerRpc.this.server.getLifeCycleState().isClosingOrClosed();
        }

        @Override
        public RaftClientReply handleRequest(RaftClientRequest request) throws IOException {
            CompletableFuture<Object> future = request instanceof GroupManagementRequest ? CompletableFuture.completedFuture(SimulatedServerRpc.this.server.groupManagement((GroupManagementRequest)request)) : (request instanceof GroupListRequest ? CompletableFuture.completedFuture(SimulatedServerRpc.this.server.getGroupList((GroupListRequest)request)) : (request instanceof GroupInfoRequest ? CompletableFuture.completedFuture(SimulatedServerRpc.this.server.getGroupInfo((GroupInfoRequest)request)) : (request instanceof SetConfigurationRequest ? SimulatedServerRpc.this.server.setConfigurationAsync((SetConfigurationRequest)request) : (request instanceof TransferLeadershipRequest ? SimulatedServerRpc.this.server.transferLeadershipAsync((TransferLeadershipRequest)request) : (request instanceof SnapshotManagementRequest ? SimulatedServerRpc.this.server.snapshotManagementAsync((SnapshotManagementRequest)request) : (request instanceof LeaderElectionManagementRequest ? SimulatedServerRpc.this.server.leaderElectionManagementAsync((LeaderElectionManagementRequest)request) : SimulatedServerRpc.this.server.submitClientRequestAsync(request)))))));
            future.whenCompleteAsync((reply, exception) -> {
                try {
                    IOException e = exception == null ? null : IOUtils.asIOException((Throwable)JavaUtils.unwrapCompletionException((Throwable)exception));
                    SimulatedServerRpc.this.clientHandler.getRpc().sendReply(request, (RaftClientReply)reply, e);
                }
                catch (IOException e) {
                    LOG.warn("Failed to send reply {} for request {}", new Object[]{reply, request, e});
                }
            }, (Executor)SimulatedServerRpc.this.executor);
            return null;
        }
    };

    SimulatedServerRpc(RaftServer server, SimulatedRequestReply<RaftServerRequest, RaftServerReply> serverRequestReply, SimulatedRequestReply<RaftClientRequest, RaftClientReply> clientRequestReply) {
        this.server = server;
        Supplier<String> id = () -> server.getId().toString();
        this.serverHandler = new RequestHandler<RaftServerRequest, RaftServerReply>(id, "serverHandler", serverRequestReply, this.serverHandlerImpl, 3);
        this.clientHandler = new RequestHandler<RaftClientRequest, RaftClientReply>(id, "clientHandler", clientRequestReply, this.clientHandlerImpl, 3);
    }

    public SimulatedRpc getRpcType() {
        return SimulatedRpc.INSTANCE;
    }

    public void start() {
        this.serverHandler.startDaemon();
        this.clientHandler.startDaemon();
    }

    private void interruptAndJoin() throws InterruptedException {
        this.clientHandler.interruptAndJoinDaemon();
        this.serverHandler.interruptAndJoinDaemon();
    }

    public void close() {
        try {
            this.interruptAndJoin();
            this.executor.shutdown();
            this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        this.clientHandler.shutdown();
        this.serverHandler.shutdown();
    }

    public InetSocketAddress getInetSocketAddress() {
        return null;
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        RaftServerReply reply = this.serverHandler.getRpc().sendRequest(new RaftServerRequest(request));
        return reply.getAppendEntries();
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftServerReply reply = this.serverHandler.getRpc().sendRequest(new RaftServerRequest(request));
        return reply.getInstallSnapshot();
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        RaftServerReply reply = this.serverHandler.getRpc().sendRequest(new RaftServerRequest(request));
        return reply.getRequestVote();
    }

    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        RaftServerReply reply = this.serverHandler.getRpc().sendRequest(new RaftServerRequest(request));
        return reply.getStartLeaderElection();
    }

    public void addRaftPeers(Collection<RaftPeer> peers) {
    }

    public void handleException(RaftPeerId serverId, Exception e, boolean reconnect) {
    }
}

